/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeExtractor {
    public Node extractNode(Node parentNode, List<String> xpath) {
        LinkedList xpathStack = Lists.newLinkedList((Iterable)((Iterable)Preconditions.checkNotNull(xpath, (Object)"Null xpath list")));
        Node node = parentNode;
        boolean wasMatch = false;
        block0: while (!xpathStack.isEmpty() && node != null) {
            wasMatch = false;
            String localName = (String)xpathStack.pop();
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String childName = childNode.getLocalName();
                if (childName == null || childName.contains(":")) {
                    childName = childNode.getNodeName();
                }
                if (!localName.equals(childName)) continue;
                node = childNode;
                wasMatch = true;
                continue block0;
            }
        }
        return wasMatch ? node : null;
    }
}

