/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.factory;

import com.google.api.ads.common.lib.client.AdsServiceClient;
import com.google.api.ads.common.lib.client.AdsServiceDescriptor;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.factory.BaseAdsServiceClientFactory;
import com.google.api.ads.common.lib.factory.helper.AdsServiceClientFactoryHelper;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.FactoryModuleBuilder;

public class FactoryModule<C extends AdsServiceClient<S, D>, D extends AdsServiceDescriptor, S extends AdsSession, H extends AdsServiceClientFactoryHelper<C, S, D>, F extends BaseAdsServiceClientFactory<C, S, D>>
extends AbstractModule {
    private final TypeLiteral<AdsServiceClientFactoryInterface<C, S, D>> adsServiceClientFactoryTypeLiteral;
    private final TypeLiteral<AdsServiceDescriptorFactoryInterface<D>> adsServiceDescriptorFactoryTypeLiteral;
    private final TypeLiteral<C> adsServiceClientTypeLiteral;
    private final TypeLiteral<D> adsServiceDescriptorTypeLiteral;
    private final Class<H> factoryHelperClass;
    private final Class<F> factoryClass;

    public FactoryModule(TypeLiteral<AdsServiceClientFactoryInterface<C, S, D>> adsServiceClientFactoryTypeLiteral, TypeLiteral<AdsServiceDescriptorFactoryInterface<D>> adsServiceDescriptorFactoryTypeLiteral, TypeLiteral<C> adsServiceClientTypeLiteral, TypeLiteral<D> adsServiceDescriptorTypeLiteral, Class<H> adsServiceClientFactoryHelperClass, Class<F> baseAdsServiceClientFactoryClass) {
        this.adsServiceClientFactoryTypeLiteral = adsServiceClientFactoryTypeLiteral;
        this.adsServiceDescriptorFactoryTypeLiteral = adsServiceDescriptorFactoryTypeLiteral;
        this.adsServiceClientTypeLiteral = adsServiceClientTypeLiteral;
        this.adsServiceDescriptorTypeLiteral = adsServiceDescriptorTypeLiteral;
        this.factoryHelperClass = adsServiceClientFactoryHelperClass;
        this.factoryClass = baseAdsServiceClientFactoryClass;
    }

    protected void configure() {
        this.install(new FactoryModuleBuilder().implement(this.adsServiceClientTypeLiteral, this.adsServiceClientTypeLiteral).build(this.adsServiceClientFactoryTypeLiteral));
        this.install(new FactoryModuleBuilder().implement(this.adsServiceDescriptorTypeLiteral, this.adsServiceDescriptorTypeLiteral).build(this.adsServiceDescriptorFactoryTypeLiteral));
        this.bind(AdsServiceClientFactoryHelper.class).to(this.factoryHelperClass);
        this.bind(this.factoryClass);
    }

    public static interface AdsServiceDescriptorFactoryInterface<D extends AdsServiceDescriptor> {
        public D create(@Assisted(value="interfaceClass") Class<?> var1, @Assisted(value="version") String var2);
    }

    public static interface AdsServiceClientFactoryInterface<C extends AdsServiceClient<S, D>, S extends AdsSession, D extends AdsServiceDescriptor> {
        public C create(@Assisted(value="soapClient") Object var1, @Assisted(value="adsServiceDescriptor") D var2, @Assisted(value="adsSession") S var3);
    }
}

