/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap;

import com.google.api.ads.common.lib.auth.AuthorizationHeaderProvider;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.soap.SoapClientHandlerInterface;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class AuthorizationHeaderHandler {
    private final SoapClientHandlerInterface soapClientHandler;
    private final AuthorizationHeaderProvider authorizationHeaderProvider;

    @Inject
    public AuthorizationHeaderHandler(SoapClientHandlerInterface soapClientHandler, AuthorizationHeaderProvider authorizationHeaderProvider) {
        this.soapClientHandler = soapClientHandler;
        this.authorizationHeaderProvider = authorizationHeaderProvider;
    }

    public void setAuthorization(Object soapClient, AdsSession adsSession) throws AuthenticationException {
        final String authorizationHeader = this.authorizationHeaderProvider.getAuthorizationHeader(adsSession, this.soapClientHandler.getEndpointAddress(soapClient));
        this.soapClientHandler.putAllHttpHeaders(soapClient, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("Authorization", authorizationHeader);
            }
        });
    }
}

