/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201509.shopping;

import com.google.api.ads.adwords.axis.factory.AdWordsServices;
import com.google.api.ads.adwords.axis.utils.ProductPartitionTreeInterface;
import com.google.api.ads.adwords.axis.utils.v201509.SelectorBuilder;
import com.google.api.ads.adwords.axis.utils.v201509.shopping.ProductDimensionComparator;
import com.google.api.ads.adwords.axis.utils.v201509.shopping.ProductPartitionNode;
import com.google.api.ads.adwords.axis.utils.v201509.shopping.ProductPartitionNodeAdapter;
import com.google.api.ads.adwords.axis.utils.v201509.shopping.ProductPartitionNodeDiffer;
import com.google.api.ads.adwords.axis.v201509.cm.AdGroup;
import com.google.api.ads.adwords.axis.v201509.cm.AdGroupCriterion;
import com.google.api.ads.adwords.axis.v201509.cm.AdGroupCriterionOperation;
import com.google.api.ads.adwords.axis.v201509.cm.AdGroupCriterionPage;
import com.google.api.ads.adwords.axis.v201509.cm.AdGroupCriterionServiceInterface;
import com.google.api.ads.adwords.axis.v201509.cm.AdGroupPage;
import com.google.api.ads.adwords.axis.v201509.cm.AdGroupServiceInterface;
import com.google.api.ads.adwords.axis.v201509.cm.ApiException;
import com.google.api.ads.adwords.axis.v201509.cm.BidSource;
import com.google.api.ads.adwords.axis.v201509.cm.BiddableAdGroupCriterion;
import com.google.api.ads.adwords.axis.v201509.cm.BiddingStrategyConfiguration;
import com.google.api.ads.adwords.axis.v201509.cm.Bids;
import com.google.api.ads.adwords.axis.v201509.cm.CpcBid;
import com.google.api.ads.adwords.axis.v201509.cm.Money;
import com.google.api.ads.adwords.axis.v201509.cm.Operator;
import com.google.api.ads.adwords.axis.v201509.cm.ProductDimension;
import com.google.api.ads.adwords.axis.v201509.cm.ProductPartition;
import com.google.api.ads.adwords.axis.v201509.cm.ProductPartitionType;
import com.google.api.ads.adwords.axis.v201509.cm.Selector;
import com.google.api.ads.adwords.axis.v201509.cm.UserStatus;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.selectorfields.EntityField;
import com.google.api.ads.adwords.lib.selectorfields.v201509.cm.AdGroupCriterionField;
import com.google.api.ads.adwords.lib.selectorfields.v201509.cm.AdGroupField;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

class ProductPartitionTreeImpl
implements ProductPartitionTreeInterface<ProductPartitionNode, AdGroupCriterionOperation> {
    private final Iterator<Long> idGenerator;
    private final long adGroupId;
    private final BiddingStrategyConfiguration biddingStrategyConfig;
    private final ProductPartitionNode root;
    private final ProductPartitionNode originalRoot;
    private final Comparator<ProductDimension> dimensionComparator;
    private static final int PAGE_SIZE = 100;
    static final ImmutableList<AdGroupCriterionField> REQUIRED_SELECTOR_FIELD_ENUMS = ImmutableList.of((Object)AdGroupCriterionField.AdGroupId, (Object)AdGroupCriterionField.Id, (Object)AdGroupCriterionField.ParentCriterionId, (Object)AdGroupCriterionField.PartitionType, (Object)AdGroupCriterionField.CriteriaType, (Object)AdGroupCriterionField.CaseValue, (Object)AdGroupCriterionField.CpcBid, (Object)AdGroupCriterionField.CpcBidSource, (Object)AdGroupCriterionField.Status);

    ProductPartitionTreeImpl(long adGroupId, BiddingStrategyConfiguration biddingStrategyConfig, ProductPartitionNode rootNode) {
        long startingTempId;
        this.adGroupId = adGroupId;
        this.biddingStrategyConfig = (BiddingStrategyConfiguration)Preconditions.checkNotNull((Object)biddingStrategyConfig, (Object)"Null bidding strategy configuration");
        this.root = (ProductPartitionNode)Preconditions.checkNotNull((Object)rootNode, (Object)"Null root node");
        this.dimensionComparator = new ProductDimensionComparator();
        if (this.root.getProductPartitionId() < 0L) {
            this.originalRoot = null;
            startingTempId = -1L;
        } else {
            this.originalRoot = new ProductPartitionNode(null, this.root.getDimension(), this.root.getProductPartitionId(), this.dimensionComparator);
            long minimumId = ProductPartitionTreeImpl.cloneChildrenToNewParent(this.originalRoot, this.root.getChildren(), this.originalRoot.getProductPartitionId());
            startingTempId = minimumId >= 0L ? -1L : minimumId - 1L;
        }
        this.idGenerator = new AbstractSequentialIterator<Long>(Long.valueOf(startingTempId)){

            protected Long computeNext(Long previous) {
                return Long.MIN_VALUE == previous ? null : Long.valueOf(previous - 1L);
            }
        };
    }

    static ProductPartitionTreeImpl createAdGroupTree(AdWordsServices services, AdWordsSession session, Long adGroupId) throws ApiException, RemoteException {
        AdGroupCriterionPage adGroupCriterionPage;
        AdGroupCriterionServiceInterface criterionService = (AdGroupCriterionServiceInterface)services.get((AdsSession)session, AdGroupCriterionServiceInterface.class);
        SelectorBuilder selectorBuilder = new SelectorBuilder().fields((EntityField[])REQUIRED_SELECTOR_FIELD_ENUMS.toArray((Object[])new AdGroupCriterionField[REQUIRED_SELECTOR_FIELD_ENUMS.size()])).equals((EntityField)AdGroupCriterionField.AdGroupId, adGroupId.toString()).equals((EntityField)AdGroupCriterionField.CriteriaType, "PRODUCT_PARTITION").in((EntityField)AdGroupCriterionField.Status, UserStatus.ENABLED.getValue(), UserStatus.PAUSED.getValue()).limit(100);
        LinkedListMultimap parentIdMap = LinkedListMultimap.create();
        int offset = 0;
        do {
            if ((adGroupCriterionPage = criterionService.get(selectorBuilder.build())) == null || adGroupCriterionPage.getEntries() == null) continue;
            for (AdGroupCriterion adGroupCriterion : adGroupCriterionPage.getEntries()) {
                ProductPartition partition = (ProductPartition)adGroupCriterion.getCriterion();
                parentIdMap.put((Object)partition.getParentCriterionId(), (Object)adGroupCriterion);
            }
            offset += adGroupCriterionPage.getEntries().length;
            selectorBuilder.increaseOffsetBy(100);
        } while (offset < adGroupCriterionPage.getTotalNumEntries());
        if (!parentIdMap.containsKey(null)) {
            Preconditions.checkState((boolean)parentIdMap.isEmpty(), (Object)"No root criterion found in the tree but the tree is not empty");
            return ProductPartitionTreeImpl.createEmptyAdGroupTree(adGroupId, ProductPartitionTreeImpl.getAdGroupBiddingStrategyConfiguration(services, session, adGroupId));
        }
        return ProductPartitionTreeImpl.createNonEmptyAdGroupTree(adGroupId, (ListMultimap<Long, AdGroupCriterion>)parentIdMap);
    }

    static ProductPartitionTreeImpl createAdGroupTree(Long adGroupId, BiddingStrategyConfiguration biddingStrategyConfig, List<AdGroupCriterion> adGroupCriteria) {
        Preconditions.checkNotNull((Object)adGroupId, (Object)"Null ad group ID");
        Preconditions.checkNotNull((Object)biddingStrategyConfig, (Object)"Null bidding strategy configuration");
        Preconditions.checkNotNull(adGroupCriteria, (Object)"Null criteria list");
        if (adGroupCriteria.isEmpty()) {
            return ProductPartitionTreeImpl.createEmptyAdGroupTree(adGroupId, biddingStrategyConfig);
        }
        LinkedListMultimap parentIdMap = LinkedListMultimap.create();
        for (AdGroupCriterion adGroupCriterion : adGroupCriteria) {
            Preconditions.checkNotNull((Object)adGroupCriterion.getCriterion(), (Object)"AdGroupCriterion has a null criterion");
            if (adGroupCriterion instanceof BiddableAdGroupCriterion) {
                BiddableAdGroupCriterion biddableCriterion = (BiddableAdGroupCriterion)adGroupCriterion;
                Preconditions.checkNotNull((Object)biddableCriterion.getUserStatus(), (String)"User status is null for criterion ID %s", (Object[])new Object[]{biddableCriterion.getCriterion().getId()});
                if (UserStatus.REMOVED.equals(biddableCriterion.getUserStatus())) continue;
            }
            if (!(adGroupCriterion.getCriterion() instanceof ProductPartition)) continue;
            ProductPartition partition = (ProductPartition)adGroupCriterion.getCriterion();
            parentIdMap.put((Object)partition.getParentCriterionId(), (Object)adGroupCriterion);
        }
        return ProductPartitionTreeImpl.createNonEmptyAdGroupTree(adGroupId, (ListMultimap<Long, AdGroupCriterion>)parentIdMap);
    }

    private static long cloneChildrenToNewParent(ProductPartitionNode newParent, Iterable<ProductPartitionNode> children, Long minimumId) {
        long updatedMinimumId = minimumId == null ? Long.MAX_VALUE : minimumId;
        for (ProductPartitionNode childNode : children) {
            newParent.asSubdivision();
            ProductPartitionNode newChild = newParent.addChild(childNode.getDimension());
            newChild = ProductPartitionNode.copyProperties(childNode, newChild);
            updatedMinimumId = Math.min(updatedMinimumId, newChild.getProductPartitionId() == null ? Long.MAX_VALUE : newChild.getProductPartitionId());
            updatedMinimumId = ProductPartitionTreeImpl.cloneChildrenToNewParent(newChild, childNode.getChildren(), updatedMinimumId);
        }
        return updatedMinimumId;
    }

    private static ProductPartitionTreeImpl createNonEmptyAdGroupTree(Long adGroupId, ListMultimap<Long, AdGroupCriterion> parentIdMap) {
        Preconditions.checkNotNull((Object)adGroupId, (Object)"Null ad group ID");
        Preconditions.checkArgument((!parentIdMap.isEmpty() ? 1 : 0) != 0, (String)"parentIdMap passed for ad group ID %s is empty", (Object[])new Object[]{adGroupId});
        Preconditions.checkArgument((boolean)parentIdMap.containsKey(null), (String)"No root criterion found in the list of ad group criteria for ad group ID %s", (Object[])new Object[]{adGroupId});
        AdGroupCriterion rootCriterion = (AdGroupCriterion)Iterables.getOnlyElement((Iterable)parentIdMap.get(null));
        Preconditions.checkState((boolean)(rootCriterion instanceof BiddableAdGroupCriterion), (String)"Root criterion for ad group ID %s is not a BiddableAdGroupCriterion", (Object[])new Object[]{adGroupId});
        BiddableAdGroupCriterion biddableRootCriterion = (BiddableAdGroupCriterion)rootCriterion;
        BiddingStrategyConfiguration biddingStrategyConfig = biddableRootCriterion.getBiddingStrategyConfiguration();
        Preconditions.checkState((biddingStrategyConfig != null ? 1 : 0) != 0, (String)"Null bidding strategy config on the root node of ad group ID %s", (Object[])new Object[]{adGroupId});
        ProductPartitionNode rootNode = new ProductPartitionNode(null, null, rootCriterion.getCriterion().getId(), new ProductDimensionComparator());
        Money rootNodeBid = ProductPartitionTreeImpl.getBid(biddableRootCriterion);
        if (rootNodeBid != null) {
            rootNode = rootNode.asBiddableUnit().setBid(rootNodeBid.getMicroAmount());
        }
        ProductPartitionTreeImpl.addChildNodes(rootNode, parentIdMap);
        return new ProductPartitionTreeImpl(adGroupId, biddingStrategyConfig, rootNode);
    }

    private static ProductPartitionTreeImpl createEmptyAdGroupTree(Long adGroupId, BiddingStrategyConfiguration biddingStrategyConfig) {
        Preconditions.checkNotNull((Object)adGroupId, (Object)"Null ad group ID");
        Preconditions.checkNotNull((Object)biddingStrategyConfig, (Object)"Null bidding strategy configuration");
        ProductPartitionNode rootNode = new ProductPartitionNode(null, null, -1L, new ProductDimensionComparator());
        return new ProductPartitionTreeImpl(adGroupId, biddingStrategyConfig, rootNode);
    }

    @Override
    public Long getAdGroupId() {
        return this.adGroupId;
    }

    @Override
    public ProductPartitionNode getRoot() {
        return this.root;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("adGroupId", this.adGroupId).append("biddingStrategyConfig", (Object)this.biddingStrategyConfig).append("originalRoot is empty", this.originalRoot == null).append("root", (Object)String.format("%n%s", this.root.toDetailedString())).toString();
    }

    @Override
    public List<AdGroupCriterionOperation> getMutateOperations() {
        return Lists.transform(this.createMutateOperationPairs(), (Function)new Function<OperationPair, AdGroupCriterionOperation>(){

            public AdGroupCriterionOperation apply(OperationPair input) {
                return input.operation;
            }
        });
    }

    private List<OperationPair> createMutateOperationPairs() {
        ArrayList ops = Lists.newArrayList();
        if (this.originalRoot == null) {
            return this.createAddOperations(this.root);
        }
        Set<ProductDimension> dimensionsToProcess = this.addMutateOperations(this.originalRoot, this.root, ops);
        this.addMutateOperationsByParent(this.originalRoot, this.root, dimensionsToProcess, ops);
        return ops;
    }

    private void addMutateOperationsByParent(ProductPartitionNode originalParentNode, ProductPartitionNode newParentNode, Set<ProductDimension> childDimensionsToProcess, List<OperationPair> ops) {
        for (ProductDimension dimensionToProcess : childDimensionsToProcess) {
            ProductPartitionNode newChild;
            ProductPartitionNode originalChild = originalParentNode.hasChild(dimensionToProcess) ? originalParentNode.getChild(dimensionToProcess) : null;
            Set<ProductDimension> grandchildDimensionsToProcess = this.addMutateOperations(originalChild, newChild = newParentNode.hasChild(dimensionToProcess) ? newParentNode.getChild(dimensionToProcess) : null, ops);
            if (grandchildDimensionsToProcess.isEmpty()) continue;
            Preconditions.checkState((originalChild != null ? 1 : 0) != 0, (Object)"Original child should not be null if there are children to process");
            Preconditions.checkState((newChild != null ? 1 : 0) != 0, (Object)"New child should not be null if there are children to process");
            this.addMutateOperationsByParent(originalChild, newChild, grandchildDimensionsToProcess, ops);
        }
    }

    private Set<ProductDimension> addMutateOperations(@Nullable ProductPartitionNode originalNode, @Nullable ProductPartitionNode newNode, List<OperationPair> ops) {
        boolean isProcessChildren;
        TreeSet childDimensionsToProcess = Sets.newTreeSet(this.dimensionComparator);
        ProductPartitionNodeDiffer.NodeDifference nodeDifference = ProductPartitionNodeDiffer.diff(originalNode, newNode, this.dimensionComparator);
        switch (nodeDifference) {
            case NEW_NODE: {
                ops.addAll(this.createAddOperations(newNode));
                isProcessChildren = false;
                break;
            }
            case REMOVED_NODE: {
                ops.add(this.createRemoveOperation(originalNode));
                isProcessChildren = false;
                break;
            }
            case PARTITION_TYPE_CHANGE: 
            case EXCLUDED_UNIT_CHANGE: {
                ops.add(this.createRemoveOperation(originalNode));
                ops.addAll(this.createAddOperations(newNode));
                isProcessChildren = false;
                break;
            }
            case BID_CHANGE: {
                newNode = newNode.setProductPartitionId(originalNode.getProductPartitionId());
                ops.add(this.createSetBidOperation(newNode));
                isProcessChildren = true;
                break;
            }
            case NONE: {
                newNode = newNode.setProductPartitionId(originalNode.getProductPartitionId());
                isProcessChildren = true;
                break;
            }
            default: {
                String string = String.valueOf((Object)nodeDifference);
                throw new IllegalStateException(new StringBuilder(25 + String.valueOf(string).length()).append("Unrecognized difference: ").append(string).toString());
            }
        }
        if (isProcessChildren) {
            for (ProductPartitionNode childNode : Iterables.concat(originalNode.getChildren(), newNode.getChildren())) {
                childDimensionsToProcess.add(childNode.getDimension());
            }
        }
        return childDimensionsToProcess;
    }

    private OperationPair createSetBidOperation(ProductPartitionNode node) {
        Preconditions.checkNotNull((Object)node.getProductPartitionId(), (String)"Node for SET operation has no partition ID: %s", (Object[])new Object[]{node});
        Preconditions.checkArgument((node.getProductPartitionId() >= 0L ? 1 : 0) != 0, (String)"Node for SET operation has a negative partition ID: %s", (Object[])new Object[]{node});
        AdGroupCriterionOperation setOp = new AdGroupCriterionOperation();
        setOp.setOperator(Operator.SET);
        setOp.setOperand(ProductPartitionNodeAdapter.createCriterionForSetBid(node, this.adGroupId, this.getBiddingStrategyConfiguration()));
        return new OperationPair(node, setOp);
    }

    private List<OperationPair> createAddOperations(ProductPartitionNode node) {
        AdGroupCriterionOperation addOp = new AdGroupCriterionOperation();
        addOp.setOperator(Operator.ADD);
        node.setProductPartitionId(this.idGenerator.next());
        addOp.setOperand(ProductPartitionNodeAdapter.createCriterionForAdd(node, this.adGroupId, this.getBiddingStrategyConfiguration()));
        ArrayList operationsList = Lists.newArrayList();
        operationsList.add(new OperationPair(node, addOp));
        for (ProductPartitionNode child : node.getChildren()) {
            operationsList.addAll(this.createAddOperations(child));
        }
        return operationsList;
    }

    private OperationPair createRemoveOperation(ProductPartitionNode node) {
        Preconditions.checkNotNull((Object)node.getProductPartitionId(), (String)"Node for REMOVE operation has no partition ID: %s", (Object[])new Object[]{node});
        Preconditions.checkArgument((node.getProductPartitionId() >= 0L ? 1 : 0) != 0, (String)"Node for REMOVE operation has a negative partition ID: %s", (Object[])new Object[]{node});
        AdGroupCriterionOperation removeOp = new AdGroupCriterionOperation();
        removeOp.setOperator(Operator.REMOVE);
        removeOp.setOperand(ProductPartitionNodeAdapter.createCriterionForRemove(node, this.adGroupId));
        return new OperationPair(node, removeOp);
    }

    private BiddingStrategyConfiguration getBiddingStrategyConfiguration() {
        BiddingStrategyConfiguration copy = new BiddingStrategyConfiguration();
        return copy;
    }

    private static BiddingStrategyConfiguration getAdGroupBiddingStrategyConfiguration(AdWordsServices services, AdWordsSession session, Long adGroupId) throws ApiException, RemoteException {
        Selector selector;
        AdGroupServiceInterface adGroupService = (AdGroupServiceInterface)services.get((AdsSession)session, AdGroupServiceInterface.class);
        AdGroupPage adGroupPage = adGroupService.get(selector = new SelectorBuilder().fields(new EntityField[]{AdGroupField.Id, AdGroupField.BiddingStrategyType, AdGroupField.BiddingStrategyId, AdGroupField.BiddingStrategyName}).equalsId(adGroupId).build());
        if (adGroupPage.getEntries() == null || adGroupPage.getEntries().length == 0) {
            String string = String.valueOf(adGroupId);
            throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append("No ad group found with ID ").append(string).toString());
        }
        AdGroup adGroup = adGroupPage.getEntries(0);
        Preconditions.checkState((adGroup.getBiddingStrategyConfiguration() != null ? 1 : 0) != 0, (String)"Unexpected state - ad group ID %s has a null BiddingStrategyConfiguration", (Object[])new Object[]{adGroupId});
        return adGroup.getBiddingStrategyConfiguration();
    }

    private static void addChildNodes(ProductPartitionNode parentNode, ListMultimap<Long, AdGroupCriterion> parentIdMap) {
        if (parentIdMap.containsKey((Object)parentNode.getProductPartitionId())) {
            parentNode = parentNode.asSubdivision();
        }
        for (AdGroupCriterion adGroupCriterion : parentIdMap.get((Object)parentNode.getProductPartitionId())) {
            ProductPartition partition = (ProductPartition)adGroupCriterion.getCriterion();
            ProductPartitionNode childNode = parentNode.addChild(partition.getCaseValue());
            childNode = childNode.setProductPartitionId(partition.getId());
            if (ProductPartitionType.SUBDIVISION.equals(partition.getPartitionType())) {
                childNode = childNode.asSubdivision();
            } else if (adGroupCriterion instanceof BiddableAdGroupCriterion) {
                childNode = childNode.asBiddableUnit();
                Money cpcBidAmount = ProductPartitionTreeImpl.getBid((BiddableAdGroupCriterion)adGroupCriterion);
                if (cpcBidAmount != null) {
                    childNode = childNode.setBid(cpcBidAmount.getMicroAmount());
                }
            } else {
                childNode = childNode.asExcludedUnit();
            }
            ProductPartitionTreeImpl.addChildNodes(childNode, parentIdMap);
        }
    }

    private static Money getBid(BiddableAdGroupCriterion biddableCriterion) {
        BiddingStrategyConfiguration biddingConfig = biddableCriterion.getBiddingStrategyConfiguration();
        Money cpcBidAmount = null;
        if (biddingConfig.getBids() != null) {
            for (Bids bid : biddingConfig.getBids()) {
                CpcBid cpcBid;
                if (!(bid instanceof CpcBid) || !BidSource.CRITERION.equals((cpcBid = (CpcBid)bid).getCpcBidSource())) continue;
                cpcBidAmount = cpcBid.getBid();
                break;
            }
        }
        return cpcBidAmount;
    }

    private static class OperationPair {
        final ProductPartitionNode node;
        final AdGroupCriterionOperation operation;

        OperationPair(ProductPartitionNode node, AdGroupCriterionOperation operation) {
            this.node = node;
            this.operation = operation;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("node", (Object)this.node).append("operation", (Object)this.operation).toString();
        }
    }
}

