// Copyright 2017 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * DataUploadResult.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Mar 02, 2009 (07:08:06 PST) WSDL2Java emitter.
 */

package com.google.api.ads.adwords.axis.v201710.rm;


/**
 * A class represents the data upload result for CRM based lists.
 */
public class DataUploadResult  implements java.io.Serializable {
    /* Indicates status of the upload operation.
     *                 Upload operation is triggered when {@link MutateMembersOperand#removeAll
     * removeAll} is not set
     *                 to true and {@link Operator operator} is "ADD" or
     * "REMOVE". */
    private com.google.api.ads.adwords.axis.v201710.rm.UserListUploadStatus uploadStatus;

    /* Indicates status of the remove-all operation.
     *                 Remove-all operation is triggered when {@link MutateMembersOperand#removeAll
     * removeAll} is set
     *                 to true and {@link Operator operator} is "REMOVE". */
    private com.google.api.ads.adwords.axis.v201710.rm.UserListUploadStatus removeAllStatus;

    public DataUploadResult() {
    }

    public DataUploadResult(
           com.google.api.ads.adwords.axis.v201710.rm.UserListUploadStatus uploadStatus,
           com.google.api.ads.adwords.axis.v201710.rm.UserListUploadStatus removeAllStatus) {
           this.uploadStatus = uploadStatus;
           this.removeAllStatus = removeAllStatus;
    }

    @Override
    public String toString() {
        return com.google.common.base.MoreObjects.toStringHelper(this.getClass())
            .omitNullValues()
            .add("removeAllStatus", getRemoveAllStatus())
            .add("uploadStatus", getUploadStatus())
            .toString();
    }

    /**
     * Gets the uploadStatus value for this DataUploadResult.
     * 
     * @return uploadStatus   * Indicates status of the upload operation.
     *                 Upload operation is triggered when {@link MutateMembersOperand#removeAll
     * removeAll} is not set
     *                 to true and {@link Operator operator} is "ADD" or
     * "REMOVE".
     */
    public com.google.api.ads.adwords.axis.v201710.rm.UserListUploadStatus getUploadStatus() {
        return uploadStatus;
    }


    /**
     * Sets the uploadStatus value for this DataUploadResult.
     * 
     * @param uploadStatus   * Indicates status of the upload operation.
     *                 Upload operation is triggered when {@link MutateMembersOperand#removeAll
     * removeAll} is not set
     *                 to true and {@link Operator operator} is "ADD" or
     * "REMOVE".
     */
    public void setUploadStatus(com.google.api.ads.adwords.axis.v201710.rm.UserListUploadStatus uploadStatus) {
        this.uploadStatus = uploadStatus;
    }


    /**
     * Gets the removeAllStatus value for this DataUploadResult.
     * 
     * @return removeAllStatus   * Indicates status of the remove-all operation.
     *                 Remove-all operation is triggered when {@link MutateMembersOperand#removeAll
     * removeAll} is set
     *                 to true and {@link Operator operator} is "REMOVE".
     */
    public com.google.api.ads.adwords.axis.v201710.rm.UserListUploadStatus getRemoveAllStatus() {
        return removeAllStatus;
    }


    /**
     * Sets the removeAllStatus value for this DataUploadResult.
     * 
     * @param removeAllStatus   * Indicates status of the remove-all operation.
     *                 Remove-all operation is triggered when {@link MutateMembersOperand#removeAll
     * removeAll} is set
     *                 to true and {@link Operator operator} is "REMOVE".
     */
    public void setRemoveAllStatus(com.google.api.ads.adwords.axis.v201710.rm.UserListUploadStatus removeAllStatus) {
        this.removeAllStatus = removeAllStatus;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(java.lang.Object obj) {
        if (!(obj instanceof DataUploadResult)) return false;
        DataUploadResult other = (DataUploadResult) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.uploadStatus==null && other.getUploadStatus()==null) || 
             (this.uploadStatus!=null &&
              this.uploadStatus.equals(other.getUploadStatus()))) &&
            ((this.removeAllStatus==null && other.getRemoveAllStatus()==null) || 
             (this.removeAllStatus!=null &&
              this.removeAllStatus.equals(other.getRemoveAllStatus())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getUploadStatus() != null) {
            _hashCode += getUploadStatus().hashCode();
        }
        if (getRemoveAllStatus() != null) {
            _hashCode += getRemoveAllStatus().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(DataUploadResult.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("https://adwords.google.com/api/adwords/rm/v201710", "DataUploadResult"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("uploadStatus");
        elemField.setXmlName(new javax.xml.namespace.QName("https://adwords.google.com/api/adwords/rm/v201710", "uploadStatus"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://adwords.google.com/api/adwords/rm/v201710", "UserListUploadStatus"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("removeAllStatus");
        elemField.setXmlName(new javax.xml.namespace.QName("https://adwords.google.com/api/adwords/rm/v201710", "removeAllStatus"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://adwords.google.com/api/adwords/rm/v201710", "UserListUploadStatus"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
