// Copyright 2017 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * UserListLogicalRule.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Mar 02, 2009 (07:08:06 PST) WSDL2Java emitter.
 */

package com.google.api.ads.adwords.axis.v201710.rm;


/**
 * A user list logical rule. A rule has a logical operator (and/or/not)
 * and a
 *             list of operands that can be user lists or user interests.
 */
public class UserListLogicalRule  implements java.io.Serializable {
    /* The logical operator of the rule.
     *                 <span class="constraint Required">This field is required
     * and should not be {@code null}.</span> */
    private com.google.api.ads.adwords.axis.v201710.rm.UserListLogicalRuleOperator operator;

    /* The list of operands of the rule.
     *                 <span class="constraint ContentsNotNull">This field
     * must not contain {@code null} elements.</span>
     *                 <span class="constraint NotEmpty">This field must
     * contain at least one element.</span>
     *                 <span class="constraint Required">This field is required
     * and should not be {@code null}.</span> */
    private com.google.api.ads.adwords.axis.v201710.rm.LogicalUserListOperand[] ruleOperands;

    public UserListLogicalRule() {
    }

    public UserListLogicalRule(
           com.google.api.ads.adwords.axis.v201710.rm.UserListLogicalRuleOperator operator,
           com.google.api.ads.adwords.axis.v201710.rm.LogicalUserListOperand[] ruleOperands) {
           this.operator = operator;
           this.ruleOperands = ruleOperands;
    }

    @Override
    public String toString() {
        return com.google.common.base.MoreObjects.toStringHelper(this.getClass())
            .omitNullValues()
            .add("operator", getOperator())
            .add("ruleOperands", getRuleOperands())
            .toString();
    }

    /**
     * Gets the operator value for this UserListLogicalRule.
     * 
     * @return operator   * The logical operator of the rule.
     *                 <span class="constraint Required">This field is required
     * and should not be {@code null}.</span>
     */
    public com.google.api.ads.adwords.axis.v201710.rm.UserListLogicalRuleOperator getOperator() {
        return operator;
    }


    /**
     * Sets the operator value for this UserListLogicalRule.
     * 
     * @param operator   * The logical operator of the rule.
     *                 <span class="constraint Required">This field is required
     * and should not be {@code null}.</span>
     */
    public void setOperator(com.google.api.ads.adwords.axis.v201710.rm.UserListLogicalRuleOperator operator) {
        this.operator = operator;
    }


    /**
     * Gets the ruleOperands value for this UserListLogicalRule.
     * 
     * @return ruleOperands   * The list of operands of the rule.
     *                 <span class="constraint ContentsNotNull">This field
     * must not contain {@code null} elements.</span>
     *                 <span class="constraint NotEmpty">This field must
     * contain at least one element.</span>
     *                 <span class="constraint Required">This field is required
     * and should not be {@code null}.</span>
     */
    public com.google.api.ads.adwords.axis.v201710.rm.LogicalUserListOperand[] getRuleOperands() {
        return ruleOperands;
    }


    /**
     * Sets the ruleOperands value for this UserListLogicalRule.
     * 
     * @param ruleOperands   * The list of operands of the rule.
     *                 <span class="constraint ContentsNotNull">This field
     * must not contain {@code null} elements.</span>
     *                 <span class="constraint NotEmpty">This field must
     * contain at least one element.</span>
     *                 <span class="constraint Required">This field is required
     * and should not be {@code null}.</span>
     */
    public void setRuleOperands(com.google.api.ads.adwords.axis.v201710.rm.LogicalUserListOperand[] ruleOperands) {
        this.ruleOperands = ruleOperands;
    }

    public com.google.api.ads.adwords.axis.v201710.rm.LogicalUserListOperand getRuleOperands(int i) {
        return this.ruleOperands[i];
    }

    public void setRuleOperands(int i, com.google.api.ads.adwords.axis.v201710.rm.LogicalUserListOperand _value) {
        this.ruleOperands[i] = _value;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(java.lang.Object obj) {
        if (!(obj instanceof UserListLogicalRule)) return false;
        UserListLogicalRule other = (UserListLogicalRule) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.operator==null && other.getOperator()==null) || 
             (this.operator!=null &&
              this.operator.equals(other.getOperator()))) &&
            ((this.ruleOperands==null && other.getRuleOperands()==null) || 
             (this.ruleOperands!=null &&
              java.util.Arrays.equals(this.ruleOperands, other.getRuleOperands())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getOperator() != null) {
            _hashCode += getOperator().hashCode();
        }
        if (getRuleOperands() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getRuleOperands());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getRuleOperands(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(UserListLogicalRule.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("https://adwords.google.com/api/adwords/rm/v201710", "UserListLogicalRule"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("operator");
        elemField.setXmlName(new javax.xml.namespace.QName("https://adwords.google.com/api/adwords/rm/v201710", "operator"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://adwords.google.com/api/adwords/rm/v201710", "UserListLogicalRule.Operator"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("ruleOperands");
        elemField.setXmlName(new javax.xml.namespace.QName("https://adwords.google.com/api/adwords/rm/v201710", "ruleOperands"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://adwords.google.com/api/adwords/rm/v201710", "LogicalUserListOperand"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
