/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1/stream.proto

package com.google.cloud.bigquery.storage.v1;

/**
 *
 *
 * <pre>
 * Information about a single stream that gets data inside the storage system.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1.WriteStream}
 */
public final class WriteStream extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.WriteStream)
    WriteStreamOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WriteStream.newBuilder() to construct.
  private WriteStream(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WriteStream() {
    name_ = "";
    type_ = 0;
    writeMode_ = 0;
    location_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WriteStream();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1.StreamProto
        .internal_static_google_cloud_bigquery_storage_v1_WriteStream_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1.StreamProto
        .internal_static_google_cloud_bigquery_storage_v1_WriteStream_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1.WriteStream.class,
            com.google.cloud.bigquery.storage.v1.WriteStream.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type enum of the stream.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.storage.v1.WriteStream.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unknown type.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Data will commit automatically and appear as soon as the write is
     * acknowledged.
     * </pre>
     *
     * <code>COMMITTED = 1;</code>
     */
    COMMITTED(1),
    /**
     *
     *
     * <pre>
     * Data is invisible until the stream is committed.
     * </pre>
     *
     * <code>PENDING = 2;</code>
     */
    PENDING(2),
    /**
     *
     *
     * <pre>
     * Data is only visible up to the offset to which it was flushed.
     * </pre>
     *
     * <code>BUFFERED = 3;</code>
     */
    BUFFERED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unknown type.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Data will commit automatically and appear as soon as the write is
     * acknowledged.
     * </pre>
     *
     * <code>COMMITTED = 1;</code>
     */
    public static final int COMMITTED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Data is invisible until the stream is committed.
     * </pre>
     *
     * <code>PENDING = 2;</code>
     */
    public static final int PENDING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Data is only visible up to the offset to which it was flushed.
     * </pre>
     *
     * <code>BUFFERED = 3;</code>
     */
    public static final int BUFFERED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return COMMITTED;
        case 2:
          return PENDING;
        case 3:
          return BUFFERED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.WriteStream.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.storage.v1.WriteStream.Type)
  }

  /**
   *
   *
   * <pre>
   * Mode enum of the stream.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.storage.v1.WriteStream.WriteMode}
   */
  public enum WriteMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unknown type.
     * </pre>
     *
     * <code>WRITE_MODE_UNSPECIFIED = 0;</code>
     */
    WRITE_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Insert new records into the table.
     * It is the default value if customers do not specify it.
     * </pre>
     *
     * <code>INSERT = 1;</code>
     */
    INSERT(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unknown type.
     * </pre>
     *
     * <code>WRITE_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int WRITE_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Insert new records into the table.
     * It is the default value if customers do not specify it.
     * </pre>
     *
     * <code>INSERT = 1;</code>
     */
    public static final int INSERT_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static WriteMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static WriteMode forNumber(int value) {
      switch (value) {
        case 0:
          return WRITE_MODE_UNSPECIFIED;
        case 1:
          return INSERT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<WriteMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<WriteMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<WriteMode>() {
          public WriteMode findValueByNumber(int number) {
            return WriteMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.WriteStream.getDescriptor().getEnumTypes().get(1);
    }

    private static final WriteMode[] VALUES = values();

    public static WriteMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private WriteMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.storage.v1.WriteStream.WriteMode)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the stream, in the form
   * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the stream, in the form
   * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Immutable. Type of the stream.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. Type of the stream.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.WriteStream.Type getType() {
    com.google.cloud.bigquery.storage.v1.WriteStream.Type result =
        com.google.cloud.bigquery.storage.v1.WriteStream.Type.forNumber(type_);
    return result == null
        ? com.google.cloud.bigquery.storage.v1.WriteStream.Type.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Create time of the stream. For the _default stream, this is
   * the creation_time of the table.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Create time of the stream. For the _default stream, this is
   * the creation_time of the table.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Create time of the stream. For the _default stream, this is
   * the creation_time of the table.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int COMMIT_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp commitTime_;
  /**
   *
   *
   * <pre>
   * Output only. Commit time of the stream.
   * If a stream is of `COMMITTED` type, then it will have a commit_time same as
   * `create_time`. If the stream is of `PENDING` type, empty commit_time
   * means it is not committed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the commitTime field is set.
   */
  @java.lang.Override
  public boolean hasCommitTime() {
    return commitTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Commit time of the stream.
   * If a stream is of `COMMITTED` type, then it will have a commit_time same as
   * `create_time`. If the stream is of `PENDING` type, empty commit_time
   * means it is not committed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The commitTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCommitTime() {
    return commitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : commitTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Commit time of the stream.
   * If a stream is of `COMMITTED` type, then it will have a commit_time same as
   * `create_time`. If the stream is of `PENDING` type, empty commit_time
   * means it is not committed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder() {
    return commitTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : commitTime_;
  }

  public static final int TABLE_SCHEMA_FIELD_NUMBER = 5;
  private com.google.cloud.bigquery.storage.v1.TableSchema tableSchema_;
  /**
   *
   *
   * <pre>
   * Output only. The schema of the destination table. It is only returned in
   * `CreateWriteStream` response. Caller should generate data that's
   * compatible with this schema to send in initial `AppendRowsRequest`.
   * The table schema could go out of date during the life time of the stream.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the tableSchema field is set.
   */
  @java.lang.Override
  public boolean hasTableSchema() {
    return tableSchema_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The schema of the destination table. It is only returned in
   * `CreateWriteStream` response. Caller should generate data that's
   * compatible with this schema to send in initial `AppendRowsRequest`.
   * The table schema could go out of date during the life time of the stream.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The tableSchema.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableSchema getTableSchema() {
    return tableSchema_ == null
        ? com.google.cloud.bigquery.storage.v1.TableSchema.getDefaultInstance()
        : tableSchema_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The schema of the destination table. It is only returned in
   * `CreateWriteStream` response. Caller should generate data that's
   * compatible with this schema to send in initial `AppendRowsRequest`.
   * The table schema could go out of date during the life time of the stream.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableSchemaOrBuilder getTableSchemaOrBuilder() {
    return tableSchema_ == null
        ? com.google.cloud.bigquery.storage.v1.TableSchema.getDefaultInstance()
        : tableSchema_;
  }

  public static final int WRITE_MODE_FIELD_NUMBER = 7;
  private int writeMode_ = 0;
  /**
   *
   *
   * <pre>
   * Immutable. Mode of the stream.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.WriteStream.WriteMode write_mode = 7 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for writeMode.
   */
  @java.lang.Override
  public int getWriteModeValue() {
    return writeMode_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. Mode of the stream.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.WriteStream.WriteMode write_mode = 7 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The writeMode.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.WriteStream.WriteMode getWriteMode() {
    com.google.cloud.bigquery.storage.v1.WriteStream.WriteMode result =
        com.google.cloud.bigquery.storage.v1.WriteStream.WriteMode.forNumber(writeMode_);
    return result == null
        ? com.google.cloud.bigquery.storage.v1.WriteStream.WriteMode.UNRECOGNIZED
        : result;
  }

  public static final int LOCATION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The geographic location where the stream's dataset resides. See
   * https://cloud.google.com/bigquery/docs/locations for supported
   * locations.
   * </pre>
   *
   * <code>string location = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The geographic location where the stream's dataset resides. See
   * https://cloud.google.com/bigquery/docs/locations for supported
   * locations.
   * </pre>
   *
   * <code>string location = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (type_
        != com.google.cloud.bigquery.storage.v1.WriteStream.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, type_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (commitTime_ != null) {
      output.writeMessage(4, getCommitTime());
    }
    if (tableSchema_ != null) {
      output.writeMessage(5, getTableSchema());
    }
    if (writeMode_
        != com.google.cloud.bigquery.storage.v1.WriteStream.WriteMode.WRITE_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, writeMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, location_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (type_
        != com.google.cloud.bigquery.storage.v1.WriteStream.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (commitTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCommitTime());
    }
    if (tableSchema_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getTableSchema());
    }
    if (writeMode_
        != com.google.cloud.bigquery.storage.v1.WriteStream.WriteMode.WRITE_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, writeMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, location_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.storage.v1.WriteStream)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1.WriteStream other =
        (com.google.cloud.bigquery.storage.v1.WriteStream) obj;

    if (!getName().equals(other.getName())) return false;
    if (type_ != other.type_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasCommitTime() != other.hasCommitTime()) return false;
    if (hasCommitTime()) {
      if (!getCommitTime().equals(other.getCommitTime())) return false;
    }
    if (hasTableSchema() != other.hasTableSchema()) return false;
    if (hasTableSchema()) {
      if (!getTableSchema().equals(other.getTableSchema())) return false;
    }
    if (writeMode_ != other.writeMode_) return false;
    if (!getLocation().equals(other.getLocation())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasCommitTime()) {
      hash = (37 * hash) + COMMIT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCommitTime().hashCode();
    }
    if (hasTableSchema()) {
      hash = (37 * hash) + TABLE_SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getTableSchema().hashCode();
    }
    hash = (37 * hash) + WRITE_MODE_FIELD_NUMBER;
    hash = (53 * hash) + writeMode_;
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1.WriteStream parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.WriteStream parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.WriteStream parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.WriteStream parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.WriteStream parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.WriteStream parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.WriteStream parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.WriteStream parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.WriteStream parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.WriteStream parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.WriteStream parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.WriteStream parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.bigquery.storage.v1.WriteStream prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information about a single stream that gets data inside the storage system.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.WriteStream}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.WriteStream)
      com.google.cloud.bigquery.storage.v1.WriteStreamOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_WriteStream_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_WriteStream_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.WriteStream.class,
              com.google.cloud.bigquery.storage.v1.WriteStream.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.storage.v1.WriteStream.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      type_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      commitTime_ = null;
      if (commitTimeBuilder_ != null) {
        commitTimeBuilder_.dispose();
        commitTimeBuilder_ = null;
      }
      tableSchema_ = null;
      if (tableSchemaBuilder_ != null) {
        tableSchemaBuilder_.dispose();
        tableSchemaBuilder_ = null;
      }
      writeMode_ = 0;
      location_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_WriteStream_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.WriteStream getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1.WriteStream.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.WriteStream build() {
      com.google.cloud.bigquery.storage.v1.WriteStream result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.WriteStream buildPartial() {
      com.google.cloud.bigquery.storage.v1.WriteStream result =
          new com.google.cloud.bigquery.storage.v1.WriteStream(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.storage.v1.WriteStream result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.commitTime_ = commitTimeBuilder_ == null ? commitTime_ : commitTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.tableSchema_ =
            tableSchemaBuilder_ == null ? tableSchema_ : tableSchemaBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.writeMode_ = writeMode_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.location_ = location_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.storage.v1.WriteStream) {
        return mergeFrom((com.google.cloud.bigquery.storage.v1.WriteStream) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.storage.v1.WriteStream other) {
      if (other == com.google.cloud.bigquery.storage.v1.WriteStream.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasCommitTime()) {
        mergeCommitTime(other.getCommitTime());
      }
      if (other.hasTableSchema()) {
        mergeTableSchema(other.getTableSchema());
      }
      if (other.writeMode_ != 0) {
        setWriteModeValue(other.getWriteModeValue());
      }
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCommitTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getTableSchemaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 56:
              {
                writeMode_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 66:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the stream, in the form
     * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the stream, in the form
     * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the stream, in the form
     * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the stream, in the form
     * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the stream, in the form
     * `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. Type of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Type of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Type of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.WriteStream.Type getType() {
      com.google.cloud.bigquery.storage.v1.WriteStream.Type result =
          com.google.cloud.bigquery.storage.v1.WriteStream.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.bigquery.storage.v1.WriteStream.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Type of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.bigquery.storage.v1.WriteStream.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Type of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.WriteStream.Type type = 2 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream. For the _default stream, this is
     * the creation_time of the table.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream. For the _default stream, this is
     * the creation_time of the table.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream. For the _default stream, this is
     * the creation_time of the table.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream. For the _default stream, this is
     * the creation_time of the table.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream. For the _default stream, this is
     * the creation_time of the table.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream. For the _default stream, this is
     * the creation_time of the table.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream. For the _default stream, this is
     * the creation_time of the table.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream. For the _default stream, this is
     * the creation_time of the table.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the stream. For the _default stream, this is
     * the creation_time of the table.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp commitTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        commitTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, empty commit_time
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the commitTime field is set.
     */
    public boolean hasCommitTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, empty commit_time
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The commitTime.
     */
    public com.google.protobuf.Timestamp getCommitTime() {
      if (commitTimeBuilder_ == null) {
        return commitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitTime_;
      } else {
        return commitTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, empty commit_time
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCommitTime(com.google.protobuf.Timestamp value) {
      if (commitTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commitTime_ = value;
      } else {
        commitTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, empty commit_time
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCommitTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (commitTimeBuilder_ == null) {
        commitTime_ = builderForValue.build();
      } else {
        commitTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, empty commit_time
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCommitTime(com.google.protobuf.Timestamp value) {
      if (commitTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && commitTime_ != null
            && commitTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCommitTimeBuilder().mergeFrom(value);
        } else {
          commitTime_ = value;
        }
      } else {
        commitTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, empty commit_time
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCommitTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      commitTime_ = null;
      if (commitTimeBuilder_ != null) {
        commitTimeBuilder_.dispose();
        commitTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, empty commit_time
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCommitTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCommitTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, empty commit_time
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCommitTimeOrBuilder() {
      if (commitTimeBuilder_ != null) {
        return commitTimeBuilder_.getMessageOrBuilder();
      } else {
        return commitTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : commitTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Commit time of the stream.
     * If a stream is of `COMMITTED` type, then it will have a commit_time same as
     * `create_time`. If the stream is of `PENDING` type, empty commit_time
     * means it is not committed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp commit_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCommitTimeFieldBuilder() {
      if (commitTimeBuilder_ == null) {
        commitTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCommitTime(), getParentForChildren(), isClean());
        commitTime_ = null;
      }
      return commitTimeBuilder_;
    }

    private com.google.cloud.bigquery.storage.v1.TableSchema tableSchema_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.TableSchema,
            com.google.cloud.bigquery.storage.v1.TableSchema.Builder,
            com.google.cloud.bigquery.storage.v1.TableSchemaOrBuilder>
        tableSchemaBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the tableSchema field is set.
     */
    public boolean hasTableSchema() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The tableSchema.
     */
    public com.google.cloud.bigquery.storage.v1.TableSchema getTableSchema() {
      if (tableSchemaBuilder_ == null) {
        return tableSchema_ == null
            ? com.google.cloud.bigquery.storage.v1.TableSchema.getDefaultInstance()
            : tableSchema_;
      } else {
        return tableSchemaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTableSchema(com.google.cloud.bigquery.storage.v1.TableSchema value) {
      if (tableSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tableSchema_ = value;
      } else {
        tableSchemaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTableSchema(
        com.google.cloud.bigquery.storage.v1.TableSchema.Builder builderForValue) {
      if (tableSchemaBuilder_ == null) {
        tableSchema_ = builderForValue.build();
      } else {
        tableSchemaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTableSchema(com.google.cloud.bigquery.storage.v1.TableSchema value) {
      if (tableSchemaBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && tableSchema_ != null
            && tableSchema_
                != com.google.cloud.bigquery.storage.v1.TableSchema.getDefaultInstance()) {
          getTableSchemaBuilder().mergeFrom(value);
        } else {
          tableSchema_ = value;
        }
      } else {
        tableSchemaBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTableSchema() {
      bitField0_ = (bitField0_ & ~0x00000010);
      tableSchema_ = null;
      if (tableSchemaBuilder_ != null) {
        tableSchemaBuilder_.dispose();
        tableSchemaBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableSchema.Builder getTableSchemaBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getTableSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableSchemaOrBuilder getTableSchemaOrBuilder() {
      if (tableSchemaBuilder_ != null) {
        return tableSchemaBuilder_.getMessageOrBuilder();
      } else {
        return tableSchema_ == null
            ? com.google.cloud.bigquery.storage.v1.TableSchema.getDefaultInstance()
            : tableSchema_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The schema of the destination table. It is only returned in
     * `CreateWriteStream` response. Caller should generate data that's
     * compatible with this schema to send in initial `AppendRowsRequest`.
     * The table schema could go out of date during the life time of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableSchema table_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.TableSchema,
            com.google.cloud.bigquery.storage.v1.TableSchema.Builder,
            com.google.cloud.bigquery.storage.v1.TableSchemaOrBuilder>
        getTableSchemaFieldBuilder() {
      if (tableSchemaBuilder_ == null) {
        tableSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.TableSchema,
                com.google.cloud.bigquery.storage.v1.TableSchema.Builder,
                com.google.cloud.bigquery.storage.v1.TableSchemaOrBuilder>(
                getTableSchema(), getParentForChildren(), isClean());
        tableSchema_ = null;
      }
      return tableSchemaBuilder_;
    }

    private int writeMode_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. Mode of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.WriteStream.WriteMode write_mode = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for writeMode.
     */
    @java.lang.Override
    public int getWriteModeValue() {
      return writeMode_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Mode of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.WriteStream.WriteMode write_mode = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for writeMode to set.
     * @return This builder for chaining.
     */
    public Builder setWriteModeValue(int value) {
      writeMode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Mode of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.WriteStream.WriteMode write_mode = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The writeMode.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.WriteStream.WriteMode getWriteMode() {
      com.google.cloud.bigquery.storage.v1.WriteStream.WriteMode result =
          com.google.cloud.bigquery.storage.v1.WriteStream.WriteMode.forNumber(writeMode_);
      return result == null
          ? com.google.cloud.bigquery.storage.v1.WriteStream.WriteMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Mode of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.WriteStream.WriteMode write_mode = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The writeMode to set.
     * @return This builder for chaining.
     */
    public Builder setWriteMode(com.google.cloud.bigquery.storage.v1.WriteStream.WriteMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      writeMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Mode of the stream.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.WriteStream.WriteMode write_mode = 7 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWriteMode() {
      bitField0_ = (bitField0_ & ~0x00000020);
      writeMode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The geographic location where the stream's dataset resides. See
     * https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string location = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The geographic location where the stream's dataset resides. See
     * https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string location = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The geographic location where the stream's dataset resides. See
     * https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string location = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The geographic location where the stream's dataset resides. See
     * https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string location = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The geographic location where the stream's dataset resides. See
     * https://cloud.google.com/bigquery/docs/locations for supported
     * locations.
     * </pre>
     *
     * <code>string location = 8 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.WriteStream)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.WriteStream)
  private static final com.google.cloud.bigquery.storage.v1.WriteStream DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1.WriteStream();
  }

  public static com.google.cloud.bigquery.storage.v1.WriteStream getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WriteStream> PARSER =
      new com.google.protobuf.AbstractParser<WriteStream>() {
        @java.lang.Override
        public WriteStream parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WriteStream> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WriteStream> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.WriteStream getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
