/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.CurrentMillisClock;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.ServerSideTransaction;
import com.google.cloud.firestore.Transaction;
import com.google.cloud.firestore.TransactionOptions;
import com.google.cloud.firestore.telemetry.TraceUtil;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Context;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

final class ServerSideTransactionRunner<T> {
    private final Transaction.AsyncFunction<T> userCallback;
    private final FirestoreImpl firestore;
    private final ScheduledExecutorService firestoreExecutor;
    private final Executor userCallbackExecutor;
    private final ExponentialRetryAlgorithm backoffAlgorithm;
    private final TransactionOptions transactionOptions;
    private TimedAttemptSettings nextBackoffAttempt;
    private ServerSideTransaction transaction;
    private int attemptsRemaining;
    private TraceUtil.Span runTransactionSpan;
    private TraceUtil.Context runTransactionContext;

    ServerSideTransactionRunner(FirestoreImpl firestore, Transaction.AsyncFunction<T> userCallback, TransactionOptions transactionOptions) {
        this.transactionOptions = transactionOptions;
        this.firestore = firestore;
        this.firestoreExecutor = firestore.getClient().getExecutor();
        this.userCallback = userCallback;
        this.attemptsRemaining = transactionOptions.getNumberOfAttempts();
        this.userCallbackExecutor = Context.currentContextExecutor((Executor)(transactionOptions.getExecutor() != null ? transactionOptions.getExecutor() : this.firestore.getClient().getExecutor()));
        this.backoffAlgorithm = new ExponentialRetryAlgorithm(firestore.getOptions().getRetrySettings(), CurrentMillisClock.getDefaultClock());
        this.nextBackoffAttempt = this.backoffAlgorithm.createFirstAttempt();
    }

    @Nonnull
    private TraceUtil getTraceUtil() {
        return this.firestore.getOptions().getTraceUtil();
    }

    ApiFuture<T> run() {
        this.runTransactionSpan = this.getTraceUtil().startSpan("Transaction.Run");
        this.runTransactionSpan.setAttribute("transaction_type", this.transactionOptions.getType().name());
        this.runTransactionSpan.setAttribute("attempts_allowed", this.transactionOptions.getNumberOfAttempts());
        this.runTransactionSpan.setAttribute("attempts_remaining", this.attemptsRemaining);
        TraceUtil.Scope ignored = this.runTransactionSpan.makeCurrent();
        try {
            this.runTransactionContext = this.getTraceUtil().currentContext();
            --this.attemptsRemaining;
            ApiFuture result = ApiFutures.catchingAsync((ApiFuture)ApiFutures.transformAsync(this.maybeRollback(), this::rollbackCallback, (Executor)MoreExecutors.directExecutor()), Throwable.class, this::restartTransactionCallback, (Executor)MoreExecutors.directExecutor());
            this.runTransactionSpan.endAtFuture(result);
            ApiFuture apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                this.runTransactionSpan.end(error);
                throw error;
            }
        }
    }

    ApiFuture<ServerSideTransaction> begin() {
        TraceUtil.Span span = this.getTraceUtil().startSpan("Transaction.Begin", this.runTransactionContext);
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            ServerSideTransaction previousTransaction = this.transaction;
            this.transaction = null;
            ApiFuture result = ServerSideTransaction.begin(this.firestore, this.transactionOptions, previousTransaction);
            result = ApiFutures.transform(result, serverSideTransaction -> {
                serverSideTransaction.setTransactionTraceContext(this.runTransactionContext);
                return serverSideTransaction;
            });
            span.endAtFuture(result);
            ApiFuture apiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                throw error;
            }
        }
    }

    private ApiFuture<Void> maybeRollback() {
        return this.hasTransaction() ? this.transaction.rollback() : ApiFutures.immediateFuture(null);
    }

    private boolean hasTransaction() {
        return this.transaction != null;
    }

    private ApiFuture<T> rollbackCallback(Void input) {
        SettableApiFuture backoff = SettableApiFuture.create();
        this.firestoreExecutor.schedule(() -> backoff.set(null), this.nextBackoffAttempt.getRandomizedRetryDelay().toMillis(), TimeUnit.MILLISECONDS);
        this.nextBackoffAttempt = this.backoffAlgorithm.createNextAttempt(this.nextBackoffAttempt);
        return ApiFutures.transformAsync((ApiFuture)backoff, this::backoffCallback, (Executor)MoreExecutors.directExecutor());
    }

    private SettableApiFuture<T> invokeUserCallback() {
        final SettableApiFuture returnedResult = SettableApiFuture.create();
        this.userCallbackExecutor.execute(() -> {
            ApiFuture<T> userCallbackResult;
            try {
                userCallbackResult = this.userCallback.updateCallback(this.transaction);
            }
            catch (Exception e) {
                userCallbackResult = ApiFutures.immediateFailedFuture((Throwable)e);
            }
            ApiFutures.addCallback(userCallbackResult, (ApiFutureCallback)new ApiFutureCallback<T>(){

                public void onFailure(Throwable t) {
                    returnedResult.setException(t);
                }

                public void onSuccess(T result) {
                    returnedResult.set(result);
                }
            }, (Executor)this.firestoreExecutor);
        });
        return returnedResult;
    }

    private ApiFuture<T> backoffCallback(Void input) {
        return ApiFutures.transformAsync(this.begin(), this::beginTransactionCallback, (Executor)MoreExecutors.directExecutor());
    }

    private ApiFuture<T> beginTransactionCallback(ServerSideTransaction serverSideTransaction) {
        this.transaction = serverSideTransaction;
        return ApiFutures.transformAsync(this.invokeUserCallback(), this::userFunctionCallback, (Executor)MoreExecutors.directExecutor());
    }

    private ApiFuture<T> userFunctionCallback(T userFunctionResult) {
        return ApiFutures.transform(this.transaction.commit(), input -> userFunctionResult, (Executor)MoreExecutors.directExecutor());
    }

    private ApiFuture<T> restartTransactionCallback(Throwable throwable) {
        if (!(throwable instanceof ApiException)) {
            return this.rollbackAndReject(throwable);
        }
        ApiException apiException = (ApiException)throwable;
        if (ServerSideTransactionRunner.isRetryableTransactionError(apiException)) {
            if (this.attemptsRemaining > 0) {
                this.getTraceUtil().currentSpan().addEvent("Initiating transaction retry. Attempts remaining: " + this.attemptsRemaining);
                return this.run();
            }
            FirestoreException firestoreException = FirestoreException.forApiException(apiException, "Transaction was cancelled because of too many retries.");
            return this.rollbackAndReject((Throwable)((Object)firestoreException));
        }
        FirestoreException firestoreException = FirestoreException.forApiException(apiException, "Transaction failed with non-retryable error");
        return this.rollbackAndReject((Throwable)((Object)firestoreException));
    }

    private static boolean isRetryableTransactionError(ApiException exception) {
        switch (exception.getStatusCode().getCode()) {
            case ABORTED: 
            case CANCELLED: 
            case UNKNOWN: 
            case DEADLINE_EXCEEDED: 
            case INTERNAL: 
            case UNAVAILABLE: 
            case UNAUTHENTICATED: 
            case RESOURCE_EXHAUSTED: {
                return true;
            }
            case INVALID_ARGUMENT: {
                return exception.getMessage().contains("transaction has expired");
            }
        }
        return false;
    }

    private ApiFuture<T> rollbackAndReject(Throwable throwable) {
        SettableApiFuture failedTransaction = SettableApiFuture.create();
        if (this.hasTransaction()) {
            this.transaction.rollback().addListener(() -> {
                this.runTransactionSpan.end(throwable);
                failedTransaction.setException(throwable);
            }, MoreExecutors.directExecutor());
        } else {
            this.runTransactionSpan.end(throwable);
            failedTransaction.setException(throwable);
        }
        return failedTransaction;
    }
}

