/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.SpannerException;
import com.google.common.collect.ImmutableMap;
import com.google.spanner.v1.Transaction;
import io.opencensus.contrib.grpc.util.StatusConverter;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SampledSpanStore;
import java.util.Arrays;
import java.util.Map;

class TraceUtil {
    TraceUtil() {
    }

    static Map<String, AttributeValue> getTransactionAnnotations(Transaction t) {
        return ImmutableMap.of((Object)"Id", (Object)AttributeValue.stringAttributeValue((String)t.getId().toStringUtf8()), (Object)"Timestamp", (Object)AttributeValue.stringAttributeValue((String)Timestamp.fromProto((com.google.protobuf.Timestamp)t.getReadTimestamp()).toString()));
    }

    static ImmutableMap<String, AttributeValue> getExceptionAnnotations(RuntimeException e) {
        if (e instanceof SpannerException) {
            return ImmutableMap.of((Object)"Status", (Object)AttributeValue.stringAttributeValue((String)((SpannerException)((Object)e)).getErrorCode().toString()));
        }
        return ImmutableMap.of();
    }

    static ImmutableMap<String, AttributeValue> getExceptionAnnotations(SpannerException e) {
        return ImmutableMap.of((Object)"Status", (Object)AttributeValue.stringAttributeValue((String)e.getErrorCode().toString()));
    }

    static void endSpanWithFailure(Span span, Exception e) {
        if (e instanceof SpannerException) {
            TraceUtil.endSpanWithFailure(span, (SpannerException)((Object)e));
        } else {
            span.setStatus(Status.INTERNAL.withDescription(e.getMessage()));
            span.end();
        }
    }

    static void endSpanWithFailure(Span span, SpannerException e) {
        span.setStatus(StatusConverter.fromGrpcStatus((io.grpc.Status)e.getErrorCode().getGrpcStatus()).withDescription(e.getMessage()));
        span.end();
    }

    static void exportSpans(String ... spans) {
        SampledSpanStore store = Tracing.getExportComponent().getSampledSpanStore();
        if (store != null) {
            store.registerSpanNamesForCollection(Arrays.asList(spans));
        }
    }
}

