/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.pathtemplate.PathTemplate;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.spi.v1.SpannerErrorInterceptor;
import com.google.cloud.spanner.spi.v1.SpannerMetadataProvider;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.cloud.spanner.spi.v1.WatchdogInterceptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsGrpc;
import com.google.protobuf.FieldMask;
import com.google.spanner.admin.database.v1.CreateDatabaseRequest;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DatabaseAdminGrpc;
import com.google.spanner.admin.database.v1.DropDatabaseRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlResponse;
import com.google.spanner.admin.database.v1.GetDatabaseRequest;
import com.google.spanner.admin.database.v1.ListDatabasesRequest;
import com.google.spanner.admin.database.v1.ListDatabasesResponse;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import com.google.spanner.admin.instance.v1.CreateInstanceRequest;
import com.google.spanner.admin.instance.v1.DeleteInstanceRequest;
import com.google.spanner.admin.instance.v1.GetInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.GetInstanceRequest;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceAdminGrpc;
import com.google.spanner.admin.instance.v1.InstanceConfig;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsRequest;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsResponse;
import com.google.spanner.admin.instance.v1.ListInstancesRequest;
import com.google.spanner.admin.instance.v1.ListInstancesResponse;
import com.google.spanner.admin.instance.v1.UpdateInstanceRequest;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.SpannerGrpc;
import com.google.spanner.v1.Transaction;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Context;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ClientResponseObserver;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SampledSpanStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class GrpcSpannerRpc
implements SpannerRpc {
    private static final Logger logger;
    private static final PathTemplate PROJECT_NAME_TEMPLATE;
    private final Random random = new Random();
    private final List<Channel> channels;
    private final String projectId;
    private final String projectName;
    private final CallCredentials credentials;
    private final SpannerMetadataProvider metadataProvider;

    public GrpcSpannerRpc(SpannerOptions options) {
        this.projectId = options.getProjectId();
        this.projectName = PROJECT_NAME_TEMPLATE.instantiate(new String[]{"project", this.projectId});
        this.credentials = GrpcSpannerRpc.callCredentials(options);
        ImmutableList.Builder channelsBuilder = ImmutableList.builder();
        ImmutableList.Builder stubsBuilder = ImmutableList.builder();
        for (Channel channel : options.getRpcChannels()) {
            Channel channel2 = ClientInterceptors.intercept((Channel)channel, (ClientInterceptor[])new ClientInterceptor[]{new LoggingInterceptor(Level.FINER), WatchdogInterceptor.newDefaultWatchdogInterceptor(), new SpannerErrorInterceptor()});
            channelsBuilder.add((Object)channel2);
            stubsBuilder.add((Object)this.withCredentials(SpannerGrpc.newFutureStub((Channel)channel2), this.credentials));
        }
        this.channels = channelsBuilder.build();
        ApiClientHeaderProvider.Builder internalHeaderProviderBuilder = ApiClientHeaderProvider.newBuilder();
        ApiClientHeaderProvider apiClientHeaderProvider = internalHeaderProviderBuilder.setClientLibToken(ServiceOptions.getGoogApiClientLibName(), GaxProperties.getLibraryVersion(((Object)((Object)options)).getClass())).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion()).build();
        HeaderProvider mergedHeaderProvider = options.getMergedHeaderProvider((HeaderProvider)apiClientHeaderProvider);
        this.metadataProvider = SpannerMetadataProvider.create(mergedHeaderProvider.getHeaders(), internalHeaderProviderBuilder.getResourceHeaderKey());
    }

    private static CallCredentials callCredentials(SpannerOptions options) {
        if (options.getCredentials() == null) {
            return null;
        }
        if (options.getCredentials().equals(NoCredentials.getInstance())) {
            return null;
        }
        return MoreCallCredentials.from((Credentials)options.getScopedCredentials());
    }

    private <S extends AbstractStub<S>> S withCredentials(S stub, CallCredentials credentials) {
        if (credentials == null) {
            return stub;
        }
        return (S)stub.withCallCredentials(credentials);
    }

    private String projectName() {
        return this.projectName;
    }

    @Override
    public SpannerRpc.Paginated<InstanceConfig> listInstanceConfigs(int pageSize, @Nullable String pageToken) throws SpannerException {
        ListInstanceConfigsRequest.Builder request = ListInstanceConfigsRequest.newBuilder().setParent(this.projectName()).setPageSize(0);
        if (pageToken != null) {
            request.setPageToken(pageToken);
        }
        ListInstanceConfigsResponse response = (ListInstanceConfigsResponse)GrpcSpannerRpc.get(this.doUnaryCall(InstanceAdminGrpc.METHOD_LIST_INSTANCE_CONFIGS, request.build(), this.projectName(), null));
        return new SpannerRpc.Paginated<InstanceConfig>(response.getInstanceConfigsList(), response.getNextPageToken());
    }

    @Override
    public InstanceConfig getInstanceConfig(String instanceConfigName) throws SpannerException {
        GetInstanceConfigRequest request = GetInstanceConfigRequest.newBuilder().setName(instanceConfigName).build();
        return (InstanceConfig)GrpcSpannerRpc.get(this.doUnaryCall(InstanceAdminGrpc.METHOD_GET_INSTANCE_CONFIG, request, this.projectName(), null));
    }

    @Override
    public SpannerRpc.Paginated<Instance> listInstances(int pageSize, @Nullable String pageToken, @Nullable String filter) throws SpannerException {
        ListInstancesRequest.Builder request = ListInstancesRequest.newBuilder().setParent(this.projectName()).setPageSize(pageSize);
        if (pageToken != null) {
            request.setPageToken(pageToken);
        }
        if (filter != null) {
            request.setFilter(filter);
        }
        ListInstancesResponse response = (ListInstancesResponse)GrpcSpannerRpc.get(this.doUnaryCall(InstanceAdminGrpc.METHOD_LIST_INSTANCES, request.build(), this.projectName(), null));
        return new SpannerRpc.Paginated<Instance>(response.getInstancesList(), response.getNextPageToken());
    }

    @Override
    public Operation createInstance(String parent, String instanceId, Instance instance) throws SpannerException {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstanceId(instanceId).setInstance(instance).build();
        return (Operation)GrpcSpannerRpc.get(this.doUnaryCall(InstanceAdminGrpc.METHOD_CREATE_INSTANCE, request, parent, null));
    }

    @Override
    public Operation updateInstance(Instance instance, FieldMask fieldMask) throws SpannerException {
        UpdateInstanceRequest request = UpdateInstanceRequest.newBuilder().setInstance(instance).setFieldMask(fieldMask).build();
        return (Operation)GrpcSpannerRpc.get(this.doUnaryCall(InstanceAdminGrpc.METHOD_UPDATE_INSTANCE, request, instance.getName(), null));
    }

    @Override
    public Instance getInstance(String instanceName) throws SpannerException {
        return (Instance)GrpcSpannerRpc.get(this.doUnaryCall(InstanceAdminGrpc.METHOD_GET_INSTANCE, GetInstanceRequest.newBuilder().setName(instanceName).build(), instanceName, null));
    }

    @Override
    public void deleteInstance(String instanceName) throws SpannerException {
        GrpcSpannerRpc.get(this.doUnaryCall(InstanceAdminGrpc.METHOD_DELETE_INSTANCE, DeleteInstanceRequest.newBuilder().setName(instanceName).build(), instanceName, null));
    }

    @Override
    public SpannerRpc.Paginated<Database> listDatabases(String instanceName, int pageSize, @Nullable String pageToken) throws SpannerException {
        ListDatabasesRequest.Builder builder = ListDatabasesRequest.newBuilder().setParent(instanceName).setPageSize(pageSize);
        if (pageToken != null) {
            builder.setPageToken(pageToken);
        }
        ListDatabasesResponse response = (ListDatabasesResponse)GrpcSpannerRpc.get(this.doUnaryCall(DatabaseAdminGrpc.METHOD_LIST_DATABASES, builder.build(), instanceName, null));
        return new SpannerRpc.Paginated<Database>(response.getDatabasesList(), response.getNextPageToken());
    }

    @Override
    public Operation createDatabase(String instanceName, String createDatabaseStatement, Iterable<String> additionalStatements) throws SpannerException {
        CreateDatabaseRequest request = CreateDatabaseRequest.newBuilder().setParent(instanceName).setCreateStatement(createDatabaseStatement).addAllExtraStatements(additionalStatements).build();
        return (Operation)GrpcSpannerRpc.get(this.doUnaryCall(DatabaseAdminGrpc.METHOD_CREATE_DATABASE, request, instanceName, null));
    }

    @Override
    public Operation updateDatabaseDdl(String databaseName, Iterable<String> updateStatements, @Nullable String operationId) throws SpannerException {
        UpdateDatabaseDdlRequest request = UpdateDatabaseDdlRequest.newBuilder().setDatabase(databaseName).addAllStatements(updateStatements).setOperationId((String)MoreObjects.firstNonNull((Object)operationId, (Object)"")).build();
        return (Operation)GrpcSpannerRpc.get(this.doUnaryCall(DatabaseAdminGrpc.METHOD_UPDATE_DATABASE_DDL, request, databaseName, null));
    }

    @Override
    public void dropDatabase(String databaseName) throws SpannerException {
        GrpcSpannerRpc.get(this.doUnaryCall(DatabaseAdminGrpc.METHOD_DROP_DATABASE, DropDatabaseRequest.newBuilder().setDatabase(databaseName).build(), databaseName, null));
    }

    @Override
    public List<String> getDatabaseDdl(String databaseName) throws SpannerException {
        GetDatabaseDdlRequest request = GetDatabaseDdlRequest.newBuilder().setDatabase(databaseName).build();
        return ((GetDatabaseDdlResponse)GrpcSpannerRpc.get(this.doUnaryCall(DatabaseAdminGrpc.METHOD_GET_DATABASE_DDL, request, databaseName, null))).getStatementsList();
    }

    @Override
    public Database getDatabase(String databaseName) throws SpannerException {
        return (Database)GrpcSpannerRpc.get(this.doUnaryCall(DatabaseAdminGrpc.METHOD_GET_DATABASE, GetDatabaseRequest.newBuilder().setName(databaseName).build(), databaseName, null));
    }

    @Override
    public Operation getOperation(String name) throws SpannerException {
        GetOperationRequest request = GetOperationRequest.newBuilder().setName(name).build();
        return (Operation)GrpcSpannerRpc.get(this.doUnaryCall(OperationsGrpc.METHOD_GET_OPERATION, request, name, null));
    }

    @Override
    public Session createSession(String databaseName, @Nullable Map<String, String> labels, @Nullable Map<SpannerRpc.Option, ?> options) {
        CreateSessionRequest.Builder request = CreateSessionRequest.newBuilder().setDatabase(databaseName);
        if (labels != null && !labels.isEmpty()) {
            Session.Builder session = Session.newBuilder().putAllLabels(labels);
            request.setSession(session);
        }
        return (Session)GrpcSpannerRpc.get(this.doUnaryCall(SpannerGrpc.METHOD_CREATE_SESSION, request.build(), databaseName, SpannerRpc.Option.CHANNEL_HINT.getLong(options)));
    }

    @Override
    public void deleteSession(String sessionName, @Nullable Map<SpannerRpc.Option, ?> options) {
        DeleteSessionRequest request = DeleteSessionRequest.newBuilder().setName(sessionName).build();
        GrpcSpannerRpc.get(this.doUnaryCall(SpannerGrpc.METHOD_DELETE_SESSION, request, sessionName, SpannerRpc.Option.CHANNEL_HINT.getLong(options)));
    }

    @Override
    public SpannerRpc.StreamingCall read(ReadRequest request, SpannerRpc.ResultStreamConsumer consumer, @Nullable Map<SpannerRpc.Option, ?> options) {
        return this.doStreamingCall(SpannerGrpc.METHOD_STREAMING_READ, request, consumer, request.getSession(), SpannerRpc.Option.CHANNEL_HINT.getLong(options));
    }

    @Override
    public SpannerRpc.StreamingCall executeQuery(ExecuteSqlRequest request, SpannerRpc.ResultStreamConsumer consumer, @Nullable Map<SpannerRpc.Option, ?> options) {
        return this.doStreamingCall(SpannerGrpc.METHOD_EXECUTE_STREAMING_SQL, request, consumer, request.getSession(), SpannerRpc.Option.CHANNEL_HINT.getLong(options));
    }

    @Override
    public Transaction beginTransaction(BeginTransactionRequest request, @Nullable Map<SpannerRpc.Option, ?> options) {
        return (Transaction)GrpcSpannerRpc.get(this.doUnaryCall(SpannerGrpc.METHOD_BEGIN_TRANSACTION, request, request.getSession(), SpannerRpc.Option.CHANNEL_HINT.getLong(options)));
    }

    @Override
    public CommitResponse commit(CommitRequest commitRequest, @Nullable Map<SpannerRpc.Option, ?> options) {
        return (CommitResponse)GrpcSpannerRpc.get(this.doUnaryCall(SpannerGrpc.METHOD_COMMIT, commitRequest, commitRequest.getSession(), SpannerRpc.Option.CHANNEL_HINT.getLong(options)));
    }

    @Override
    public void rollback(RollbackRequest request, @Nullable Map<SpannerRpc.Option, ?> options) {
        GrpcSpannerRpc.get(this.doUnaryCall(SpannerGrpc.METHOD_ROLLBACK, request, request.getSession(), SpannerRpc.Option.CHANNEL_HINT.getLong(options)));
    }

    @Override
    public PartitionResponse partitionQuery(PartitionQueryRequest request, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        return (PartitionResponse)GrpcSpannerRpc.get(this.doUnaryCall(SpannerGrpc.METHOD_PARTITION_QUERY, request, request.getSession(), SpannerRpc.Option.CHANNEL_HINT.getLong(options)));
    }

    @Override
    public PartitionResponse partitionRead(PartitionReadRequest request, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        return (PartitionResponse)GrpcSpannerRpc.get(this.doUnaryCall(SpannerGrpc.METHOD_PARTITION_READ, request, request.getSession(), SpannerRpc.Option.CHANNEL_HINT.getLong(options)));
    }

    private static <T> T get(Future<T> future) throws SpannerException {
        Context context = Context.current();
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw SpannerExceptionFactory.propagateInterrupt(e);
        }
        catch (CancellationException | ExecutionException e) {
            throw SpannerExceptionFactory.newSpannerException(context, e);
        }
    }

    private <ReqT, RespT> Future<RespT> doUnaryCall(MethodDescriptor<ReqT, RespT> method, ReqT request, @Nullable String resource, @Nullable Long channelHint) {
        CallOptions callOptions = this.credentials == null ? CallOptions.DEFAULT : CallOptions.DEFAULT.withCallCredentials(this.credentials);
        MetadataClientCall call = new MetadataClientCall(this.pick(channelHint, this.channels).newCall(method, callOptions), this.metadataProvider.newMetadata(resource, this.projectName()));
        return ClientCalls.futureUnaryCall(call, request);
    }

    private <T> SpannerRpc.StreamingCall doStreamingCall(MethodDescriptor<T, PartialResultSet> method, T request, SpannerRpc.ResultStreamConsumer consumer, @Nullable String resource, @Nullable Long channelHint) {
        Context context = Context.current();
        CallOptions callOptions = this.credentials == null ? CallOptions.DEFAULT : CallOptions.DEFAULT.withCallCredentials(this.credentials);
        MetadataClientCall call = new MetadataClientCall(this.pick(channelHint, this.channels).newCall(method, callOptions), this.metadataProvider.newMetadata(resource, this.projectName()));
        ResultSetStreamObserver observer = new ResultSetStreamObserver(consumer, context, call);
        ClientCalls.asyncServerStreamingCall(call, request, observer);
        return observer;
    }

    private <T> T pick(@Nullable Long hint, List<T> elements) {
        long hintVal = Math.abs(hint != null ? hint.longValue() : this.random.nextLong());
        long index = hintVal % (long)elements.size();
        return elements.get((int)index);
    }

    private static void setupTracingConfig() {
        SampledSpanStore store = Tracing.getExportComponent().getSampledSpanStore();
        if (store == null) {
            return;
        }
        ArrayList<String> descriptors = new ArrayList<String>();
        GrpcSpannerRpc.addDescriptor(descriptors, SpannerGrpc.getServiceDescriptor());
        GrpcSpannerRpc.addDescriptor(descriptors, DatabaseAdminGrpc.getServiceDescriptor());
        GrpcSpannerRpc.addDescriptor(descriptors, InstanceAdminGrpc.getServiceDescriptor());
        store.registerSpanNamesForCollection(descriptors);
    }

    private static void addDescriptor(List<String> descriptors, ServiceDescriptor serviceDescriptor) {
        for (MethodDescriptor method : serviceDescriptor.getMethods()) {
            descriptors.add("Sent." + method.getFullMethodName().replace('/', '.'));
        }
    }

    static {
        GrpcSpannerRpc.setupTracingConfig();
        logger = Logger.getLogger(GrpcSpannerRpc.class.getName());
        PROJECT_NAME_TEMPLATE = PathTemplate.create((String)"projects/{project}");
    }

    private static class LoggingInterceptor
    implements ClientInterceptor {
        private final Level level;

        LoggingInterceptor(Level level) {
            this.level = level;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            if (!logger.isLoggable(this.level)) {
                return next.newCall(method, callOptions);
            }
            final CallLogger callLogger = new CallLogger(method);
            callLogger.log("Start");
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onMessage(RespT message) {
                            callLogger.logfmt("Received:\n%s", message);
                            super.onMessage(message);
                        }

                        public void onClose(Status status, Metadata trailers) {
                            callLogger.logfmt("Closed with status %s and trailers %s", status, trailers);
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }

                public void sendMessage(ReqT message) {
                    callLogger.logfmt("Send:\n%s", message);
                    super.sendMessage(message);
                }

                public void cancel(@Nullable String message, @Nullable Throwable cause) {
                    callLogger.logfmt("Cancelled with message %s", message);
                    super.cancel(message, cause);
                }
            };
        }

        private class CallLogger {
            private final MethodDescriptor<?, ?> method;

            CallLogger(MethodDescriptor<?, ?> method) {
                this.method = method;
            }

            void log(String message) {
                logger.log(LoggingInterceptor.this.level, "{0}[{1}]: {2}", new Object[]{this.method.getFullMethodName(), Integer.toHexString(System.identityHashCode(this)), message});
            }

            void logfmt(String message, Object ... params) {
                this.log(String.format(message, params));
            }
        }
    }

    private static class ResultSetStreamObserver<T>
    implements ClientResponseObserver<T, PartialResultSet>,
    SpannerRpc.StreamingCall {
        private final SpannerRpc.ResultStreamConsumer consumer;
        private final Context context;
        private final ClientCall<T, PartialResultSet> call;
        private volatile ClientCallStreamObserver<T> requestStream;

        public ResultSetStreamObserver(SpannerRpc.ResultStreamConsumer consumer, Context context, ClientCall<T, PartialResultSet> call) {
            this.consumer = consumer;
            this.context = context;
            this.call = call;
        }

        public void beforeStart(ClientCallStreamObserver<T> requestStream) {
            this.requestStream = requestStream;
            requestStream.disableAutoInboundFlowControl();
        }

        public void onNext(PartialResultSet value) {
            this.consumer.onPartialResultSet(value);
        }

        public void onError(Throwable t) {
            this.consumer.onError(SpannerExceptionFactory.newSpannerException(this.context, t));
        }

        public void onCompleted() {
            this.consumer.onCompleted();
        }

        @Override
        public void request(int numMessages) {
            this.requestStream.request(numMessages);
        }

        @Override
        public void cancel(@Nullable String message) {
            this.call.cancel(message, null);
        }
    }

    @VisibleForTesting
    static class MetadataClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private final Metadata extraMetadata;

        MetadataClientCall(ClientCall<ReqT, RespT> call, Metadata extraMetadata) {
            super(call);
            this.extraMetadata = extraMetadata;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata metadata) {
            metadata.merge(this.extraMetadata);
            super.start(responseListener, metadata);
        }
    }
}

