/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetNavigationTester;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public class SortedMultisetTestSuiteBuilder<E>
extends MultisetTestSuiteBuilder<E> {
    public static <E> SortedMultisetTestSuiteBuilder<E> using(TestMultisetGenerator<E> generator) {
        SortedMultisetTestSuiteBuilder<E> result = new SortedMultisetTestSuiteBuilder<E>();
        result.usingGenerator(generator);
        return result;
    }

    @Override
    public TestSuite createTestSuite() {
        TestSuite suite = super.createTestSuite();
        for (TestSuite subSuite : this.createDerivedSuites(this)) {
            suite.addTest((Test)subSuite);
        }
        return suite;
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        List<Class<? extends AbstractTester>> testers = Helpers.copyToList(super.getTesters());
        testers.add(MultisetNavigationTester.class);
        return testers;
    }

    List<TestSuite> createDerivedSuites(SortedMultisetTestSuiteBuilder<E> parentBuilder) {
        ArrayList derivedSuites = Lists.newArrayList();
        if (!parentBuilder.getFeatures().contains(NoRecurse.DESCENDING)) {
            derivedSuites.add(this.createDescendingSuite(parentBuilder));
        }
        if (!parentBuilder.getFeatures().contains(NoRecurse.SUBMULTISET)) {
            derivedSuites.add(this.createSubMultisetSuite(parentBuilder, Bound.NO_BOUND, Bound.EXCLUSIVE));
            derivedSuites.add(this.createSubMultisetSuite(parentBuilder, Bound.NO_BOUND, Bound.INCLUSIVE));
            derivedSuites.add(this.createSubMultisetSuite(parentBuilder, Bound.EXCLUSIVE, Bound.NO_BOUND));
            derivedSuites.add(this.createSubMultisetSuite(parentBuilder, Bound.EXCLUSIVE, Bound.EXCLUSIVE));
            derivedSuites.add(this.createSubMultisetSuite(parentBuilder, Bound.EXCLUSIVE, Bound.INCLUSIVE));
            derivedSuites.add(this.createSubMultisetSuite(parentBuilder, Bound.INCLUSIVE, Bound.NO_BOUND));
            derivedSuites.add(this.createSubMultisetSuite(parentBuilder, Bound.INCLUSIVE, Bound.EXCLUSIVE));
            derivedSuites.add(this.createSubMultisetSuite(parentBuilder, Bound.INCLUSIVE, Bound.INCLUSIVE));
        }
        return derivedSuites;
    }

    private TestSuite createSubMultisetSuite(SortedMultisetTestSuiteBuilder<E> parentBuilder, final Bound from, final Bound to) {
        final TestMultisetGenerator delegate = (TestMultisetGenerator)parentBuilder.getSubjectGenerator();
        ArrayList<Object> features = new ArrayList<Object>();
        features.add(NoRecurse.SUBMULTISET);
        features.add(CollectionFeature.RESTRICTS_ELEMENTS);
        features.addAll(parentBuilder.getFeatures());
        SortedMultiset emptyMultiset = (SortedMultiset)delegate.create(new Object[0]);
        final Comparator comparator = emptyMultiset.comparator();
        SampleElements samples = delegate.samples();
        List<Object> samplesList = Arrays.asList(samples.e0, samples.e1, samples.e2, samples.e3, samples.e4);
        Collections.sort(samplesList, comparator);
        final Object firstInclusive = samplesList.get(0);
        final Object lastInclusive = samplesList.get(samplesList.size() - 1);
        return ((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)SortedMultisetTestSuiteBuilder.using(new ForwardingTestMultisetGenerator<E>(delegate){

            @Override
            public SortedMultiset<E> create(Object ... entries) {
                List extremeValues = SortedMultisetTestSuiteBuilder.this.getExtremeValues();
                List<Object> normalValues = Arrays.asList(entries);
                Collections.sort(extremeValues, comparator);
                Object firstExclusive = extremeValues.get(1);
                Object lastExclusive = extremeValues.get(2);
                if (from == Bound.NO_BOUND) {
                    extremeValues.remove(0);
                    extremeValues.remove(0);
                }
                if (to == Bound.NO_BOUND) {
                    extremeValues.remove(extremeValues.size() - 1);
                    extremeValues.remove(extremeValues.size() - 1);
                }
                ArrayList<Object> allEntries = new ArrayList<Object>();
                allEntries.addAll(extremeValues);
                allEntries.addAll(normalValues);
                SortedMultiset multiset = (SortedMultiset)delegate.create(allEntries.toArray());
                if (from == Bound.INCLUSIVE) {
                    multiset = multiset.tailMultiset(firstInclusive, BoundType.CLOSED);
                } else if (from == Bound.EXCLUSIVE) {
                    multiset = multiset.tailMultiset(firstExclusive, BoundType.OPEN);
                }
                if (to == Bound.INCLUSIVE) {
                    multiset = multiset.headMultiset(lastInclusive, BoundType.CLOSED);
                } else if (to == Bound.EXCLUSIVE) {
                    multiset = multiset.headMultiset(lastExclusive, BoundType.OPEN);
                }
                return multiset;
            }
        }).named(parentBuilder.getName() + " subMultiset " + (Object)((Object)from) + "-" + (Object)((Object)to))).withFeatures(features)).suppressing(parentBuilder.getSuppressedTests())).createTestSuite();
    }

    private List<String> getExtremeValues() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("!! a");
        result.add("!! b");
        result.add("~~ y");
        result.add("~~ z");
        return result;
    }

    private TestSuite createDescendingSuite(SortedMultisetTestSuiteBuilder<E> parentBuilder) {
        TestMultisetGenerator delegate = (TestMultisetGenerator)parentBuilder.getSubjectGenerator();
        ArrayList features = new ArrayList();
        features.add(NoRecurse.DESCENDING);
        features.addAll(parentBuilder.getFeatures());
        return ((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)SortedMultisetTestSuiteBuilder.using(new ForwardingTestMultisetGenerator<E>(delegate){

            @Override
            public SortedMultiset<E> create(Object ... entries) {
                return ((SortedMultiset)super.create(entries)).descendingMultiset();
            }

            @Override
            public Iterable<E> order(List<E> insertionOrder) {
                return ImmutableList.copyOf(super.order(insertionOrder)).reverse();
            }
        }).named(parentBuilder.getName() + " descending")).withFeatures(features)).suppressing(parentBuilder.getSuppressedTests())).createTestSuite();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardingTestMultisetGenerator<E>
    implements TestMultisetGenerator<E> {
        private final TestMultisetGenerator<E> delegate;

        ForwardingTestMultisetGenerator(TestMultisetGenerator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public SampleElements<E> samples() {
            return this.delegate.samples();
        }

        @Override
        public E[] createArray(int length) {
            return this.delegate.createArray(length);
        }

        @Override
        public Iterable<E> order(List<E> insertionOrder) {
            return this.delegate.order(insertionOrder);
        }

        @Override
        public Multiset<E> create(Object ... elements) {
            return this.delegate.create(elements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Bound {
        INCLUSIVE,
        EXCLUSIVE,
        NO_BOUND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NoRecurse implements Feature<Void>
    {
        SUBMULTISET,
        DESCENDING;


        @Override
        public Set<Feature<? super Void>> getImpliedFeatures() {
            return Collections.emptySet();
        }
    }
}

