/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.stats;

import com.google.instrumentation.common.Duration;
import com.google.instrumentation.stats.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IntervalAggregation {
    private final List<Tag> tags;
    private final List<Interval> intervals;

    public static final IntervalAggregation create(List<Tag> list, List<Interval> list2) {
        return new IntervalAggregation(list, list2);
    }

    public final List<Tag> getTags() {
        return this.tags;
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    private IntervalAggregation(List<Tag> list, List<Interval> list2) {
        this.tags = list;
        this.intervals = Collections.unmodifiableList(new ArrayList<Interval>(list2));
    }

    public static final class Interval {
        private final Duration intervalSize;
        private final double count;
        private final double sum;

        public static Interval create(Duration duration, double d, double d2) {
            return new Interval(duration, d, d2);
        }

        public Duration getIntervalSize() {
            return this.intervalSize;
        }

        public double getCount() {
            return this.count;
        }

        public double getSum() {
            return this.sum;
        }

        private Interval(Duration duration, double d, double d2) {
            this.intervalSize = duration;
            this.count = d;
            this.sum = d2;
        }
    }
}

