/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.maps.GeoApiContext;
import com.google.maps.PendingResult;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.PolylineEncoding;
import com.google.maps.internal.StringJoin;
import com.google.maps.model.ElevationResult;
import com.google.maps.model.EncodedPolyline;
import com.google.maps.model.LatLng;

public class ElevationApi {
    private static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/elevation/json");

    private ElevationApi() {
    }

    public static PendingResult<ElevationResult[]> getByPoints(GeoApiContext context, LatLng ... points) {
        return context.get(API_CONFIG, MultiResponse.class, "locations", ElevationApi.shortestParam(points));
    }

    public static PendingResult<ElevationResult[]> getByPath(GeoApiContext context, int samples, LatLng ... path) {
        return context.get(API_CONFIG, MultiResponse.class, "samples", String.valueOf(samples), "path", ElevationApi.shortestParam(path));
    }

    public static PendingResult<ElevationResult[]> getByPath(GeoApiContext context, int samples, EncodedPolyline encodedPolyline) {
        String[] stringArray = new String[4];
        stringArray[0] = "samples";
        stringArray[1] = String.valueOf(samples);
        stringArray[2] = "path";
        String string = String.valueOf(encodedPolyline.getEncodedPath());
        stringArray[3] = string.length() != 0 ? "enc:".concat(string) : new String("enc:");
        return context.get(API_CONFIG, MultiResponse.class, stringArray);
    }

    private static String shortestParam(LatLng[] points) {
        String joined = StringJoin.join('|', points);
        String string = String.valueOf(PolylineEncoding.encode(points));
        String encoded = string.length() != 0 ? "enc:".concat(string) : new String("enc:");
        return joined.length() < encoded.length() ? joined : encoded;
    }

    public static PendingResult<ElevationResult> getByPoint(GeoApiContext context, LatLng point) {
        return context.get(API_CONFIG, SingularResponse.class, "locations", point.toString());
    }

    public static PendingResult<ElevationResult[]> getByPoints(GeoApiContext context, EncodedPolyline encodedPolyline) {
        String[] stringArray = new String[2];
        stringArray[0] = "locations";
        String string = String.valueOf(encodedPolyline.getEncodedPath());
        stringArray[1] = string.length() != 0 ? "enc:".concat(string) : new String("enc:");
        return context.get(API_CONFIG, MultiResponse.class, stringArray);
    }

    private static class MultiResponse
    implements ApiResponse<ElevationResult[]> {
        public String status;
        public String errorMessage;
        public ElevationResult[] results;

        private MultiResponse() {
        }

        @Override
        public boolean successful() {
            return "OK".equals(this.status);
        }

        @Override
        public ElevationResult[] getResult() {
            return this.results;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }

    private static class SingularResponse
    implements ApiResponse<ElevationResult> {
        public String status;
        public String errorMessage;
        public ElevationResult[] results;

        private SingularResponse() {
        }

        @Override
        public boolean successful() {
            return "OK".equals(this.status);
        }

        @Override
        public ElevationResult getResult() {
            return this.results[0];
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

