/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.rtree.SpatialDataType;
import org.h2.mvstore.rtree.SpatialKey;
import org.h2.result.SortOrder;
import org.h2.store.DataHandler;
import org.h2.tools.SimpleResultSet;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueUuid;

public class ValueDataType
implements org.h2.mvstore.type.DataType {
    private static final int INT_0_15 = 32;
    private static final int LONG_0_7 = 48;
    private static final int DECIMAL_0_1 = 56;
    private static final int DECIMAL_SMALL_0 = 58;
    private static final int DECIMAL_SMALL = 59;
    private static final int DOUBLE_0_1 = 60;
    private static final int FLOAT_0_1 = 62;
    private static final int BOOLEAN_FALSE = 64;
    private static final int BOOLEAN_TRUE = 65;
    private static final int INT_NEG = 66;
    private static final int LONG_NEG = 67;
    private static final int STRING_0_31 = 68;
    private static final int BYTES_0_31 = 100;
    private static final int SPATIAL_KEY_2D = 132;
    final DataHandler handler;
    final CompareMode compareMode;
    final int[] sortTypes;
    SpatialDataType spatialType;

    public ValueDataType(CompareMode compareMode, DataHandler dataHandler, int[] nArray) {
        this.compareMode = compareMode;
        this.handler = dataHandler;
        this.sortTypes = nArray;
    }

    private SpatialDataType getSpatialDataType() {
        if (this.spatialType == null) {
            this.spatialType = new SpatialDataType(2);
        }
        return this.spatialType;
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object instanceof ValueArray && object2 instanceof ValueArray) {
            Value[] valueArray = ((ValueArray)object).getList();
            Value[] valueArray2 = ((ValueArray)object2).getList();
            int n = valueArray.length;
            int n2 = valueArray2.length;
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                int n4 = this.sortTypes[i];
                int n5 = this.compareValues(valueArray[i], valueArray2[i], n4);
                if (n5 == 0) continue;
                return n5;
            }
            if (n3 < n) {
                return -1;
            }
            if (n3 < n2) {
                return 1;
            }
            return 0;
        }
        return this.compareValues((Value)object, (Value)object2, 0);
    }

    private int compareValues(Value value, Value value2, int n) {
        boolean bl;
        if (value == value2) {
            return 0;
        }
        if (value == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        boolean bl2 = value == ValueNull.INSTANCE;
        boolean bl3 = bl = value2 == ValueNull.INSTANCE;
        if (bl2 || bl) {
            return SortOrder.compareNull(bl2, n);
        }
        int n2 = value.compareTypeSafe(value2, this.compareMode);
        if ((n & 1) != 0) {
            n2 = -n2;
        }
        return n2;
    }

    @Override
    public int getMemory(Object object) {
        if (object instanceof SpatialKey) {
            return this.getSpatialDataType().getMemory(object);
        }
        return ValueDataType.getMemory((Value)object);
    }

    private static int getMemory(Value value) {
        return value == null ? 0 : value.getMemory();
    }

    @Override
    public void read(ByteBuffer byteBuffer, Object[] objectArray, int n, boolean bl) {
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.read(byteBuffer);
        }
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object[] objectArray, int n, boolean bl) {
        for (int i = 0; i < n; ++i) {
            this.write(writeBuffer, objectArray[i]);
        }
    }

    @Override
    public Object read(ByteBuffer byteBuffer) {
        return this.readValue(byteBuffer);
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object object) {
        if (object instanceof SpatialKey) {
            writeBuffer.put((byte)-124);
            this.getSpatialDataType().write(writeBuffer, object);
            return;
        }
        Value value = (Value)object;
        this.writeValue(writeBuffer, value);
    }

    private void writeValue(WriteBuffer writeBuffer, Value value) {
        if (value == ValueNull.INSTANCE) {
            writeBuffer.put((byte)0);
            return;
        }
        int n = value.getType();
        switch (n) {
            case 1: {
                writeBuffer.put((byte)(value.getBoolean() != false ? 65 : 64));
                break;
            }
            case 2: {
                writeBuffer.put((byte)n).put(value.getByte());
                break;
            }
            case 3: {
                writeBuffer.put((byte)n).putShort(value.getShort());
                break;
            }
            case 4: {
                int n2 = value.getInt();
                if (n2 < 0) {
                    writeBuffer.put((byte)66).putVarInt(-n2);
                    break;
                }
                if (n2 < 16) {
                    writeBuffer.put((byte)(32 + n2));
                    break;
                }
                writeBuffer.put((byte)n).putVarInt(n2);
                break;
            }
            case 5: {
                long l = value.getLong();
                if (l < 0L) {
                    writeBuffer.put((byte)67).putVarLong(-l);
                    break;
                }
                if (l < 8L) {
                    writeBuffer.put((byte)(48L + l));
                    break;
                }
                writeBuffer.put((byte)n).putVarLong(l);
                break;
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    writeBuffer.put((byte)56);
                    break;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    writeBuffer.put((byte)57);
                    break;
                }
                int n3 = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n4 = bigInteger.bitLength();
                if (n4 <= 63) {
                    if (n3 == 0) {
                        writeBuffer.put((byte)58).putVarLong(bigInteger.longValue());
                        break;
                    }
                    writeBuffer.put((byte)59).putVarInt(n3).putVarLong(bigInteger.longValue());
                    break;
                }
                byte[] byArray = bigInteger.toByteArray();
                writeBuffer.put((byte)n).putVarInt(n3).putVarInt(byArray.length).put(byArray);
                break;
            }
            case 9: {
                ValueTime valueTime = (ValueTime)value;
                long l = valueTime.getNanos();
                long l2 = l / 1000000L;
                writeBuffer.put((byte)n).putVarLong(l2).putVarLong(l -= l2 * 1000000L);
                break;
            }
            case 10: {
                long l = ((ValueDate)value).getDateValue();
                writeBuffer.put((byte)n).putVarLong(l);
                break;
            }
            case 11: {
                ValueTimestamp valueTimestamp = (ValueTimestamp)value;
                long l = valueTimestamp.getDateValue();
                long l3 = valueTimestamp.getTimeNanos();
                long l4 = l3 / 1000000L;
                writeBuffer.put((byte)n).putVarLong(l).putVarLong(l4).putVarLong(l3 -= l4 * 1000000L);
                break;
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                long l = valueTimestampTimeZone.getDateValue();
                long l5 = valueTimestampTimeZone.getTimeNanos();
                long l6 = l5 / 1000000L;
                writeBuffer.put((byte)n).putVarLong(l).putVarLong(l6).putVarLong(l5 -= l6 * 1000000L).putVarInt(valueTimestampTimeZone.getTimeZoneOffsetMins());
                break;
            }
            case 19: {
                byte[] byArray = value.getBytesNoCopy();
                writeBuffer.put((byte)n).putVarInt(byArray.length).put(byArray);
                break;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n5 = byArray.length;
                if (n5 < 32) {
                    writeBuffer.put((byte)(100 + n5)).put(byArray);
                    break;
                }
                writeBuffer.put((byte)n).putVarInt(byArray.length).put(byArray);
                break;
            }
            case 20: {
                ValueUuid valueUuid = (ValueUuid)value;
                writeBuffer.put((byte)n).putLong(valueUuid.getHigh()).putLong(valueUuid.getLow());
                break;
            }
            case 13: {
                String string = value.getString();
                int n6 = string.length();
                if (n6 < 32) {
                    writeBuffer.put((byte)(68 + n6)).putStringData(string, n6);
                    break;
                }
                writeBuffer.put((byte)n);
                ValueDataType.writeString(writeBuffer, string);
                break;
            }
            case 14: 
            case 21: {
                writeBuffer.put((byte)n);
                ValueDataType.writeString(writeBuffer, value.getString());
                break;
            }
            case 7: {
                double d = value.getDouble();
                if (d == 1.0) {
                    writeBuffer.put((byte)61);
                    break;
                }
                long l = Double.doubleToLongBits(d);
                if (l == ValueDouble.ZERO_BITS) {
                    writeBuffer.put((byte)60);
                    break;
                }
                writeBuffer.put((byte)n).putVarLong(Long.reverse(l));
                break;
            }
            case 8: {
                float f = value.getFloat();
                if (f == 1.0f) {
                    writeBuffer.put((byte)63);
                    break;
                }
                int n7 = Float.floatToIntBits(f);
                if (n7 == ValueFloat.ZERO_BITS) {
                    writeBuffer.put((byte)62);
                    break;
                }
                writeBuffer.put((byte)n).putVarInt(Integer.reverse(n7));
                break;
            }
            case 15: 
            case 16: {
                writeBuffer.put((byte)n);
                ValueLobDb valueLobDb = (ValueLobDb)value;
                byte[] byArray = valueLobDb.getSmall();
                if (byArray == null) {
                    writeBuffer.putVarInt(-3).putVarInt(valueLobDb.getTableId()).putVarLong(valueLobDb.getLobId()).putVarLong(valueLobDb.getPrecision());
                    break;
                }
                writeBuffer.putVarInt(byArray.length).put(byArray);
                break;
            }
            case 17: {
                Value[] valueArray = ((ValueArray)value).getList();
                writeBuffer.put((byte)n).putVarInt(valueArray.length);
                for (Value value2 : valueArray) {
                    this.writeValue(writeBuffer, value2);
                }
                break;
            }
            case 18: {
                writeBuffer.put((byte)n);
                try {
                    int n8;
                    ResultSet resultSet = ((ValueResultSet)value).getResultSet();
                    resultSet.beforeFirst();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n9 = resultSetMetaData.getColumnCount();
                    writeBuffer.putVarInt(n9);
                    for (n8 = 0; n8 < n9; ++n8) {
                        ValueDataType.writeString(writeBuffer, resultSetMetaData.getColumnName(n8 + 1));
                        writeBuffer.putVarInt(resultSetMetaData.getColumnType(n8 + 1)).putVarInt(resultSetMetaData.getPrecision(n8 + 1)).putVarInt(resultSetMetaData.getScale(n8 + 1));
                    }
                    while (resultSet.next()) {
                        writeBuffer.put((byte)1);
                        for (n8 = 0; n8 < n9; ++n8) {
                            int n10 = DataType.getValueTypeFromResultSet(resultSetMetaData, n8 + 1);
                            Value value3 = DataType.readValue(null, resultSet, n8 + 1, n10);
                            this.writeValue(writeBuffer, value3);
                        }
                    }
                    writeBuffer.put((byte)0);
                    resultSet.beforeFirst();
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
            case 22: {
                byte[] byArray = value.getBytes();
                int n11 = byArray.length;
                writeBuffer.put((byte)n).putVarInt(n11).put(byArray);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + value.getType());
            }
        }
    }

    private static void writeString(WriteBuffer writeBuffer, String string) {
        int n = string.length();
        writeBuffer.putVarInt(n).putStringData(string, n);
    }

    private Object readValue(ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        switch (n) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.get(true);
            }
            case 64: {
                return ValueBoolean.get(false);
            }
            case 66: {
                return ValueInt.get(-ValueDataType.readVarInt(byteBuffer));
            }
            case 4: {
                return ValueInt.get(ValueDataType.readVarInt(byteBuffer));
            }
            case 67: {
                return ValueLong.get(-ValueDataType.readVarLong(byteBuffer));
            }
            case 5: {
                return ValueLong.get(ValueDataType.readVarLong(byteBuffer));
            }
            case 2: {
                return ValueByte.get(byteBuffer.get());
            }
            case 3: {
                return ValueShort.get(byteBuffer.getShort());
            }
            case 56: {
                return ValueDecimal.ZERO;
            }
            case 57: {
                return ValueDecimal.ONE;
            }
            case 58: {
                return ValueDecimal.get(BigDecimal.valueOf(ValueDataType.readVarLong(byteBuffer)));
            }
            case 59: {
                int n2 = ValueDataType.readVarInt(byteBuffer);
                return ValueDecimal.get(BigDecimal.valueOf(ValueDataType.readVarLong(byteBuffer), n2));
            }
            case 6: {
                int n3 = ValueDataType.readVarInt(byteBuffer);
                int n4 = ValueDataType.readVarInt(byteBuffer);
                byte[] byArray = DataUtils.newBytes(n4);
                byteBuffer.get(byArray, 0, n4);
                BigInteger bigInteger = new BigInteger(byArray);
                return ValueDecimal.get(new BigDecimal(bigInteger, n3));
            }
            case 10: {
                return ValueDate.fromDateValue(ValueDataType.readVarLong(byteBuffer));
            }
            case 9: {
                long l = ValueDataType.readVarLong(byteBuffer) * 1000000L + ValueDataType.readVarLong(byteBuffer);
                return ValueTime.fromNanos(l);
            }
            case 11: {
                long l = ValueDataType.readVarLong(byteBuffer);
                long l2 = ValueDataType.readVarLong(byteBuffer) * 1000000L + ValueDataType.readVarLong(byteBuffer);
                return ValueTimestamp.fromDateValueAndNanos(l, l2);
            }
            case 24: {
                long l = ValueDataType.readVarLong(byteBuffer);
                long l3 = ValueDataType.readVarLong(byteBuffer) * 1000000L + ValueDataType.readVarLong(byteBuffer);
                short s = (short)ValueDataType.readVarInt(byteBuffer);
                return ValueTimestampTimeZone.fromDateValueAndNanos(l, l3, s);
            }
            case 12: {
                int n5 = ValueDataType.readVarInt(byteBuffer);
                byte[] byArray = DataUtils.newBytes(n5);
                byteBuffer.get(byArray, 0, n5);
                return ValueBytes.getNoCopy(byArray);
            }
            case 19: {
                int n6 = ValueDataType.readVarInt(byteBuffer);
                byte[] byArray = DataUtils.newBytes(n6);
                byteBuffer.get(byArray, 0, n6);
                return ValueJavaObject.getNoCopy(null, byArray, this.handler);
            }
            case 20: {
                return ValueUuid.get(byteBuffer.getLong(), byteBuffer.getLong());
            }
            case 13: {
                return ValueString.get(ValueDataType.readString(byteBuffer));
            }
            case 14: {
                return ValueStringIgnoreCase.get(ValueDataType.readString(byteBuffer));
            }
            case 21: {
                return ValueStringFixed.get(ValueDataType.readString(byteBuffer));
            }
            case 62: {
                return ValueFloat.get(0.0f);
            }
            case 63: {
                return ValueFloat.get(1.0f);
            }
            case 60: {
                return ValueDouble.get(0.0);
            }
            case 61: {
                return ValueDouble.get(1.0);
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(Long.reverse(ValueDataType.readVarLong(byteBuffer))));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(Integer.reverse(ValueDataType.readVarInt(byteBuffer))));
            }
            case 15: 
            case 16: {
                int n7 = ValueDataType.readVarInt(byteBuffer);
                if (n7 >= 0) {
                    byte[] byArray = DataUtils.newBytes(n7);
                    byteBuffer.get(byArray, 0, n7);
                    return ValueLobDb.createSmallLob(n, byArray);
                }
                if (n7 == -3) {
                    int n8 = ValueDataType.readVarInt(byteBuffer);
                    long l = ValueDataType.readVarLong(byteBuffer);
                    long l4 = ValueDataType.readVarLong(byteBuffer);
                    ValueLobDb valueLobDb = ValueLobDb.create(n, this.handler, n8, l, null, l4);
                    return valueLobDb;
                }
                throw DbException.get(90030, "lob type: " + n7);
            }
            case 17: {
                int n9 = ValueDataType.readVarInt(byteBuffer);
                Value[] valueArray = new Value[n9];
                for (int i = 0; i < n9; ++i) {
                    valueArray[i] = (Value)this.readValue(byteBuffer);
                }
                return ValueArray.get(valueArray);
            }
            case 18: {
                SimpleResultSet simpleResultSet = new SimpleResultSet();
                simpleResultSet.setAutoClose(false);
                int n10 = ValueDataType.readVarInt(byteBuffer);
                for (int i = 0; i < n10; ++i) {
                    simpleResultSet.addColumn(ValueDataType.readString(byteBuffer), ValueDataType.readVarInt(byteBuffer), ValueDataType.readVarInt(byteBuffer), ValueDataType.readVarInt(byteBuffer));
                }
                while (byteBuffer.get() != 0) {
                    Object[] objectArray = new Object[n10];
                    for (int i = 0; i < n10; ++i) {
                        objectArray[i] = ((Value)this.readValue(byteBuffer)).getObject();
                    }
                    simpleResultSet.addRow(objectArray);
                }
                return ValueResultSet.get(simpleResultSet);
            }
            case 22: {
                int n11 = ValueDataType.readVarInt(byteBuffer);
                byte[] byArray = DataUtils.newBytes(n11);
                byteBuffer.get(byArray, 0, n11);
                return ValueGeometry.get(byArray);
            }
            case 132: {
                return this.getSpatialDataType().read(byteBuffer);
            }
        }
        if (n >= 32 && n < 48) {
            return ValueInt.get(n - 32);
        }
        if (n >= 48 && n < 56) {
            return ValueLong.get(n - 48);
        }
        if (n >= 100 && n < 132) {
            int n12 = n - 100;
            byte[] byArray = DataUtils.newBytes(n12);
            byteBuffer.get(byArray, 0, n12);
            return ValueBytes.getNoCopy(byArray);
        }
        if (n >= 68 && n < 100) {
            return ValueString.get(ValueDataType.readString(byteBuffer, n - 68));
        }
        throw DbException.get(90030, "type: " + n);
    }

    private static int readVarInt(ByteBuffer byteBuffer) {
        return DataUtils.readVarInt(byteBuffer);
    }

    private static long readVarLong(ByteBuffer byteBuffer) {
        return DataUtils.readVarLong(byteBuffer);
    }

    private static String readString(ByteBuffer byteBuffer, int n) {
        return DataUtils.readString(byteBuffer, n);
    }

    private static String readString(ByteBuffer byteBuffer) {
        int n = ValueDataType.readVarInt(byteBuffer);
        return DataUtils.readString(byteBuffer, n);
    }

    public int hashCode() {
        return this.compareMode.hashCode() ^ Arrays.hashCode(this.sortTypes);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ValueDataType)) {
            return false;
        }
        ValueDataType valueDataType = (ValueDataType)object;
        if (!this.compareMode.equals(valueDataType.compareMode)) {
            return false;
        }
        return Arrays.equals(this.sortTypes, valueDataType.sortTypes);
    }
}

