/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfigReadOnly;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.io.Serializable;

public class NearCacheConfig
implements DataSerializable,
Serializable {
    public static final int DEFAULT_TTL_SECONDS = 0;
    public static final int DEFAULT_MAX_IDLE_SECONDS = 0;
    public static final int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;
    public static final String DEFAULT_EVICTION_POLICY = EvictionConfig.DEFAULT_EVICTION_POLICY.name();
    public static final InMemoryFormat DEFAULT_MEMORY_FORMAT = InMemoryFormat.BINARY;
    private int timeToLiveSeconds = 0;
    private int maxSize = Integer.MAX_VALUE;
    private String evictionPolicy = DEFAULT_EVICTION_POLICY;
    private int maxIdleSeconds = 0;
    private boolean invalidateOnChange = true;
    private InMemoryFormat inMemoryFormat = DEFAULT_MEMORY_FORMAT;
    private String name = "default";
    private NearCacheConfigReadOnly readOnly;
    private boolean cacheLocalEntries;
    private LocalUpdatePolicy localUpdatePolicy = LocalUpdatePolicy.INVALIDATE;
    private EvictionConfig evictionConfig = new EvictionConfig();

    public NearCacheConfig() {
    }

    public NearCacheConfig(String name) {
        this.name = name;
    }

    public NearCacheConfig(int timeToLiveSeconds, int maxSize, String evictionPolicy, int maxIdleSeconds, boolean invalidateOnChange, InMemoryFormat inMemoryFormat) {
        this(timeToLiveSeconds, maxSize, evictionPolicy, maxIdleSeconds, invalidateOnChange, inMemoryFormat, null);
    }

    public NearCacheConfig(int timeToLiveSeconds, int maxSize, String evictionPolicy, int maxIdleSeconds, boolean invalidateOnChange, InMemoryFormat inMemoryFormat, EvictionConfig evictionConfig) {
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.maxSize = maxSize;
        this.evictionPolicy = evictionPolicy;
        this.maxIdleSeconds = maxIdleSeconds;
        this.invalidateOnChange = invalidateOnChange;
        this.inMemoryFormat = inMemoryFormat;
        if (evictionConfig != null) {
            this.evictionConfig = evictionConfig;
        }
    }

    public NearCacheConfig(NearCacheConfig config) {
        this.name = config.getName();
        this.evictionPolicy = config.getEvictionPolicy();
        this.inMemoryFormat = config.getInMemoryFormat();
        this.invalidateOnChange = config.isInvalidateOnChange();
        this.maxIdleSeconds = config.getMaxIdleSeconds();
        this.maxSize = config.getMaxSize();
        this.timeToLiveSeconds = config.getTimeToLiveSeconds();
        this.cacheLocalEntries = config.isCacheLocalEntries();
        this.localUpdatePolicy = config.localUpdatePolicy;
        if (config.evictionConfig != null) {
            this.evictionConfig = config.evictionConfig;
        }
    }

    public NearCacheConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new NearCacheConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getName() {
        return this.name;
    }

    public NearCacheConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public NearCacheConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = Preconditions.checkNotNegative(timeToLiveSeconds, "TTL seconds cannot be negative !");
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public NearCacheConfig setMaxSize(int maxSize) {
        this.maxSize = Preconditions.checkNotNegative(maxSize, "Max-Size cannot be negative !");
        return this;
    }

    public String getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public NearCacheConfig setEvictionPolicy(String evictionPolicy) {
        this.evictionPolicy = Preconditions.checkNotNull(evictionPolicy, "Eviction policy cannot be null !");
        return this;
    }

    public int getMaxIdleSeconds() {
        return this.maxIdleSeconds;
    }

    public NearCacheConfig setMaxIdleSeconds(int maxIdleSeconds) {
        this.maxIdleSeconds = Preconditions.checkNotNegative(maxIdleSeconds, "Max-Idle seconds cannot be negative !");
        return this;
    }

    public boolean isInvalidateOnChange() {
        return this.invalidateOnChange;
    }

    public NearCacheConfig setInvalidateOnChange(boolean invalidateOnChange) {
        this.invalidateOnChange = invalidateOnChange;
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public NearCacheConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        this.inMemoryFormat = Preconditions.isNotNull(inMemoryFormat, "In-Memory format cannot be null !");
        return this;
    }

    public boolean isCacheLocalEntries() {
        return this.cacheLocalEntries;
    }

    public NearCacheConfig setCacheLocalEntries(boolean cacheLocalEntries) {
        this.cacheLocalEntries = cacheLocalEntries;
        return this;
    }

    public LocalUpdatePolicy getLocalUpdatePolicy() {
        return this.localUpdatePolicy;
    }

    public NearCacheConfig setLocalUpdatePolicy(LocalUpdatePolicy localUpdatePolicy) {
        this.localUpdatePolicy = Preconditions.checkNotNull(localUpdatePolicy, "Local update policy cannot be null !");
        return this;
    }

    public NearCacheConfig setInMemoryFormat(String inMemoryFormat) {
        Preconditions.checkNotNull(inMemoryFormat, "In-Memory format cannot be null !");
        this.inMemoryFormat = InMemoryFormat.valueOf(inMemoryFormat);
        return this;
    }

    public EvictionConfig getEvictionConfig() {
        return this.evictionConfig;
    }

    public NearCacheConfig setEvictionConfig(EvictionConfig evictionConfig) {
        this.evictionConfig = Preconditions.checkNotNull(evictionConfig, "Eviction config cannot be null !");
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.evictionPolicy);
        out.writeInt(this.timeToLiveSeconds);
        out.writeInt(this.maxSize);
        out.writeBoolean(this.invalidateOnChange);
        out.writeBoolean(this.cacheLocalEntries);
        out.writeInt(this.inMemoryFormat.ordinal());
        out.writeInt(this.localUpdatePolicy.ordinal());
        out.writeObject(this.evictionConfig);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.evictionPolicy = in.readUTF();
        this.timeToLiveSeconds = in.readInt();
        this.maxSize = in.readInt();
        this.invalidateOnChange = in.readBoolean();
        this.cacheLocalEntries = in.readBoolean();
        int inMemoryFormatInt = in.readInt();
        this.inMemoryFormat = InMemoryFormat.values()[inMemoryFormatInt];
        int localUpdatePolicyInt = in.readInt();
        this.localUpdatePolicy = LocalUpdatePolicy.values()[localUpdatePolicyInt];
        this.evictionConfig = (EvictionConfig)in.readObject();
    }

    public String toString() {
        return "NearCacheConfig{timeToLiveSeconds=" + this.timeToLiveSeconds + ", maxSize=" + this.maxSize + ", evictionPolicy='" + this.evictionPolicy + '\'' + ", maxIdleSeconds=" + this.maxIdleSeconds + ", invalidateOnChange=" + this.invalidateOnChange + ", inMemoryFormat=" + (Object)((Object)this.inMemoryFormat) + ", cacheLocalEntries=" + this.cacheLocalEntries + ", localUpdatePolicy=" + (Object)((Object)this.localUpdatePolicy) + ", evictionConfig=" + this.evictionConfig + '}';
    }

    public static enum LocalUpdatePolicy {
        INVALIDATE,
        CACHE;

    }
}

