/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class DiagnosticsLogWriter {
    protected final StringBuilder sb = new StringBuilder();
    protected int sectionLevel = -1;
    private final Calendar calendar = new GregorianCalendar(TimeZone.getDefault());
    private final Date date = new Date();

    public abstract void startSection(String var1);

    public abstract void endSection();

    public abstract void writeEntry(String var1);

    public abstract void writeKeyValueEntry(String var1, String var2);

    public abstract void writeKeyValueEntry(String var1, double var2);

    public abstract void writeKeyValueEntry(String var1, long var2);

    public abstract void writeKeyValueEntry(String var1, boolean var2);

    protected void clean() {
        this.sb.setLength(0);
    }

    public int length() {
        return this.sb.length();
    }

    public void copyInto(char[] target) {
        this.sb.getChars(0, this.sb.length(), target, 0);
    }

    protected void appendDateTime() {
        this.date.setTime(System.currentTimeMillis());
        this.calendar.setTime(this.date);
        this.appendDate();
        this.sb.append(' ');
        this.appendTime();
    }

    private void appendDate() {
        this.sb.append(this.calendar.get(5));
        this.sb.append('-');
        this.sb.append(this.calendar.get(2));
        this.sb.append('-');
        this.sb.append(this.calendar.get(1));
    }

    private void appendTime() {
        int hour = this.calendar.get(11);
        if (hour < 10) {
            this.sb.append('0');
        }
        this.sb.append(hour);
        this.sb.append(':');
        int minute = this.calendar.get(12);
        if (minute < 10) {
            this.sb.append('0');
        }
        this.sb.append(minute);
        this.sb.append(':');
        int second = this.calendar.get(13);
        if (second < 10) {
            this.sb.append('0');
        }
        this.sb.append(second);
    }
}

