/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.operation.BeforePromotionOperation;
import com.hazelcast.internal.partition.operation.FinalizePromotionOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;

public class PromotionCommitOperation
extends AbstractOperation
implements MigrationCycleOperation {
    private PartitionRuntimeState partitionState;
    private Collection<MigrationInfo> promotions;
    private String expectedMemberUuid;
    private transient boolean success;
    private transient boolean beforeStateCompleted;

    public PromotionCommitOperation() {
    }

    public PromotionCommitOperation(PartitionRuntimeState partitionState, Collection<MigrationInfo> promotions, String expectedMemberUuid) {
        Preconditions.checkNotNull(promotions);
        this.partitionState = partitionState;
        this.promotions = promotions;
        this.expectedMemberUuid = expectedMemberUuid;
    }

    @Override
    public void beforeRun() throws Exception {
        super.beforeRun();
        NodeEngine nodeEngine = this.getNodeEngine();
        Member localMember = nodeEngine.getLocalMember();
        if (!localMember.getUuid().equals(this.expectedMemberUuid)) {
            throw new IllegalStateException("This " + localMember + " is promotion commit destination but most probably it's restarted " + "and not the expected target.");
        }
    }

    @Override
    public void run() {
        if (this.beforeStateCompleted) {
            this.finalizePromotion();
        }
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        if (!this.beforeStateCompleted) {
            this.beforePromotion();
        }
    }

    private void beforePromotion() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        InternalOperationService operationService = nodeEngine.getOperationService();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        PartitionStateManager partitionStateManager = partitionService.getPartitionStateManager();
        AtomicInteger tasks = new AtomicInteger(this.promotions.size());
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Submitting before promotion tasks for " + this.promotions);
        } else if (logger.isFineEnabled()) {
            logger.fine("Submitting before promotion tasks for " + this.promotions.size() + " promotions.");
        }
        for (MigrationInfo promotion : this.promotions) {
            InternalPartitionImpl partition = partitionStateManager.getPartitionImpl(promotion.getPartitionId());
            partition.setMigrating(true);
            operationService.execute(new BeforePromotionTask(this, promotion, nodeEngine, tasks));
        }
    }

    private void finalizePromotion() {
        ILogger logger = this.getLogger();
        if (logger.isFineEnabled()) {
            logger.fine("Running promotion finalization for " + this.promotions.size() + " promotions.");
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        OperationService operationService = nodeEngine.getOperationService();
        this.partitionState.setEndpoint(this.getCallerAddress());
        this.success = partitionService.processPartitionRuntimeState(this.partitionState);
        if (logger.isFinestEnabled()) {
            logger.finest("Submitting finalize promotion operations for " + this.promotions);
        } else if (logger.isFineEnabled()) {
            logger.fine("Submitting finalize promotion operations for " + this.promotions.size() + " promotions.");
        }
        for (MigrationInfo promotion : this.promotions) {
            int currentReplicaIndex = promotion.getDestinationCurrentReplicaIndex();
            FinalizePromotionOperation op = new FinalizePromotionOperation(currentReplicaIndex, this.success);
            op.setPartitionId(promotion.getPartitionId()).setNodeEngine(nodeEngine).setService(partitionService);
            operationService.executeOperation(op);
        }
    }

    @Override
    public boolean returnsResponse() {
        return this.beforeStateCompleted;
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.expectedMemberUuid = in.readUTF();
        this.partitionState = new PartitionRuntimeState();
        this.partitionState.readData(in);
        int len = in.readInt();
        if (len > 0) {
            this.promotions = new ArrayList<MigrationInfo>(len);
            for (int i = 0; i < len; ++i) {
                MigrationInfo migrationInfo = new MigrationInfo();
                migrationInfo.readData(in);
                this.promotions.add(migrationInfo);
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.expectedMemberUuid);
        this.partitionState.writeData(out);
        int len = this.promotions.size();
        out.writeInt(len);
        for (MigrationInfo migrationInfo : this.promotions) {
            migrationInfo.writeData(out);
        }
    }

    private static class BeforePromotionTask
    implements PartitionSpecificRunnable {
        private final PromotionCommitOperation promotionCommitOperation;
        private final MigrationInfo promotion;
        private final NodeEngineImpl nodeEngine;
        private final AtomicInteger tasks;

        BeforePromotionTask(PromotionCommitOperation promotionCommitOperation, MigrationInfo promotion, NodeEngineImpl nodeEngine, AtomicInteger tasks) {
            this.promotionCommitOperation = promotionCommitOperation;
            this.promotion = promotion;
            this.nodeEngine = nodeEngine;
            this.tasks = tasks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int currentReplicaIndex = this.promotion.getDestinationCurrentReplicaIndex();
                BeforePromotionOperation op = new BeforePromotionOperation(currentReplicaIndex);
                op.setPartitionId(this.promotion.getPartitionId()).setNodeEngine(this.nodeEngine).setService(this.nodeEngine.getPartitionService());
                InternalOperationService operationService = this.nodeEngine.getOperationService();
                operationService.runOperationOnCallingThread(op);
            }
            finally {
                this.completeTask();
            }
        }

        private void completeTask() {
            int remainingTasks = this.tasks.decrementAndGet();
            ILogger logger = this.nodeEngine.getLogger(this.getClass());
            if (logger.isFinestEnabled()) {
                logger.finest("Remaining before promotion tasks: " + remainingTasks);
            }
            if (remainingTasks == 0) {
                logger.fine("All before promotion tasks are completed, re-submitting PromotionCommitOperation.");
                this.promotionCommitOperation.beforeStateCompleted = true;
                this.nodeEngine.getOperationService().executeOperation(this.promotionCommitOperation);
            }
        }

        @Override
        public int getPartitionId() {
            return this.promotion.getPartitionId();
        }
    }
}

