/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class MapSplitBrainHandlerService
implements SplitBrainHandlerService {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;

    MapSplitBrainHandlerService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public Runnable prepareMergeRunnable() {
        long now = this.getNow();
        Map<String, MapContainer> mapContainers = this.getMapContainers();
        HashMap<MapContainer, Collection<Record>> recordMap = new HashMap<MapContainer, Collection<Record>>(mapContainers.size());
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        Address thisAddress = this.nodeEngine.getClusterService().getThisAddress();
        for (MapContainer mapContainer : mapContainers.values()) {
            for (int i = 0; i < partitionCount; ++i) {
                RecordStore recordStore = this.mapServiceContext.getPartitionContainer(i).getRecordStore(mapContainer.getName());
                if (thisAddress.equals(partitionService.getPartitionOwner(i))) {
                    ArrayList<Record> records = (ArrayList<Record>)recordMap.get(mapContainer);
                    if (records == null) {
                        records = new ArrayList<Record>();
                        recordMap.put(mapContainer, records);
                    }
                    Iterator<Record> iterator = recordStore.iterator(now, false);
                    while (iterator.hasNext()) {
                        Record record = iterator.next();
                        records.add(record);
                    }
                }
                recordStore.reset();
            }
            Indexes indexes = mapContainer.getIndexes();
            indexes.clearIndexes();
        }
        return new Merger(recordMap);
    }

    protected Map<String, MapContainer> getMapContainers() {
        return this.mapServiceContext.getMapContainers();
    }

    private long getNow() {
        return Clock.currentTimeMillis();
    }

    private class Merger
    implements Runnable {
        private static final int TIMEOUT_FACTOR = 500;
        private Map<MapContainer, Collection<Record>> recordMap;

        Merger(Map<MapContainer, Collection<Record>> recordMap) {
            this.recordMap = recordMap;
        }

        @Override
        public void run() {
            final Semaphore semaphore = new Semaphore(0);
            int recordCount = 0;
            final ILogger logger = MapSplitBrainHandlerService.this.nodeEngine.getLogger(MapSplitBrainHandlerService.class);
            ExecutionCallback mergeCallback = new ExecutionCallback(){

                public void onResponse(Object response) {
                    semaphore.release(1);
                }

                @Override
                public void onFailure(Throwable t) {
                    logger.warning("Error while running merge operation: " + t.getMessage());
                    semaphore.release(1);
                }
            };
            for (Map.Entry<MapContainer, Collection<Record>> recordMapEntry : this.recordMap.entrySet()) {
                MapContainer mapContainer = recordMapEntry.getKey();
                Collection<Record> recordList = recordMapEntry.getValue();
                String mergePolicyName = mapContainer.getMapConfig().getMergePolicy();
                String mapName = mapContainer.getName();
                MapMergePolicy finalMergePolicy = MapSplitBrainHandlerService.this.mapServiceContext.getMergePolicyProvider().getMergePolicy(mergePolicyName);
                MapOperationProvider operationProvider = MapSplitBrainHandlerService.this.mapServiceContext.getMapOperationProvider(mapName);
                for (Record record : recordList) {
                    ++recordCount;
                    EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(record.getKey(), MapSplitBrainHandlerService.this.mapServiceContext.toData(record.getValue()), record);
                    MapOperation operation = operationProvider.createMergeOperation(mapName, record.getKey(), entryView, finalMergePolicy, false);
                    try {
                        int partitionId = MapSplitBrainHandlerService.this.nodeEngine.getPartitionService().getPartitionId(record.getKey());
                        InternalCompletableFuture f = MapSplitBrainHandlerService.this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
                        f.andThen(mergeCallback);
                    }
                    catch (Throwable t) {
                        throw ExceptionUtil.rethrow(t);
                    }
                }
            }
            try {
                semaphore.tryAcquire(recordCount, recordCount * 500, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.finest("Interrupted while waiting merge operation...");
            }
        }
    }
}

