/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aggregation.impl;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.query.impl.Extractable;
import com.hazelcast.query.impl.getters.MultiResult;
import java.util.List;
import java.util.Map;

public abstract class AbstractAggregator<I, E, R>
extends Aggregator<I, R> {
    protected String attributePath;

    public AbstractAggregator() {
        this(null);
    }

    public AbstractAggregator(String attributePath) {
        this.attributePath = attributePath;
    }

    @Override
    public final void accumulate(I entry) {
        Object extractedValue = this.extract(entry);
        if (extractedValue instanceof MultiResult) {
            List results = ((MultiResult)extractedValue).getResults();
            for (Object o : results) {
                this.accumulateExtracted(o);
            }
        } else {
            this.accumulateExtracted(extractedValue);
        }
    }

    private <T> T extract(I input) {
        if (this.attributePath == null) {
            if (input instanceof Map.Entry) {
                return (T)((Map.Entry)input).getValue();
            }
        } else if (input instanceof Extractable) {
            return (T)((Extractable)input).getAttributeValue(this.attributePath);
        }
        throw new IllegalArgumentException("Can't extract " + this.attributePath + " from the given input");
    }

    protected abstract void accumulateExtracted(E var1);
}

