/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws.utility;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class CloudyUtility {
    private static final String NODE_ITEM = "item";
    private static final String NODE_VALUE = "value";
    private static final String NODE_KEY = "key";
    private static final ILogger LOGGER = Logger.getLogger(CloudyUtility.class);

    private CloudyUtility() {
    }

    public static Map<String, String> unmarshalTheResponse(InputStream stream, AwsConfig awsConfig) throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(stream);
            Element element = doc.getDocumentElement();
            NodeHolder elementNodeHolder = new NodeHolder(element);
            LinkedHashMap<String, String> addresses = new LinkedHashMap<String, String>();
            List<NodeHolder> reservationSet = elementNodeHolder.getSubNodes("reservationset");
            for (NodeHolder reservation : reservationSet) {
                List<NodeHolder> items = reservation.getSubNodes(NODE_ITEM);
                for (NodeHolder item : items) {
                    NodeHolder instancesSet = item.getFirstSubNode("instancesset");
                    addresses.putAll(instancesSet.getAddresses(awsConfig));
                }
            }
            return addresses;
        }
        catch (Exception e) {
            LOGGER.warning(e);
            return new LinkedHashMap<String, String>();
        }
    }

    private static class NodeHolder {
        private final Node node;

        NodeHolder(Node node) {
            this.node = node;
        }

        Node getNode() {
            return this.node;
        }

        NodeHolder getFirstSubNode(String name) {
            if (this.node == null) {
                return new NodeHolder(null);
            }
            for (Node child : AbstractXmlConfigHelper.childElements(this.node)) {
                if (!name.equals(AbstractXmlConfigHelper.cleanNodeName(child))) continue;
                return new NodeHolder(child);
            }
            return new NodeHolder(null);
        }

        List<NodeHolder> getSubNodes(String name) {
            ArrayList<NodeHolder> result = new ArrayList<NodeHolder>();
            if (this.node == null) {
                return result;
            }
            for (Node child : AbstractXmlConfigHelper.childElements(this.node)) {
                if (!name.equals(AbstractXmlConfigHelper.cleanNodeName(child))) continue;
                result.add(new NodeHolder(child));
            }
            return result;
        }

        Map<String, String> getAddresses(AwsConfig awsConfig) {
            LinkedHashMap<String, String> privatePublicPairs = new LinkedHashMap<String, String>();
            if (this.node == null) {
                return privatePublicPairs;
            }
            for (NodeHolder childHolder : this.getSubNodes(CloudyUtility.NODE_ITEM)) {
                String state = NodeHolder.getState(childHolder);
                String privateIp = NodeHolder.getIp("privateipaddress", childHolder);
                String publicIp = NodeHolder.getIp("ipaddress", childHolder);
                String instanceName = NodeHolder.getInstanceName(childHolder);
                if (privateIp == null) continue;
                Node child = childHolder.getNode();
                if (!NodeHolder.acceptState(state)) {
                    LOGGER.finest(String.format("Ignoring EC2 instance [%s][%s] reason: the instance is not running but %s", instanceName, privateIp, state));
                    continue;
                }
                if (!NodeHolder.acceptTag(awsConfig, child)) {
                    LOGGER.finest(String.format("Ignoring EC2 instance [%s][%s] reason: tag-key/tag-value don't match", instanceName, privateIp));
                    continue;
                }
                if (!NodeHolder.acceptGroupName(awsConfig, child)) {
                    LOGGER.finest(String.format("Ignoring EC2 instance [%s][%s] reason: security-group-name doesn't match", instanceName, privateIp));
                    continue;
                }
                privatePublicPairs.put(privateIp, publicIp);
                LOGGER.finest(String.format("Accepting EC2 instance [%s][%s]", instanceName, privateIp));
            }
            return privatePublicPairs;
        }

        private static boolean acceptState(String state) {
            return "running".equals(state);
        }

        private static String getState(NodeHolder nodeHolder) {
            NodeHolder instanceState = nodeHolder.getFirstSubNode("instancestate");
            return instanceState.getFirstSubNode("name").getNode().getFirstChild().getNodeValue();
        }

        private static String getInstanceName(NodeHolder nodeHolder) {
            NodeHolder tagSetHolder = nodeHolder.getFirstSubNode("tagset");
            if (tagSetHolder.getNode() == null) {
                return null;
            }
            for (NodeHolder itemHolder : tagSetHolder.getSubNodes(CloudyUtility.NODE_ITEM)) {
                Node valueNode;
                String nodeValue;
                Node keyNode = itemHolder.getFirstSubNode(CloudyUtility.NODE_KEY).getNode();
                if (keyNode == null || keyNode.getFirstChild() == null || !"Name".equals(nodeValue = keyNode.getFirstChild().getNodeValue()) || (valueNode = itemHolder.getFirstSubNode(CloudyUtility.NODE_VALUE).getNode()) == null || valueNode.getFirstChild() == null) continue;
                return valueNode.getFirstChild().getNodeValue();
            }
            return null;
        }

        private static String getIp(String name, NodeHolder nodeHolder) {
            Node child = nodeHolder.getFirstSubNode(name).getNode();
            return child == null ? null : child.getFirstChild().getNodeValue();
        }

        private static boolean acceptTag(AwsConfig awsConfig, Node node) {
            return NodeHolder.applyTagFilter(node, awsConfig.getTagKey(), awsConfig.getTagValue());
        }

        private static boolean acceptGroupName(AwsConfig awsConfig, Node node) {
            return NodeHolder.applyFilter(node, awsConfig.getSecurityGroupName(), "groupset", "groupname");
        }

        private static boolean applyFilter(Node node, String filter, String set, String filterField) {
            if (NodeHolder.nullOrEmpty(filter)) {
                return true;
            }
            for (NodeHolder group : new NodeHolder(node).getFirstSubNode(set).getSubNodes(CloudyUtility.NODE_ITEM)) {
                NodeHolder nh = group.getFirstSubNode(filterField);
                if (nh == null || nh.getNode().getFirstChild() == null || !filter.equals(nh.getNode().getFirstChild().getNodeValue())) continue;
                return true;
            }
            return false;
        }

        private static boolean applyTagFilter(Node node, String keyExpected, String valueExpected) {
            if (NodeHolder.nullOrEmpty(keyExpected)) {
                return true;
            }
            for (NodeHolder group : new NodeHolder(node).getFirstSubNode("tagset").getSubNodes(CloudyUtility.NODE_ITEM)) {
                if (!NodeHolder.keyEquals(keyExpected, group) || !NodeHolder.nullOrEmpty(valueExpected) && !NodeHolder.valueEquals(valueExpected, group)) continue;
                return true;
            }
            return false;
        }

        private static boolean valueEquals(String valueExpected, NodeHolder group) {
            NodeHolder nhValue = group.getFirstSubNode(CloudyUtility.NODE_VALUE);
            return nhValue != null && nhValue.getNode().getFirstChild() != null && valueExpected.equals(nhValue.getNode().getFirstChild().getNodeValue());
        }

        private static boolean nullOrEmpty(String keyExpected) {
            return keyExpected == null || keyExpected.isEmpty();
        }

        private static boolean keyEquals(String keyExpected, NodeHolder group) {
            NodeHolder nhKey = group.getFirstSubNode(CloudyUtility.NODE_KEY);
            return nhKey != null && nhKey.getNode().getFirstChild() != null && keyExpected.equals(nhKey.getNode().getFirstChild().getNodeValue());
        }
    }
}

