/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class AggregationResult
implements Result<AggregationResult>,
IdentifiedDataSerializable {
    private Aggregator aggregator;
    private Collection<Integer> partitionIds;

    public AggregationResult() {
    }

    public AggregationResult(Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    public <R> Aggregator<?, R> getAggregator() {
        return this.aggregator;
    }

    @Override
    public Collection<Integer> getPartitionIds() {
        return this.partitionIds;
    }

    @Override
    public void combine(AggregationResult result) {
        Collection<Integer> otherPartitionIds = result.getPartitionIds();
        if (otherPartitionIds == null) {
            return;
        }
        if (this.partitionIds == null) {
            this.partitionIds = new ArrayList<Integer>(otherPartitionIds.size());
        }
        this.partitionIds.addAll(otherPartitionIds);
        this.aggregator.combine(result.aggregator);
    }

    @Override
    public void onCombineFinished() {
        if (this.aggregator != null) {
            this.aggregator.onCombinationFinished();
        }
    }

    @Override
    public void setPartitionIds(Collection<Integer> partitionIds) {
        this.partitionIds = new ArrayList<Integer>(partitionIds);
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 115;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        int partitionSize = this.partitionIds == null ? 0 : this.partitionIds.size();
        out.writeInt(partitionSize);
        if (partitionSize > 0) {
            for (Integer partitionId : this.partitionIds) {
                out.writeInt(partitionId);
            }
        }
        out.writeObject(this.aggregator);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int partitionSize = in.readInt();
        if (partitionSize > 0) {
            this.partitionIds = new ArrayList<Integer>(partitionSize);
            for (int i = 0; i < partitionSize; ++i) {
                this.partitionIds.add(in.readInt());
            }
        }
        this.aggregator = (Aggregator)in.readObject();
    }
}

