/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorHandler;
import com.hazelcast.map.impl.querycache.event.QueryCacheEventData;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.nio.serialization.Data;

class SubscriberAccumulatorHandler
implements AccumulatorHandler<QueryCacheEventData> {
    private final InternalQueryCache queryCache;
    private final boolean includeValue;
    private final InternalSerializationService serializationService;

    public SubscriberAccumulatorHandler(boolean includeValue, InternalQueryCache queryCache, InternalSerializationService serializationService) {
        this.includeValue = includeValue;
        this.queryCache = queryCache;
        this.serializationService = serializationService;
    }

    @Override
    public void handle(QueryCacheEventData eventData, boolean ignored) {
        eventData.setSerializationService(this.serializationService);
        Data keyData = eventData.getDataKey();
        Data valueData = this.includeValue ? eventData.getDataNewValue() : null;
        int eventType = eventData.getEventType();
        EntryEventType entryEventType = EntryEventType.getByType(eventType);
        switch (entryEventType) {
            case ADDED: 
            case UPDATED: 
            case MERGED: {
                this.queryCache.setInternal(keyData, valueData, false, entryEventType);
                break;
            }
            case REMOVED: 
            case EVICTED: {
                this.queryCache.deleteInternal(keyData, false, entryEventType);
                break;
            }
            case CLEAR_ALL: 
            case EVICT_ALL: {
                this.queryCache.clearInternal(entryEventType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a known type EntryEventType." + (Object)((Object)entryEventType));
            }
        }
    }
}

