/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.FalsePredicate;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.predicates.AbstractVisitor;
import com.hazelcast.query.impl.predicates.AndPredicate;
import com.hazelcast.query.impl.predicates.BetweenPredicate;
import com.hazelcast.query.impl.predicates.EqualPredicate;
import com.hazelcast.query.impl.predicates.GreaterLessPredicate;
import com.hazelcast.util.collection.ArrayUtils;
import com.hazelcast.util.collection.InternalListMultiMap;
import java.util.List;
import java.util.Map;

public class BetweenVisitor
extends AbstractVisitor {
    @Override
    public Predicate visit(AndPredicate andPredicate, Indexes indexes) {
        Predicate[] originalPredicates = andPredicate.predicates;
        InternalListMultiMap<String, GreaterLessPredicate> candidates = this.findCandidatesAndGroupByAttribute(originalPredicates, indexes);
        if (candidates == null) {
            return andPredicate;
        }
        int toBeRemovedCounter = 0;
        boolean modified = false;
        Predicate[] target = originalPredicates;
        for (Map.Entry<String, List<GreaterLessPredicate>> entry : candidates.entrySet()) {
            String attributeName;
            Boundaries boundaries;
            List<GreaterLessPredicate> predicates = entry.getValue();
            if (predicates.size() == 1 || (boundaries = this.findBoundaryOrNull(attributeName = entry.getKey(), predicates, indexes)) == null) continue;
            if (boundaries.isOverlapping()) {
                return FalsePredicate.INSTANCE;
            }
            if (!modified) {
                modified = true;
                target = ArrayUtils.createCopy(target);
            }
            toBeRemovedCounter = this.rewriteAttribute(boundaries, target, toBeRemovedCounter);
        }
        Predicate[] newPredicates = this.removeEliminatedPredicates(target, toBeRemovedCounter);
        if (newPredicates == originalPredicates) {
            return andPredicate;
        }
        if (newPredicates.length == 1) {
            return newPredicates[0];
        }
        return new AndPredicate(newPredicates);
    }

    private Boundaries findBoundaryOrNull(String attributeName, List<GreaterLessPredicate> predicates, Indexes indexes) {
        GreaterLessPredicate mostRightGreaterOrEquals = null;
        GreaterLessPredicate mostLeftLessThanOrEquals = null;
        Index index = indexes.getIndex(attributeName);
        TypeConverter converter = index.getConverter();
        for (GreaterLessPredicate predicate : predicates) {
            if (predicate.less) {
                if (mostLeftLessThanOrEquals != null && !this.isLessThan(mostLeftLessThanOrEquals, predicate, converter)) continue;
                mostLeftLessThanOrEquals = predicate;
                continue;
            }
            if (mostRightGreaterOrEquals != null && !this.isGreaterThan(mostRightGreaterOrEquals, predicate, converter)) continue;
            mostRightGreaterOrEquals = predicate;
        }
        if (mostRightGreaterOrEquals == null || mostLeftLessThanOrEquals == null) {
            return null;
        }
        return new Boundaries(mostRightGreaterOrEquals, mostLeftLessThanOrEquals, converter);
    }

    private Predicate[] removeEliminatedPredicates(Predicate[] originalPredicates, int toBeRemoved) {
        if (toBeRemoved == 0) {
            return originalPredicates;
        }
        int newSize = originalPredicates.length - toBeRemoved;
        Predicate[] newPredicates = new Predicate[newSize];
        ArrayUtils.copyWithoutNulls(originalPredicates, newPredicates);
        return newPredicates;
    }

    private int rewriteAttribute(Boundaries boundaries, Predicate[] originalPredicates, int toBeRemovedCount) {
        GreaterLessPredicate leftBoundary = boundaries.leftBoundary;
        GreaterLessPredicate rightBoundary = boundaries.rightBoundary;
        Predicate rewritten = boundaries.createEquivalentPredicate();
        for (int i = 0; i < originalPredicates.length; ++i) {
            Predicate currentPredicate = originalPredicates[i];
            if (currentPredicate == leftBoundary) {
                originalPredicates[i] = rewritten;
                continue;
            }
            if (currentPredicate == rightBoundary) {
                originalPredicates[i] = null;
                ++toBeRemovedCount;
                continue;
            }
            if (!boundaries.canBeEliminated(currentPredicate)) continue;
            originalPredicates[i] = null;
            ++toBeRemovedCount;
        }
        return toBeRemovedCount;
    }

    private InternalListMultiMap<String, GreaterLessPredicate> findCandidatesAndGroupByAttribute(Predicate[] predicates, Indexes indexService) {
        InternalListMultiMap<String, GreaterLessPredicate> candidates = null;
        for (Predicate predicate : predicates) {
            String attributeName;
            Index index;
            if (!(predicate instanceof GreaterLessPredicate)) continue;
            GreaterLessPredicate greaterLessPredicate = (GreaterLessPredicate)predicate;
            if (!greaterLessPredicate.equal || (index = indexService.getIndex(attributeName = greaterLessPredicate.attributeName)) == null || index.getConverter() == null) continue;
            candidates = this.addIntoCandidates(greaterLessPredicate, candidates);
        }
        return candidates;
    }

    private InternalListMultiMap<String, GreaterLessPredicate> addIntoCandidates(GreaterLessPredicate predicate, InternalListMultiMap<String, GreaterLessPredicate> currentCandidates) {
        if (currentCandidates == null) {
            currentCandidates = new InternalListMultiMap();
        }
        String attributeName = predicate.attributeName;
        currentCandidates.put(attributeName, predicate);
        return currentCandidates;
    }

    private boolean isGreaterThan(GreaterLessPredicate leftPredicate, GreaterLessPredicate rightPredicate, TypeConverter converter) {
        Comparable leftValue;
        Comparable rightValue = converter.convert(rightPredicate.value);
        return rightValue.compareTo(leftValue = converter.convert(leftPredicate.value)) > 0;
    }

    private boolean isLessThan(GreaterLessPredicate leftPredicate, GreaterLessPredicate rightPredicate, TypeConverter converter) {
        Comparable leftValue;
        Comparable rightValue = converter.convert(rightPredicate.value);
        return rightValue.compareTo(leftValue = converter.convert(leftPredicate.value)) < 0;
    }

    private class Boundaries {
        private final GreaterLessPredicate leftBoundary;
        private final GreaterLessPredicate rightBoundary;
        private final TypeConverter typeConverter;

        Boundaries(GreaterLessPredicate leftBoundary, GreaterLessPredicate rightBoundary, TypeConverter converter) {
            this.leftBoundary = leftBoundary;
            this.rightBoundary = rightBoundary;
            this.typeConverter = converter;
        }

        boolean isOverlapping() {
            return BetweenVisitor.this.isGreaterThan(this.rightBoundary, this.leftBoundary, this.typeConverter);
        }

        Predicate createEquivalentPredicate() {
            String attributeName = this.leftBoundary.attributeName;
            if (this.isSame()) {
                return new EqualPredicate(attributeName, this.leftBoundary.value);
            }
            return new BetweenPredicate(attributeName, this.leftBoundary.value, this.rightBoundary.value);
        }

        boolean isSame() {
            return this.leftBoundary.value == this.rightBoundary.value;
        }

        private boolean canBeEliminated(Predicate predicate) {
            if (!(predicate instanceof GreaterLessPredicate)) {
                return false;
            }
            GreaterLessPredicate greaterLessPredicate = (GreaterLessPredicate)predicate;
            if (!greaterLessPredicate.attributeName.equals(this.leftBoundary.attributeName)) {
                return false;
            }
            if (greaterLessPredicate.less) {
                return BetweenVisitor.this.isGreaterThan(this.rightBoundary, greaterLessPredicate, this.typeConverter);
            }
            return BetweenVisitor.this.isLessThan(this.leftBoundary, greaterLessPredicate, this.typeConverter);
        }
    }
}

