/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.numeric.mutable;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.compare.CompareHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.numeric.mutable.AbstractMutableInteger;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;

@NotThreadSafe
public class MutableChar
extends AbstractMutableInteger<MutableChar> {
    private char m_cValue;

    public MutableChar(int n) {
        this((char)n);
    }

    public MutableChar(@Nonnull Character c) {
        this(c.charValue());
    }

    public MutableChar(char c) {
        this.m_cValue = c;
    }

    public MutableChar(@Nonnull MutableChar mutableChar) {
        this(mutableChar.m_cValue);
    }

    public char charValue() {
        return this.m_cValue;
    }

    @Override
    public float floatValue() {
        return this.m_cValue;
    }

    @Override
    public double doubleValue() {
        return this.m_cValue;
    }

    @Override
    public int intValue() {
        return this.m_cValue;
    }

    @Override
    public long longValue() {
        return this.m_cValue;
    }

    public int inc() {
        return this.inc(1);
    }

    public int inc(int n) {
        this.m_cValue = (char)(this.m_cValue + n);
        this.onAfterChange();
        return this.m_cValue;
    }

    public int inc(@Nonnull MutableChar mutableChar) {
        ValueEnforcer.notNull(mutableChar, "MC");
        return this.inc(mutableChar.m_cValue);
    }

    public int dec() {
        return this.inc(-1);
    }

    public int dec(int n) {
        return this.inc(-n);
    }

    public int dec(@Nonnull MutableChar mutableChar) {
        ValueEnforcer.notNull(mutableChar, "MC");
        return this.inc(-mutableChar.m_cValue);
    }

    @Nonnull
    public EChange set(int n) {
        return this.set((char)n);
    }

    @Nonnull
    public EChange set(@Nonnull MutableChar mutableChar) {
        ValueEnforcer.notNull(mutableChar, "MC");
        return this.set(mutableChar.m_cValue);
    }

    @Nonnull
    public EChange set(char c) {
        if (this.m_cValue == c) {
            return EChange.UNCHANGED;
        }
        this.m_cValue = c;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    @Override
    public boolean is0() {
        return this.m_cValue == '\u0000';
    }

    @Override
    public boolean isLT0() {
        return false;
    }

    @Override
    public boolean isLE0() {
        return this.m_cValue <= '\u0000';
    }

    @Override
    public boolean isGT0() {
        return this.m_cValue > '\u0000';
    }

    @Override
    public boolean isGE0() {
        return true;
    }

    @Override
    public boolean isEven() {
        return this.m_cValue % 2 == 0;
    }

    public char getAndInc() {
        char c = this.charValue();
        this.inc();
        return c;
    }

    public char incAndGet() {
        this.inc();
        return this.charValue();
    }

    @Override
    public int compareTo(@Nonnull MutableChar mutableChar) {
        return CompareHelper.compare(this.m_cValue, mutableChar.m_cValue);
    }

    @Override
    @Nonnull
    public MutableChar getClone() {
        return new MutableChar(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableChar mutableChar = (MutableChar)object;
        return this.m_cValue == mutableChar.m_cValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_cValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_cValue).getToString();
    }
}

