/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.url;

import com.helger.annotation.RegEx;
import com.helger.base.string.StringHelper;
import jakarta.annotation.Nullable;
import java.util.regex.Pattern;

public final class URNHelper {
    @RegEx
    public static final String REGEX_URN = "^\\Qurn:\\E[a-zA-Z0-9][a-zA-Z0-9-]{0,31}\\Q:\\E[a-zA-Z0-9()+,\\-.:=@;$_!*'%/?#]+$";
    private static final Pattern PATTERN_URN = Pattern.compile("^\\Qurn:\\E[a-zA-Z0-9][a-zA-Z0-9-]{0,31}\\Q:\\E[a-zA-Z0-9()+,\\-.:=@;$_!*'%/?#]+$");

    private URNHelper() {
    }

    public static boolean isValidURN(@Nullable String string) {
        if (StringHelper.isEmpty(string)) {
            return false;
        }
        return PATTERN_URN.matcher(string).matches();
    }
}

