/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.file;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.callback.ICallback;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.file.EFileIOOperation;
import com.helger.io.file.FileIOError;
import com.helger.io.file.FileOperations;
import com.helger.io.file.IFileOperationCallback;
import com.helger.io.file.IFileOperationManager;
import com.helger.io.file.LoggingFileOperationCallback;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;

@NotThreadSafe
public class FileOperationManager
implements IFileOperationManager {
    public static final IFileOperationManager INSTANCE;
    private FileIOError m_aLastError;
    private final CallbackList<IFileOperationCallback> m_aCallbacks = new CallbackList();

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IFileOperationCallback> callbacks() {
        return this.m_aCallbacks;
    }

    @Override
    @Nullable
    public FileIOError getLastError() {
        return this.m_aLastError;
    }

    @Override
    @Nullable
    public EFileIOOperation getLastOperation() {
        return this.m_aLastError == null ? null : this.m_aLastError.getOperation();
    }

    private void _handleLastError(@Nonnull FileIOError fileIOError) {
        if (this.m_aCallbacks.isNotEmpty()) {
            if (fileIOError.isSuccess()) {
                this.m_aCallbacks.forEach(iFileOperationCallback -> iFileOperationCallback.onSuccess(fileIOError.getOperation(), fileIOError.getFile1(), fileIOError.getFile2()));
            } else {
                this.m_aCallbacks.forEach(iFileOperationCallback -> iFileOperationCallback.onError(fileIOError.getOperation(), fileIOError.getErrorCode(), fileIOError.getFile1(), fileIOError.getFile2(), fileIOError.getException()));
            }
        }
    }

    @Override
    @Nonnull
    public FileIOError createDir(@Nonnull File file) {
        this.m_aLastError = FileOperations.createDir(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError createDirIfNotExisting(@Nonnull File file) {
        this.m_aLastError = FileOperations.createDirIfNotExisting(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError createDirRecursive(@Nonnull File file) {
        this.m_aLastError = FileOperations.createDirRecursive(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError createDirRecursiveIfNotExisting(@Nonnull File file) {
        this.m_aLastError = FileOperations.createDirRecursiveIfNotExisting(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteDir(@Nonnull File file) {
        this.m_aLastError = FileOperations.deleteDir(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteDirIfExisting(@Nonnull File file) {
        this.m_aLastError = FileOperations.deleteDirIfExisting(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteDirRecursive(@Nonnull File file) {
        this.m_aLastError = FileOperations.deleteDirRecursive(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteDirRecursiveIfExisting(@Nonnull File file) {
        this.m_aLastError = FileOperations.deleteDirRecursiveIfExisting(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteFile(@Nonnull File file) {
        this.m_aLastError = FileOperations.deleteFile(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError deleteFileIfExisting(@Nonnull File file) {
        this.m_aLastError = FileOperations.deleteFileIfExisting(file);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError renameDir(@Nonnull File file, @Nonnull File file2) {
        this.m_aLastError = FileOperations.renameDir(file, file2);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError renameFile(@Nonnull File file, @Nonnull File file2) {
        this.m_aLastError = FileOperations.renameFile(file, file2);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError copyDirRecursive(@Nonnull File file, @Nonnull File file2) {
        this.m_aLastError = FileOperations.copyDirRecursive(file, file2);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    @Override
    @Nonnull
    public FileIOError copyFile(@Nonnull File file, @Nonnull File file2) {
        this.m_aLastError = FileOperations.copyFile(file, file2);
        this._handleLastError(this.m_aLastError);
        return this.m_aLastError;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("LastError", (Object)this.m_aLastError).append("Callback", this.m_aCallbacks).getToString();
    }

    static {
        FileOperationManager fileOperationManager = new FileOperationManager();
        fileOperationManager.callbacks().add((ICallback)new LoggingFileOperationCallback());
        INSTANCE = fileOperationManager;
    }
}

