/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resource.inmemory;

import com.helger.base.string.StringHelper;
import com.helger.io.resource.inmemory.ReadableResourceByteArray;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ReadableResourceString
extends ReadableResourceByteArray {
    public ReadableResourceString(@Nonnull String string, @Nonnull Charset charset) {
        this(null, string, charset);
    }

    public ReadableResourceString(@Nullable String string, @Nonnull String string2, @Nonnull Charset charset) {
        super((String)(StringHelper.isNotEmpty((String)string) ? string : "string-" + string2.length() + "-" + string2.hashCode()), string2.getBytes(charset), false);
    }

    @Nonnull
    public static ReadableResourceString utf8(@Nonnull String string) {
        return new ReadableResourceString(string, StandardCharsets.UTF_8);
    }

    @Nonnull
    public static ReadableResourceString utf8(@Nullable String string, @Nonnull String string2) {
        return new ReadableResourceString(string, string2, StandardCharsets.UTF_8);
    }
}

