/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.state.EContinue;
import com.helger.scope.AbstractScope;
import com.helger.scope.ISessionScope;
import com.helger.scope.ScopeHelper;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SessionScope
extends AbstractScope
implements ISessionScope {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionScope.class);

    public SessionScope(@Nonnull @Nonempty String string) {
        super(string);
        if (ScopeHelper.isDebugSessionScopeLifeCycle()) {
            LOGGER.info("Created session scope '" + string + "'", (Throwable)ScopeHelper.getDebugException());
        }
    }

    @Override
    public void initScope() {
    }

    @Override
    protected void preDestroy() {
        if (ScopeHelper.isDebugSessionScopeLifeCycle()) {
            LOGGER.info("Destroying session scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName((Object)this), (Throwable)ScopeHelper.getDebugException());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeHelper.isDebugSessionScopeLifeCycle()) {
            LOGGER.info("Destroyed session scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName((Object)this), (Throwable)ScopeHelper.getDebugException());
        }
    }

    @Override
    @Nonnull
    public EContinue selfDestruct() {
        return EContinue.CONTINUE;
    }
}

