/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonnegative;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.xml.microdom.IMicroDataAware;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

final class MicroDataAware
implements IMicroDataAware,
ICloneable<MicroDataAware> {
    private final StringBuilder m_aSB;

    public MicroDataAware(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen((char[])cArray, (int)n, (int)n2);
        this.m_aSB = new StringBuilder(n2 + 16).append(cArray, n, n2);
    }

    public MicroDataAware(@Nullable CharSequence charSequence) {
        this.m_aSB = StringHelper.isEmpty((CharSequence)charSequence) ? new StringBuilder() : new StringBuilder(charSequence);
    }

    @Override
    @Nonnull
    public StringBuilder getData() {
        return this.m_aSB;
    }

    @Override
    public void setData(@Nullable CharSequence charSequence) {
        this.m_aSB.setLength(0);
        this.m_aSB.append(charSequence);
    }

    @Override
    public void appendData(@Nullable CharSequence charSequence) {
        this.m_aSB.append(charSequence);
    }

    @Override
    public void appendData(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aSB.append(cArray, n, n2);
    }

    @Override
    public void appendData(char c) {
        this.m_aSB.append(c);
    }

    @Override
    public void prependData(@Nullable CharSequence charSequence) {
        this.m_aSB.insert(0, charSequence);
    }

    @Override
    public void prependData(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aSB.insert(0, cArray, n, n2);
    }

    @Override
    public void prependData(char c) {
        this.m_aSB.insert(0, c);
    }

    @Nonnull
    public MicroDataAware getClone() {
        return new MicroDataAware(this.m_aSB);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MicroDataAware microDataAware = (MicroDataAware)object;
        return this.m_aSB.toString().equals(microDataAware.m_aSB.toString());
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aSB.toString()).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Data", (Object)this.m_aSB).getToString();
    }
}

