/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.currency;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsEnumMap;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsTreeSet;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSortedSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.locale.LocaleParser;
import com.helger.commons.string.StringHelper;
import com.helger.masterdata.currency.ECurrency;
import com.helger.masterdata.currency.EDecimalSeparator;
import com.helger.masterdata.currency.EGroupingSeparator;
import com.helger.masterdata.currency.PerCurrencySettings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Currency;
import java.util.Locale;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;

@Immutable
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class CurrencyHelper {
    public static final RoundingMode DEFAULT_ROUNDING_MODE = RoundingMode.HALF_EVEN;
    public static final ECurrency DEFAULT_CURRENCY = ECurrency.EUR;
    public static final int DEFAULT_SCALE = 2;
    private static final ICommonsSortedSet<Currency> ALL_CURRENCIES = new CommonsTreeSet(Comparator.comparing(Currency::getCurrencyCode));
    private static final ICommonsMap<Locale, Currency> LOCALE_TO_CURRENCY = new CommonsHashMap();
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<ECurrency, PerCurrencySettings> SETTINGS_MAP = new CommonsEnumMap(ECurrency.class);

    public static void reinitializeCurrencySettings() {
        RW_LOCK.writeLocked(() -> {
            SETTINGS_MAP.clear();
            for (ECurrency eCurrency : ECurrency.values()) {
                SETTINGS_MAP.put((Object)eCurrency, (Object)new PerCurrencySettings(eCurrency));
                for (Locale locale : eCurrency.matchingLocales()) {
                    if (CurrencyHelper.localeSupportsCurrencyRetrieval(locale)) continue;
                    throw new IllegalArgumentException("Passed locale " + locale + " does not support currency retrieval!");
                }
            }
        });
    }

    private CurrencyHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSortedSet<Currency> getAllSupportedCurrencies() {
        return ALL_CURRENCIES.getClone();
    }

    public static boolean isSupportedCurrency(@Nullable Currency currency) {
        return currency != null && ALL_CURRENCIES.contains((Object)currency);
    }

    public static boolean isSupportedCurrency(@Nullable ECurrency eCurrency) {
        return eCurrency != null && CurrencyHelper.isSupportedCurrency(eCurrency.getAsCurrency());
    }

    public static boolean isSupportedCurrencyCode(@Nonnull String string) {
        try {
            return CurrencyHelper.isSupportedCurrency(Currency.getInstance(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean localeSupportsCurrencyRetrieval(@Nullable Locale locale) {
        return locale != null && locale.getCountry() != null && locale.getCountry().length() == 2;
    }

    @Nullable
    public static Currency getCurrencyOfLocale(@Nonnull Locale locale) {
        if (!CurrencyHelper.localeSupportsCurrencyRetrieval(locale)) {
            throw new IllegalArgumentException("Cannot get currency of locale " + locale);
        }
        return (Currency)LOCALE_TO_CURRENCY.get((Object)locale);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<Locale, Currency> getLocaleToCurrencyMap() {
        return (ICommonsMap)LOCALE_TO_CURRENCY.getClone();
    }

    @Nullable
    public static BigDecimal parseCurrency(@Nullable String string, @Nonnull DecimalFormat decimalFormat, @Nullable BigDecimal bigDecimal) {
        return CurrencyHelper.parseCurrency(string, decimalFormat, bigDecimal, DEFAULT_ROUNDING_MODE);
    }

    @Nullable
    public static BigDecimal parseCurrency(@Nullable String string, @Nonnull DecimalFormat decimalFormat, @Nullable BigDecimal bigDecimal, @Nonnull RoundingMode roundingMode) {
        if (StringHelper.hasNoText((String)string)) {
            return bigDecimal;
        }
        decimalFormat.setParseBigDecimal(true);
        decimalFormat.setRoundingMode(roundingMode);
        BigDecimal bigDecimal2 = LocaleParser.parseBigDecimal((String)string, (DecimalFormat)decimalFormat);
        if (bigDecimal2 == null) {
            return bigDecimal;
        }
        return bigDecimal2.setScale(decimalFormat.getMaximumFractionDigits(), roundingMode);
    }

    @Nonnull
    public static PerCurrencySettings getSettings(@Nullable ECurrency eCurrency) {
        RW_LOCK.readLock().lock();
        try {
            PerCurrencySettings perCurrencySettings = (PerCurrencySettings)SETTINGS_MAP.get((Object)(eCurrency != null ? eCurrency : DEFAULT_CURRENCY));
            return perCurrencySettings;
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    @Nonnull
    public static String getCurrencySymbol(@Nullable ECurrency eCurrency) {
        return CurrencyHelper.getSettings(eCurrency).getCurrencySymbol();
    }

    @Nonnull
    @Nonempty
    public static String getCurrencyPattern(@Nullable ECurrency eCurrency) {
        return CurrencyHelper.getSettings(eCurrency).getCurrencyPattern();
    }

    @Nonnull
    @Nonempty
    public static String getValuePattern(@Nullable ECurrency eCurrency) {
        return CurrencyHelper.getSettings(eCurrency).getValuePattern();
    }

    @Nonnull
    public static DecimalFormat getCurrencyFormat(@Nullable ECurrency eCurrency) {
        return CurrencyHelper.getSettings(eCurrency).getCurrencyFormat();
    }

    @Nonnull
    public static String getCurrencyFormatted(@Nullable ECurrency eCurrency, @Nonnull BigDecimal bigDecimal) {
        return CurrencyHelper.getSettings(eCurrency).getCurrencyFormatted(bigDecimal);
    }

    @Nonnull
    public static String getCurrencyFormatted(@Nullable ECurrency eCurrency, @Nonnull BigDecimal bigDecimal, @Nonnegative int n) {
        return CurrencyHelper.getSettings(eCurrency).getCurrencyFormatted(bigDecimal, n);
    }

    @Nonnull
    public static DecimalFormat getValueFormat(@Nullable ECurrency eCurrency) {
        return CurrencyHelper.getSettings(eCurrency).getValueFormat();
    }

    @Nonnull
    public static String getValueFormatted(@Nullable ECurrency eCurrency, @Nonnull BigDecimal bigDecimal) {
        return CurrencyHelper.getSettings(eCurrency).getValueFormatted(bigDecimal);
    }

    @Nonnull
    public static String getValueFormatted(@Nullable ECurrency eCurrency, @Nonnull BigDecimal bigDecimal, @Nonnegative int n) {
        return CurrencyHelper.getSettings(eCurrency).getValueFormatted(bigDecimal, n);
    }

    @Nonnegative
    public static int getMinimumFractionDigits(@Nullable ECurrency eCurrency) {
        return CurrencyHelper.getCurrencyFormat(eCurrency).getMinimumFractionDigits();
    }

    public static void setMinimumFractionDigits(@Nullable ECurrency eCurrency, @Nonnegative int n) {
        CurrencyHelper.getSettings(eCurrency).setMinimumFractionDigits(n);
    }

    @Nullable
    public static EDecimalSeparator getDecimalSeparator(@Nullable ECurrency eCurrency) {
        return CurrencyHelper.getSettings(eCurrency).getDecimalSeparator();
    }

    @Nullable
    public static EGroupingSeparator getGroupingSeparator(@Nullable ECurrency eCurrency) {
        return CurrencyHelper.getSettings(eCurrency).getGroupingSeparator();
    }

    @Nullable
    private static String _getTextValueForDecimalSeparator(@Nullable String string, @Nonnull EDecimalSeparator eDecimalSeparator, @Nonnull EGroupingSeparator eGroupingSeparator) {
        ValueEnforcer.notNull((Object)((Object)eDecimalSeparator), (String)"DecimalSeparator");
        ValueEnforcer.notNull((Object)((Object)eGroupingSeparator), (String)"GroupingSeparator");
        String string2 = StringHelper.trim((String)string);
        if (string2 != null && string2.indexOf(eDecimalSeparator.getChar()) < 0) {
            switch (eDecimalSeparator) {
                case COMMA: {
                    if (string2.indexOf(46) <= -1 || eGroupingSeparator.getChar() == '.') break;
                    return StringHelper.replaceAll((String)string2, (char)'.', (char)eDecimalSeparator.getChar());
                }
                case POINT: {
                    if (string2.indexOf(44) <= -1 || eGroupingSeparator.getChar() == ',') break;
                    return StringHelper.replaceAll((String)string2, (char)',', (char)eDecimalSeparator.getChar());
                }
                default: {
                    throw new IllegalStateException("Unexpected decimal separator [" + eDecimalSeparator + "]");
                }
            }
        }
        return string2;
    }

    @Nullable
    public static BigDecimal parseCurrencyFormat(@Nullable ECurrency eCurrency, @Nullable String string, @Nullable BigDecimal bigDecimal) {
        PerCurrencySettings perCurrencySettings = CurrencyHelper.getSettings(eCurrency);
        DecimalFormat decimalFormat = perCurrencySettings.getCurrencyFormat();
        String string2 = perCurrencySettings.getDecimalSeparator() != null && perCurrencySettings.getGroupingSeparator() != null ? CurrencyHelper._getTextValueForDecimalSeparator(string, perCurrencySettings.getDecimalSeparator(), perCurrencySettings.getGroupingSeparator()) : string;
        return CurrencyHelper.parseCurrency(string2, decimalFormat, bigDecimal, perCurrencySettings.getRoundingMode());
    }

    @Nullable
    public static BigDecimal parseCurrencyFormatUnchanged(@Nullable ECurrency eCurrency, @Nullable String string, @Nullable BigDecimal bigDecimal) {
        PerCurrencySettings perCurrencySettings = CurrencyHelper.getSettings(eCurrency);
        DecimalFormat decimalFormat = perCurrencySettings.getCurrencyFormat();
        return CurrencyHelper.parseCurrency(string, decimalFormat, bigDecimal, perCurrencySettings.getRoundingMode());
    }

    @Nullable
    public static BigDecimal parseValueFormat(@Nullable ECurrency eCurrency, @Nullable String string, @Nullable BigDecimal bigDecimal) {
        PerCurrencySettings perCurrencySettings = CurrencyHelper.getSettings(eCurrency);
        DecimalFormat decimalFormat = perCurrencySettings.getValueFormat();
        String string2 = perCurrencySettings.getDecimalSeparator() != null && perCurrencySettings.getGroupingSeparator() != null ? CurrencyHelper._getTextValueForDecimalSeparator(string, perCurrencySettings.getDecimalSeparator(), perCurrencySettings.getGroupingSeparator()) : string;
        return CurrencyHelper.parseCurrency(string2, decimalFormat, bigDecimal, perCurrencySettings.getRoundingMode());
    }

    @Nullable
    public static BigDecimal parseValueFormatUnchanged(@Nullable ECurrency eCurrency, @Nullable String string, @Nullable BigDecimal bigDecimal) {
        PerCurrencySettings perCurrencySettings = CurrencyHelper.getSettings(eCurrency);
        DecimalFormat decimalFormat = perCurrencySettings.getValueFormat();
        return CurrencyHelper.parseCurrency(string, decimalFormat, bigDecimal, perCurrencySettings.getRoundingMode());
    }

    @Nonnegative
    public static int getScale(@Nullable ECurrency eCurrency) {
        return CurrencyHelper.getSettings(eCurrency).getScale();
    }

    @Nonnull
    @CheckReturnValue
    public static BigDecimal getDivided(@Nullable ECurrency eCurrency, @Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Dividend");
        ValueEnforcer.notNull((Object)bigDecimal2, (String)"Divisor");
        PerCurrencySettings perCurrencySettings = CurrencyHelper.getSettings(eCurrency);
        return bigDecimal.divide(bigDecimal2, perCurrencySettings.getScale(), perCurrencySettings.getRoundingMode());
    }

    @Nonnull
    @CheckReturnValue
    public static BigDecimal getDivided(@Nullable ECurrency eCurrency, @Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2, @Nonnegative int n) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Dividend");
        ValueEnforcer.notNull((Object)bigDecimal2, (String)"Divisor");
        PerCurrencySettings perCurrencySettings = CurrencyHelper.getSettings(eCurrency);
        return bigDecimal.divide(bigDecimal2, n, perCurrencySettings.getRoundingMode());
    }

    @Nonnull
    public static BigDecimal getRounded(@Nullable ECurrency eCurrency, @Nonnull BigDecimal bigDecimal) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        PerCurrencySettings perCurrencySettings = CurrencyHelper.getSettings(eCurrency);
        return bigDecimal.setScale(perCurrencySettings.getScale(), perCurrencySettings.getRoundingMode());
    }

    @Nonnull
    public static BigDecimal getRounded(@Nullable ECurrency eCurrency, @Nonnull BigDecimal bigDecimal, @Nonnegative int n) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        PerCurrencySettings perCurrencySettings = CurrencyHelper.getSettings(eCurrency);
        return bigDecimal.setScale(n, perCurrencySettings.getRoundingMode());
    }

    @Nonnull
    public static RoundingMode getRoundingMode(@Nullable ECurrency eCurrency) {
        return CurrencyHelper.getSettings(eCurrency).getRoundingMode();
    }

    public static void setRoundingMode(@Nullable ECurrency eCurrency, @Nullable RoundingMode roundingMode) {
        CurrencyHelper.getSettings(eCurrency).setRoundingMode(roundingMode);
    }

    static {
        for (Locale locale : LocaleCache.getInstance().getAllLocales()) {
            try {
                Currency currency = Currency.getInstance(locale);
                if (currency == null) continue;
                ALL_CURRENCIES.add((Object)currency);
                LOCALE_TO_CURRENCY.put((Object)locale, (Object)currency);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        CurrencyHelper.reinitializeCurrencySettings();
    }
}

