/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.currencyvalue;

import com.helger.masterdata.currency.ECurrency;
import com.helger.masterdata.currencyvalue.CurrencyValue;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CurrencyValueMicroTypeConverter
implements IMicroTypeConverter<CurrencyValue> {
    private static final IMicroQName ATTR_CURRENCY = new MicroQName("currency");
    private static final IMicroQName ATTR_VALUE = new MicroQName("value");

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull CurrencyValue currencyValue, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_CURRENCY, currencyValue.getCurrency().getID());
        microElement.setAttributeWithConversion(ATTR_VALUE, (Object)currencyValue.getValue());
        return microElement;
    }

    @Nonnull
    public CurrencyValue convertToNative(@Nonnull IMicroElement iMicroElement) {
        ECurrency eCurrency = ECurrency.getFromIDOrNull(iMicroElement.getAttributeValue(ATTR_CURRENCY));
        BigDecimal bigDecimal = (BigDecimal)iMicroElement.getAttributeValueWithConversion(ATTR_VALUE, BigDecimal.class);
        return new CurrencyValue(eCurrency, bigDecimal);
    }
}

