/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.ean;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.EValidity;
import com.helger.masterdata.ean.EEANChecksumMode;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class AbstractUPCEAN
implements Serializable {
    protected static final EEANChecksumMode DEFAULT_CHECKSUM_MODE = EEANChecksumMode.AUTO;
    private final String m_sMsg;
    private final EEANChecksumMode m_eChecksumMode;

    public AbstractUPCEAN(@Nonnull String string, @Nonnull EEANChecksumMode eEANChecksumMode) {
        this.m_sMsg = (String)ValueEnforcer.notNull((Object)string, (String)"Msg");
        this.m_eChecksumMode = (EEANChecksumMode)((Object)ValueEnforcer.notNull((Object)((Object)eEANChecksumMode), (String)"ChecksumMode"));
    }

    @Nonnull
    public String getMessage() {
        return this.m_sMsg;
    }

    @Nonnull
    public EEANChecksumMode getChecksumMode() {
        return this.m_eChecksumMode;
    }

    @Nonnull
    protected abstract EValidity validate();

    @Nonnull
    protected static EValidity validateMessage(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Msg");
        return AbstractUPCEAN.validateMessage(string.toCharArray());
    }

    @Nonnull
    protected static EValidity validateMessage(@Nonnull char[] cArray) {
        ValueEnforcer.notNull((Object)cArray, (String)"Chars");
        for (char c : cArray) {
            if (c >= '0' && c <= '9') continue;
            return EValidity.INVALID;
        }
        return EValidity.VALID;
    }

    static int asInt(char c) {
        return Character.digit(c, 10);
    }

    static char asChar(int n) {
        return Character.forDigit(n, 10);
    }

    protected static int calcChecksum(@Nonnull char[] cArray, @Nonnegative int n) {
        int n2 = 0;
        int n3 = n % 2 == 0 ? 1 : 3;
        for (int i = 0; i < n; ++i) {
            n2 += AbstractUPCEAN.asInt(cArray[i]) * n3;
            n3 = 4 - n3;
        }
        return (1000 - n2) % 10;
    }

    protected static char calcChecksumChar(@Nonnull String string, @Nonnegative int n) {
        ValueEnforcer.notNull((Object)string, (String)"Msg");
        ValueEnforcer.isBetweenInclusive((int)n, (String)"Length", (int)0, (int)string.length());
        return AbstractUPCEAN.asChar(AbstractUPCEAN.calcChecksum(string.toCharArray(), n));
    }
}

