/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.nuts;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.name.IHasDisplayName;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.nuts.ENutsLevel;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class NutsItem
implements IHasID<String>,
IHasDisplayName {
    public static final int ID_MIN_LENGTH = 2;
    public static final int ID_MAX_LENGTH = 5;
    private final String m_sID;
    private final String m_sDisplayName;
    private final String m_sLatinDisplayName;
    private final ENutsLevel m_eNutsLevel;
    private final int m_nCountryOrdinal;
    private final int m_nRegionOrdinal;

    public NutsItem(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        ValueEnforcer.isTrue(() -> string.length() >= 2 && string.length() <= 5, (String)"Odd ID length");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Name");
        ValueEnforcer.isGT0((int)n, (String)"CountryOrdinal");
        ValueEnforcer.isGT0((int)n2, (String)"RegionOrdinal");
        this.m_sID = string;
        this.m_sDisplayName = string2;
        this.m_sLatinDisplayName = StringHelper.hasText((String)string3) ? string3 : string2;
        this.m_eNutsLevel = ENutsLevel.getFromLengthOrThrow(string.length());
        this.m_nCountryOrdinal = n;
        this.m_nRegionOrdinal = n2;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    @Nonempty
    public String getLatinDisplayName() {
        return this.m_sLatinDisplayName;
    }

    @Nonnull
    public ENutsLevel getLevel() {
        return this.m_eNutsLevel;
    }

    @Nonnegative
    public int getCountryOrdinal() {
        return this.m_nCountryOrdinal;
    }

    @Nonnegative
    public int getRegionOrdinal() {
        return this.m_nRegionOrdinal;
    }

    public String toString() {
        return new ToStringGenerator(null).append("ID", (Object)this.m_sID).append("DisplayName", (Object)this.m_sDisplayName).append("LatinDisplayName", (Object)this.m_sLatinDisplayName).append("Level", (Enum)this.m_eNutsLevel).append("CountryOrdinal", this.m_nCountryOrdinal).append("RegionOrdinal", this.m_nRegionOrdinal).getToString();
    }
}

