/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.swift;

import com.helger.commons.regex.RegExCache;
import com.helger.commons.string.StringHelper;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.RegEx;

public final class BICManager {
    public static final int BIC_LENGTH_MIN = 8;
    public static final int BIC_LENGTH_MAX = 11;
    public static final String BIC_SUFFIX_MIN_TO_MAX = "XXX";
    @RegEx
    public static final String BIC_PATTERN = "(?i)^[a-z]{6}[a-z0-9]{2}([a-z0-9]{3})?$";
    private static final Pattern BIC_PATTERN_PATTERN = RegExCache.getPattern((String)"(?i)^[a-z]{6}[a-z0-9]{2}([a-z0-9]{3})?$");
    private static final BICManager INSTANCE = new BICManager();

    private BICManager() {
    }

    public static boolean isValidBIC(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return BIC_PATTERN_PATTERN.matcher(string).matches();
    }

    public static boolean isPassiveBICParticipant(@Nullable String string) {
        return BICManager.isValidBIC(string) && string.charAt(7) == '1';
    }

    public static boolean isTestBIC(@Nullable String string) {
        return BICManager.isValidBIC(string) && string.charAt(7) == '0';
    }
}

