/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.vat;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.id.IHasID;
import com.helger.commons.math.MathHelper;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.datetime.period.ILocalDatePeriod;
import com.helger.masterdata.vat.EVATItemType;
import java.math.BigDecimal;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@MustImplementEqualsAndHashcode
public interface IVATItem
extends IHasDisplayText,
IHasID<String> {
    @Nonnull
    public EVATItemType getType();

    @Nullable
    public Locale getCountry();

    default public boolean hasCountry() {
        return this.getCountry() != null;
    }

    @Nonnull
    @Nonnegative
    public BigDecimal getPercentage();

    default public boolean hasPercentage(@Nullable BigDecimal bigDecimal) {
        return EqualsHelper.equals((Object)this.getPercentage(), (Object)bigDecimal);
    }

    default public boolean isZeroPercentage() {
        return MathHelper.isEQ0((BigDecimal)this.getPercentage());
    }

    default public boolean isNonZeroPercentage() {
        return MathHelper.isNE0((BigDecimal)this.getPercentage());
    }

    @Nonnull
    @Nonnegative
    public BigDecimal getPercentageFactor();

    @Nonnull
    @Nonnegative
    public BigDecimal getMultiplicationFactorNetToGross();

    public boolean isDeprecated();

    @Nonnull
    public ILocalDatePeriod getPeriod();
}

