/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.vat;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.locale.country.IHasCountry;
import com.helger.commons.regex.RegExCache;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
public class VATINStructure
implements IHasCountry,
Serializable {
    private final Locale m_aCountry;
    private final String m_sPattern;
    private final Pattern m_aPattern;
    private final ICommonsList<String> m_aExamples;

    public VATINStructure(@Nonnull String string, @Nonnull @RegEx String string2, @Nonnull Collection<String> collection) {
        ValueEnforcer.notNull((Object)string, (String)"Country");
        ValueEnforcer.notNull((Object)string2, (String)"RegEx");
        ValueEnforcer.notEmpty(collection, (String)"Example");
        this.m_aCountry = CountryCache.getInstance().getCountry(string);
        if (this.m_aCountry == null) {
            throw new IllegalArgumentException("country");
        }
        this.m_sPattern = string2;
        this.m_aPattern = RegExCache.getPattern((String)string2);
        this.m_aExamples = new CommonsArrayList(collection);
        if (GlobalDebug.isDebugMode()) {
            for (String string3 : this.m_aExamples) {
                if (this.isValid(string3)) continue;
                throw new IllegalArgumentException("Example VATIN " + string3 + " does not match " + string2);
            }
        }
    }

    public boolean isValid(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        String string2 = StringHelper.removeAll((String)string, (String)" ").toUpperCase(Locale.US);
        return this.m_aPattern.matcher(string2).matches();
    }

    @Nonnull
    public String getPattern() {
        return this.m_sPattern;
    }

    @Nonnull
    public Locale getCountry() {
        return this.m_aCountry;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<String> getExamples() {
        return (ICommonsList)this.m_aExamples.getClone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        VATINStructure vATINStructure = (VATINStructure)object;
        return this.m_aCountry.equals(vATINStructure.m_aCountry) && this.m_sPattern.equals(vATINStructure.m_sPattern) && this.m_aExamples.equals(vATINStructure.m_aExamples);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aCountry).append((Object)this.m_sPattern).append(this.m_aExamples).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("country", (Object)this.m_aCountry).append("pattern", (Object)this.m_sPattern).append("examples", this.m_aExamples).getToString();
    }
}

