/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.vat;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.datetime.PDTFromString;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.vat.EVATItemType;
import com.helger.masterdata.vat.IVATItem;
import com.helger.masterdata.vat.IVATItemProvider;
import com.helger.masterdata.vat.VATCountryData;
import com.helger.masterdata.vat.VATItem;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.util.MicroHelper;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class VATManager
implements IVATItemProvider {
    public static final IVATItem VATTYPE_NONE = new VATItem("_none_", null, EVATItemType.OTHER, BigDecimal.ZERO, false, null, null);
    private static final Logger LOGGER = LoggerFactory.getLogger(VATManager.class);
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ISO_DATE;
    private final ICommonsList<String> m_aSources = new CommonsArrayList();
    private final ICommonsMap<Locale, VATCountryData> m_aVATItemsPerCountry = new CommonsHashMap();
    private final ICommonsMap<String, IVATItem> m_aAllVATItems = new CommonsHashMap();

    @Nullable
    private static String _getCountryString(@Nullable Locale locale) {
        if (locale == null) {
            return null;
        }
        if (LocaleHelper.isSpecialLocale((Locale)locale)) {
            return locale.getLanguage();
        }
        return locale.getCountry().toLowerCase(Locale.US);
    }

    public void initFromXML(@Nonnull IMicroDocument iMicroDocument) {
        ValueEnforcer.notNull((Object)iMicroDocument, (String)"Doc");
        ValueEnforcer.notNull((Object)iMicroDocument.getDocumentElement(), (String)"Doc.DocumentElement");
        this.m_aSources.clear();
        this.m_aVATItemsPerCountry.clear();
        this.m_aAllVATItems.clear();
        IMicroElement iMicroElement2 = iMicroDocument.getDocumentElement().getFirstChildElement("sources");
        if (iMicroElement2 != null) {
            iMicroElement2.forAllChildElements(IMicroElement.filterNamespaceURIAndName(null, (String)"source"), iMicroElement -> {
                String string = iMicroElement.getTextContent();
                if (StringHelper.hasText((String)string)) {
                    this.m_aSources.add((Object)string);
                }
            });
        }
        for (IMicroElement iMicroElement3 : iMicroDocument.getDocumentElement().getAllChildElements("vattypes")) {
            String string = iMicroElement3.getAttributeValue("country");
            Locale locale = CountryCache.getInstance().getCountry(string);
            if (this.m_aVATItemsPerCountry.containsKey((Object)locale)) {
                LOGGER.warn("VAT types for country " + locale + " have already been defined!");
                continue;
            }
            String string2 = iMicroElement3.getAttributeValue("countryname");
            String string3 = iMicroElement3.getAttributeValue("zerovat");
            boolean bl = StringParser.parseBool((String)string3);
            String string4 = MicroHelper.getChildTextContent((IMicroElement)iMicroElement3, (String)"comment");
            VATCountryData vATCountryData = new VATCountryData(locale, bl, string2, string4);
            for (IMicroElement iMicroElement4 : iMicroElement3.getAllChildElements("item")) {
                String string5;
                LocalDate localDate;
                String string6;
                LocalDate localDate2;
                String string7 = iMicroElement4.getAttributeValue("id");
                if (StringHelper.hasNoText((String)string7)) {
                    LOGGER.warn("VAT item in country " + locale + " has no ID. Skipping VAT item.");
                    continue;
                }
                String string8 = VATManager._getCountryString(locale) + "." + string7;
                String string9 = iMicroElement4.getAttributeValue("type");
                EVATItemType eVATItemType = EVATItemType.getFromIDOrNull(string9);
                if (eVATItemType == null) {
                    LOGGER.warn("VAT type '" + string9 + "' for VAT item " + string8 + " is illegal. Skipping VAT item.");
                    continue;
                }
                String string10 = iMicroElement4.getAttributeValue("percentage");
                BigDecimal bigDecimal = StringParser.parseBigDecimal((String)string10, null);
                if (bigDecimal == null) {
                    LOGGER.warn("Percentage value '" + string10 + "' for VAT item " + string8 + " is illegal. Skipping VAT item.");
                    continue;
                }
                String string11 = iMicroElement4.getAttributeValue("deprecated");
                boolean bl2 = string11 != null && StringParser.parseBool((String)string11);
                VATItem vATItem = new VATItem(string8, locale, eVATItemType, bigDecimal, bl2, localDate2 = PDTFromString.getLocalDateFromString((String)(string6 = iMicroElement4.getAttributeValue("validfrom")), (DateTimeFormatter)DATE_FORMAT), localDate = PDTFromString.getLocalDateFromString((String)(string5 = iMicroElement4.getAttributeValue("validto")), (DateTimeFormatter)DATE_FORMAT));
                if (vATCountryData.addItem(vATItem).isUnchanged()) {
                    LOGGER.warn("Found duplicate VAT item " + vATItem + " for country " + locale);
                }
                if (this.m_aAllVATItems.put((Object)string8, (Object)vATItem) == null) continue;
                LOGGER.warn("Found overall duplicate VAT item " + vATItem);
            }
            if (vATCountryData.isEmpty()) {
                LOGGER.warn("No VAT types for country " + locale + " defined!");
            }
            this.m_aVATItemsPerCountry.put((Object)locale, (Object)vATCountryData);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllSources() {
        return (ICommonsList)this.m_aSources.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<Locale> getAllAvailableCountries() {
        return this.m_aVATItemsPerCountry.copyOfKeySet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<Locale, VATCountryData> getAllCountryData() {
        return (ICommonsMap)this.m_aVATItemsPerCountry.getClone();
    }

    public boolean isZeroVATAllowed(@Nonnull Locale locale, boolean bl) {
        ValueEnforcer.notNull((Object)locale, (String)"Country");
        VATCountryData vATCountryData = this.getVATCountryData(locale);
        return vATCountryData != null ? vATCountryData.isZeroVATAllowed() : bl;
    }

    @Nullable
    public VATCountryData getVATCountryData(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        Locale locale2 = CountryCache.getInstance().getCountry(locale);
        return (VATCountryData)this.m_aVATItemsPerCountry.get((Object)locale2);
    }

    public boolean isVATCountryDataAvailable(@Nullable Locale locale) {
        return locale != null && this.getVATCountryData(locale) != null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, IVATItem> getAllVATItemsForCountry(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"Country");
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        VATCountryData vATCountryData = this.getVATCountryData(locale);
        if (vATCountryData != null) {
            if (vATCountryData.isZeroVATAllowed()) {
                commonsHashMap.put((Object)((String)VATTYPE_NONE.getID()), (Object)VATTYPE_NONE);
            }
            commonsHashMap.putAll(vATCountryData.getAllItems());
        }
        return commonsHashMap;
    }

    @Override
    @Nullable
    public IVATItem getVATItemOfID(@Nullable String string) {
        IVATItem iVATItem = (IVATItem)this.m_aAllVATItems.get((Object)string);
        if (iVATItem == null && ((String)VATTYPE_NONE.getID()).equals(string)) {
            iVATItem = VATTYPE_NONE;
        }
        return iVATItem;
    }

    @Override
    @Nullable
    public IVATItem getVATItemOfID(@Nonnull Locale locale, @Nullable String string) {
        return this.getVATItemOfID(VATManager._getCountryString(locale) + "." + string);
    }

    @Nullable
    public IVATItem findVATItem(@Nullable EVATItemType eVATItemType, @Nullable BigDecimal bigDecimal) {
        if (eVATItemType == null || bigDecimal == null) {
            return null;
        }
        return this.findFirst(iVATItem -> iVATItem.getType().equals((Object)eVATItemType) && iVATItem.hasPercentage(bigDecimal));
    }

    @Nullable
    public IVATItem findFirst(@Nonnull Predicate<? super IVATItem> predicate) {
        return (IVATItem)CollectionHelper.findFirst((Iterable)this.m_aAllVATItems.values(), predicate);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IVATItem> findAll(@Nonnull Predicate<? super IVATItem> predicate) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        CollectionHelper.findAll((Iterable)this.m_aAllVATItems.values(), predicate, arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        return commonsArrayList;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("sources", this.m_aSources).append("VATItemsPerCountry", this.m_aVATItemsPerCountry).append("allVATItems", this.m_aAllVATItems).getToString();
    }

    @Nonnull
    public static VATManager readFromXML(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        return VATManager.readFromXML(iHasInputStream.getInputStream());
    }

    @Nonnull
    public static VATManager readFromXML(@Nonnull @WillClose InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((InputStream)inputStream);
        VATManager vATManager = new VATManager();
        vATManager.initFromXML(iMicroDocument);
        return vATManager;
    }

    @Nonnull
    public static VATManager getDefaultInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static final class SingletonHolder {
        static final VATManager INSTANCE = VATManager.readFromXML((IHasInputStream)new ClassPathResource("codelists/vat-data.xml"));

        private SingletonHolder() {
        }
    }
}

