/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tenancy;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.tenancy.IBusinessObject;
import com.helger.typeconvert.collection.StringMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;

@NotThreadSafe
public abstract class AbstractBusinessObject
implements IBusinessObject,
Serializable {
    private final String m_sID;
    private final LocalDateTime m_aCreationDT;
    private final String m_sCreationUserID;
    private LocalDateTime m_aLastModificationDT;
    private String m_sLastModificationUserID;
    private LocalDateTime m_aDeletionDT;
    private String m_sDeletionUserID;
    private final StringMap m_aAttrs = new StringMap();
    private transient int m_nHashCode = 0;

    public AbstractBusinessObject(@Nonnull IBusinessObject iBusinessObject) {
        this((String)iBusinessObject.getID(), iBusinessObject.getCreationDateTime(), iBusinessObject.getCreationUserID(), iBusinessObject.getLastModificationDateTime(), iBusinessObject.getLastModificationUserID(), iBusinessObject.getDeletionDateTime(), iBusinessObject.getDeletionUserID(), (Map<String, String>)iBusinessObject.attrs());
    }

    public AbstractBusinessObject(@Nonnull @Nonempty String string, @Nullable LocalDateTime localDateTime, @Nullable String string2, @Nullable LocalDateTime localDateTime2, @Nullable String string3, @Nullable LocalDateTime localDateTime3, @Nullable String string4, @Nullable Map<String, String> map) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        this.m_aCreationDT = localDateTime;
        this.m_sCreationUserID = string2;
        this.m_aLastModificationDT = localDateTime2;
        this.m_sLastModificationUserID = string3;
        this.m_aDeletionDT = localDateTime3;
        this.m_sDeletionUserID = string4;
        this.m_aAttrs.putAllIfNotNull(map);
    }

    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sID;
    }

    @Nullable
    public final LocalDateTime getCreationDateTime() {
        return this.m_aCreationDT;
    }

    @Override
    @Nullable
    public final String getCreationUserID() {
        return this.m_sCreationUserID;
    }

    @Nullable
    public final LocalDateTime getLastModificationDateTime() {
        return this.m_aLastModificationDT;
    }

    @Override
    @Nullable
    public final String getLastModificationUserID() {
        return this.m_sLastModificationUserID;
    }

    public final void setLastModification(@Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"LastModificationDT");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"LastModificationUserID");
        if (this.isDeleted()) {
            throw new IllegalStateException("Object is deleted and can therefore not be modified!");
        }
        this.m_aLastModificationDT = localDateTime;
        this.m_sLastModificationUserID = string;
    }

    @Nullable
    public final LocalDateTime getDeletionDateTime() {
        return this.m_aDeletionDT;
    }

    @Override
    @Nullable
    public final String getDeletionUserID() {
        return this.m_sDeletionUserID;
    }

    @Nonnull
    public final EChange setDeletion(@Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"DeletionDT");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DeletionUserID");
        if (this.m_aDeletionDT != null) {
            return EChange.UNCHANGED;
        }
        this.m_aDeletionDT = localDateTime;
        this.m_sDeletionUserID = string;
        return EChange.CHANGED;
    }

    @Nonnull
    public final EChange setUndeletion(@Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"UndeletionDT");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"UndeletionUserID");
        if (this.m_aDeletionDT == null) {
            return EChange.UNCHANGED;
        }
        this.m_aDeletionDT = null;
        this.m_sDeletionUserID = null;
        this.setLastModification(localDateTime, string);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableObject
    public final StringMap attrs() {
        return this.m_aAttrs;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractBusinessObject abstractBusinessObject = (AbstractBusinessObject)object;
        return this.getID().equals(abstractBusinessObject.getID());
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator((Object)this).append((Object)this.getID()).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).appendIfNotNull("CreationDT", (Object)this.m_aCreationDT).appendIfNotNull("CreationUserID", (Object)this.m_sCreationUserID).appendIfNotNull("LastModificationDT", (Object)this.m_aLastModificationDT).appendIfNotNull("LastModificationUserID", (Object)this.m_sLastModificationUserID).appendIfNotNull("DeletionDT", (Object)this.m_aDeletionDT).appendIfNotNull("DeletionUserID", (Object)this.m_sDeletionUserID).append("Attrs", (Object)this.m_aAttrs).getToString();
    }
}

