/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reporting.api.backend;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.IsSPIInterface;
import com.helger.base.name.IHasDisplayName;
import com.helger.base.state.ESuccess;
import com.helger.config.IConfig;
import com.helger.peppol.reporting.api.PeppolReportingItem;
import com.helger.peppol.reporting.api.backend.PeppolReportingBackendException;
import jakarta.annotation.Nonnull;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.function.Consumer;

@IsSPIInterface
public interface IPeppolReportingBackendSPI
extends IHasDisplayName {
    @Nonnull
    @Nonempty
    public String getDisplayName();

    @Nonnull
    public ESuccess initBackend(@Nonnull IConfig var1);

    public boolean isInitialized();

    public void shutdownBackend();

    public void storeReportingItem(@Nonnull PeppolReportingItem var1) throws PeppolReportingBackendException;

    @Nonnull
    public Iterable<PeppolReportingItem> iterateReportingItems(@Nonnull LocalDate var1, @Nonnull LocalDate var2) throws PeppolReportingBackendException;

    @Nonnull
    default public Iterable<PeppolReportingItem> iterateReportingItems(@Nonnull YearMonth yearMonth) throws PeppolReportingBackendException {
        return this.iterateReportingItems(yearMonth.atDay(1), yearMonth.atEndOfMonth());
    }

    default public void forEachReportingItem(@Nonnull LocalDate localDate, @Nonnull LocalDate localDate2, @Nonnull Consumer<? super PeppolReportingItem> consumer) throws PeppolReportingBackendException {
        this.iterateReportingItems(localDate, localDate2).forEach(consumer);
    }

    default public void forEachReportingItem(@Nonnull YearMonth yearMonth, @Nonnull Consumer<? super PeppolReportingItem> consumer) throws PeppolReportingBackendException {
        this.iterateReportingItems(yearMonth).forEach(consumer);
    }
}

