/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reportingsupport;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHelper;
import com.helger.datetime.helper.PDTFactory;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.list.ErrorList;
import com.helger.peppol.reporting.eusr.EndUserStatisticsReportValidator;
import com.helger.peppol.reporting.jaxb.eusr.EndUserStatisticsReport110Marshaller;
import com.helger.peppol.reporting.jaxb.eusr.v110.EndUserStatisticsReportType;
import com.helger.peppol.reporting.jaxb.tsr.TransactionStatisticsReport101Marshaller;
import com.helger.peppol.reporting.jaxb.tsr.v101.TransactionStatisticsReportType;
import com.helger.peppol.reporting.tsr.TransactionStatisticsReportValidator;
import com.helger.peppol.reportingsupport.EPeppolReportType;
import com.helger.peppol.reportingsupport.IPeppolReportSenderCallback;
import com.helger.peppol.reportingsupport.IPeppolReportStorage;
import com.helger.peppol.reportingsupport.domain.PeppolReportData;
import com.helger.peppol.reportingsupport.domain.PeppolReportSendingReportData;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.peppol.doctype.EPredefinedDocumentTypeIdentifier;
import com.helger.peppolid.peppol.process.EPredefinedProcessIdentifier;
import com.helger.schematron.svrl.SVRLFailedAssert;
import com.helger.schematron.svrl.SVRLHelper;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.xml.transform.TransformSourceFactory;
import jakarta.annotation.Nonnull;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.xml.transform.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PeppolReportingSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolReportingSupport.class);
    private final IPeppolReportStorage m_aStorage;
    private Locale m_aDisplayLocale = Locale.ROOT;
    private Consumer<? super String> m_aWarnHdl = arg_0 -> ((Logger)LOGGER).warn(arg_0);
    private BiConsumer<? super String, ? super Exception> m_aErrorHdl = (arg_0, arg_1) -> ((Logger)LOGGER).error(arg_0, arg_1);

    public PeppolReportingSupport(@Nonnull IPeppolReportStorage iPeppolReportStorage) {
        ValueEnforcer.notNull((Object)iPeppolReportStorage, (String)"Storage");
        this.m_aStorage = iPeppolReportStorage;
    }

    @Nonnull
    public Locale getDisplayLocale() {
        return this.m_aDisplayLocale;
    }

    @Nonnull
    public PeppolReportingSupport setDisplayLocale(@Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        this.m_aDisplayLocale = locale;
        return this;
    }

    @Nonnull
    public PeppolReportingSupport setWarningHandler(@Nonnull Consumer<? super String> consumer) {
        ValueEnforcer.notNull(consumer, (String)"WarnHdl");
        this.m_aWarnHdl = consumer;
        return this;
    }

    @Nonnull
    public PeppolReportingSupport setErrorHandler(@Nonnull BiConsumer<? super String, ? super Exception> biConsumer) {
        ValueEnforcer.notNull(biConsumer, (String)"ErrorHdl");
        this.m_aErrorHdl = biConsumer;
        return this;
    }

    @Nonnull
    public ESuccess validateAndStorePeppolTSR10(@Nonnull TransactionStatisticsReportType transactionStatisticsReportType, @Nonnull Consumer<String> consumer) {
        Object object;
        ValueEnforcer.notNull((Object)transactionStatisticsReportType, (String)"TSR");
        ValueEnforcer.notNull(consumer, (String)"TSRStringConsumer");
        YearMonth yearMonth = YearMonth.of(transactionStatisticsReportType.getHeader().getReportPeriod().getStartDate().getYear(), transactionStatisticsReportType.getHeader().getReportPeriod().getStartDate().getMonth());
        ESuccess eSuccess = ESuccess.SUCCESS;
        LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTimeMillisOnly();
        ErrorList errorList = new ErrorList();
        String string = new TransactionStatisticsReport101Marshaller().setCollectErrors(errorList).setFormattedOutput(true).getAsString((Object)transactionStatisticsReportType);
        for (IError iError : errorList) {
            if (iError.isError()) {
                this.m_aErrorHdl.accept("TSR XSD error: " + iError.getAsString(this.m_aDisplayLocale), null);
                continue;
            }
            this.m_aWarnHdl.accept("TSR XSD warning: " + iError.getAsString(this.m_aDisplayLocale));
        }
        if (StringHelper.isEmpty((String)string)) {
            return ESuccess.FAILURE;
        }
        consumer.accept(string);
        LOGGER.info("Starting TSR " + String.valueOf(yearMonth) + " Schematron validation");
        try {
            IError iError;
            object = TransactionStatisticsReportValidator.getSchematronTSR_1().applySchematronValidationToSVRL((Source)TransformSourceFactory.create((String)string));
            iError = SVRLHelper.getAllFailedAssertions((SchematronOutputType)object);
            int n = 0;
            for (SVRLFailedAssert sVRLFailedAssert : iError) {
                String string2 = sVRLFailedAssert.getAsResourceError("in-memory").getAsString(this.m_aDisplayLocale);
                if (sVRLFailedAssert.getFlag().isError()) {
                    ++n;
                    this.m_aErrorHdl.accept("TSR Schematron error: " + string2, null);
                    continue;
                }
                this.m_aWarnHdl.accept("TSR Schematron warning: " + string2);
            }
            if (n > 0) {
                eSuccess = ESuccess.FAILURE;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error in TSR " + String.valueOf(yearMonth) + " Schematron validation", (Throwable)exception);
            this.m_aErrorHdl.accept("Error in TSR Schematron validation", exception);
            eSuccess = ESuccess.FAILURE;
        }
        LOGGER.info("Now storing TSR " + String.valueOf(yearMonth) + " in state " + String.valueOf(eSuccess));
        object = new PeppolReportData(EPeppolReportType.TSR_V10, yearMonth, localDateTime, string, eSuccess.isSuccess());
        if (this.m_aStorage.storePeppolReport((PeppolReportData)object).isFailure()) {
            this.m_aErrorHdl.accept("Error storing TSR " + String.valueOf(yearMonth), null);
            return ESuccess.FAILURE;
        }
        return eSuccess;
    }

    @Nonnull
    public ESuccess validateAndStorePeppolEUSR11(@Nonnull EndUserStatisticsReportType endUserStatisticsReportType, @Nonnull Consumer<String> consumer) {
        Object object;
        ValueEnforcer.notNull((Object)endUserStatisticsReportType, (String)"EUSR");
        ValueEnforcer.notNull(consumer, (String)"EUSRByteConsumer");
        YearMonth yearMonth = YearMonth.of(endUserStatisticsReportType.getHeader().getReportPeriod().getStartDate().getYear(), endUserStatisticsReportType.getHeader().getReportPeriod().getStartDate().getMonth());
        ESuccess eSuccess = ESuccess.SUCCESS;
        LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTimeMillisOnly();
        ErrorList errorList = new ErrorList();
        String string = new EndUserStatisticsReport110Marshaller().setCollectErrors(errorList).setFormattedOutput(true).getAsString((Object)endUserStatisticsReportType);
        for (IError iError : errorList) {
            if (iError.isError()) {
                this.m_aErrorHdl.accept("EUSR XSD error: " + iError.getAsString(this.m_aDisplayLocale), null);
                continue;
            }
            this.m_aWarnHdl.accept("EUSR XSD warning: " + iError.getAsString(this.m_aDisplayLocale));
        }
        if (StringHelper.isEmpty((String)string)) {
            return ESuccess.FAILURE;
        }
        consumer.accept(string);
        LOGGER.info("Starting EUSR " + String.valueOf(yearMonth) + " Schematron validation");
        try {
            IError iError;
            object = EndUserStatisticsReportValidator.getSchematronEUSR_1().applySchematronValidationToSVRL((Source)TransformSourceFactory.create((String)string));
            iError = SVRLHelper.getAllFailedAssertions((SchematronOutputType)object);
            int n = 0;
            for (SVRLFailedAssert sVRLFailedAssert : iError) {
                String string2 = sVRLFailedAssert.getAsResourceError("in-memory").getAsString(this.m_aDisplayLocale);
                if (sVRLFailedAssert.getFlag().isError()) {
                    ++n;
                    this.m_aErrorHdl.accept("EUSR Schematron error: " + string2, null);
                    continue;
                }
                this.m_aWarnHdl.accept("EUSR Schematron warning: " + string2);
            }
            if (n > 0) {
                eSuccess = ESuccess.FAILURE;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error in EUSR " + String.valueOf(yearMonth) + " Schematron validation", (Throwable)exception);
            this.m_aErrorHdl.accept("Error in EUSR Schematron validation", exception);
            eSuccess = ESuccess.FAILURE;
        }
        LOGGER.info("Now storing EUSR " + String.valueOf(yearMonth) + " in state " + String.valueOf(eSuccess));
        object = new PeppolReportData(EPeppolReportType.EUSR_V11, yearMonth, localDateTime, string, eSuccess.isSuccess());
        if (this.m_aStorage.storePeppolReport((PeppolReportData)object).isFailure()) {
            this.m_aErrorHdl.accept("Error storing EUSR " + String.valueOf(yearMonth), null);
            return ESuccess.FAILURE;
        }
        return eSuccess;
    }

    @Nonnull
    public ESuccess sendPeppolReport(@Nonnull YearMonth yearMonth, @Nonnull EPeppolReportType ePeppolReportType, @Nonnull @Nonempty String string, @Nonnull IPeppolReportSenderCallback iPeppolReportSenderCallback) {
        String string2;
        EPredefinedDocumentTypeIdentifier ePredefinedDocumentTypeIdentifier;
        ValueEnforcer.notNull((Object)yearMonth, (String)"YearMonth");
        ValueEnforcer.notNull((Object)((Object)ePeppolReportType), (String)"ReportType");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ReportPayload");
        ValueEnforcer.notNull((Object)iPeppolReportSenderCallback, (String)"MainPeppolSender");
        EPredefinedProcessIdentifier ePredefinedProcessIdentifier = switch (ePeppolReportType) {
            case EPeppolReportType.TSR_V10 -> {
                ePredefinedDocumentTypeIdentifier = EPredefinedDocumentTypeIdentifier.TRANSACTIONSTATISTICSREPORT_FDC_PEPPOL_EU_EDEC_TRNS_TRANSACTION_STATISTICS_REPORTING_1_0;
                yield EPredefinedProcessIdentifier.urn_fdc_peppol_eu_edec_bis_reporting_1_0;
            }
            case EPeppolReportType.EUSR_V11 -> {
                ePredefinedDocumentTypeIdentifier = EPredefinedDocumentTypeIdentifier.ENDUSERSTATISTICSREPORT_FDC_PEPPOL_EU_EDEC_TRNS_END_USER_STATISTICS_REPORT_1_1;
                yield EPredefinedProcessIdentifier.urn_fdc_peppol_eu_edec_bis_reporting_1_0;
            }
            default -> throw new IllegalStateException("Unsupported Peppol report type " + String.valueOf((Object)ePeppolReportType));
        };
        LocalDateTime localDateTime = PDTFactory.getCurrentLocalDateTimeMillisOnly();
        try {
            LOGGER.info("Now sending Peppol Report " + String.valueOf((Object)ePeppolReportType) + " for " + String.valueOf(yearMonth) + " via Peppol Network");
            string2 = iPeppolReportSenderCallback.sendPeppolMessage((IDocumentTypeIdentifier)ePredefinedDocumentTypeIdentifier, (IProcessIdentifier)ePredefinedProcessIdentifier, string);
        }
        catch (Exception exception) {
            String string3 = "Failed to send Peppol Report " + String.valueOf((Object)ePeppolReportType) + " for " + String.valueOf(yearMonth) + " via the Peppol Network";
            this.m_aErrorHdl.accept(string3, exception);
            return ESuccess.FAILURE;
        }
        LOGGER.info("Now storing sending report of " + String.valueOf((Object)ePeppolReportType) + " for " + String.valueOf(yearMonth));
        PeppolReportSendingReportData peppolReportSendingReportData = new PeppolReportSendingReportData(ePeppolReportType, yearMonth, localDateTime, string2);
        if (this.m_aStorage.storePeppolReportingSendingReport(peppolReportSendingReportData).isFailure()) {
            this.m_aErrorHdl.accept("Error storing sending report of " + String.valueOf((Object)ePeppolReportType) + " for " + String.valueOf(yearMonth), null);
            return ESuccess.FAILURE;
        }
        return ESuccess.SUCCESS;
    }
}

