/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reportingsupport.domain;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.datetime.web.PDTWebDateHelper;
import com.helger.peppol.reportingsupport.EPeppolReportType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.time.YearMonth;

@Immutable
public class PeppolReportData {
    private final EPeppolReportType m_eReportType;
    private final YearMonth m_aReportPeriod;
    private final LocalDateTime m_aReportCreationDT;
    private final String m_sReportXML;
    private final boolean m_bReportValid;

    public PeppolReportData(@Nonnull EPeppolReportType ePeppolReportType, @Nonnull YearMonth yearMonth, @Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string, boolean bl) {
        ValueEnforcer.notNull((Object)((Object)ePeppolReportType), (String)"ReportType");
        ValueEnforcer.notNull((Object)yearMonth, (String)"ReportPeriod");
        ValueEnforcer.notNull((Object)localDateTime, (String)"ReportCreationDT");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ReportXMLBytes");
        this.m_eReportType = ePeppolReportType;
        this.m_aReportPeriod = yearMonth;
        this.m_aReportCreationDT = localDateTime;
        this.m_sReportXML = string;
        this.m_bReportValid = bl;
    }

    @Nonnull
    public final EPeppolReportType getReportType() {
        return this.m_eReportType;
    }

    @Nonnull
    public final YearMonth getReportPeriod() {
        return this.m_aReportPeriod;
    }

    @Nonnull
    public final LocalDateTime getReportCreationDT() {
        return this.m_aReportCreationDT;
    }

    @Nonnull
    @Nonempty
    public final String getReportXMLString() {
        return this.m_sReportXML;
    }

    public final boolean isReportValid() {
        return this.m_bReportValid;
    }

    @Nonnull
    public IMicroElement getAsMicroElement(@Nullable String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"ElementName");
        MicroElement microElement = new MicroElement(string, string2);
        microElement.addElementNS(string, "ReportType").addText((CharSequence)this.m_eReportType.getID());
        microElement.addElementNS(string, "ReportYear").addText(this.m_aReportPeriod.getYear());
        microElement.addElementNS(string, "ReportType").addText(this.m_aReportPeriod.getMonthValue());
        microElement.addElementNS(string, "ReportCreationDT").addText((CharSequence)PDTWebDateHelper.getAsStringXSD((LocalDateTime)this.m_aReportCreationDT));
        IMicroElement iMicroElement = microElement.addElementNS(string, "ReportXML");
        iMicroElement.addText((CharSequence)this.m_sReportXML);
        iMicroElement.setAttribute("valid", this.m_bReportValid);
        return microElement;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        PeppolReportData peppolReportData = (PeppolReportData)object;
        return this.m_eReportType.equals((Object)peppolReportData.m_eReportType) && this.m_aReportPeriod.equals(peppolReportData.m_aReportPeriod) && this.m_aReportCreationDT.equals(peppolReportData.m_aReportCreationDT) && this.m_sReportXML.equals(peppolReportData.m_sReportXML) && this.m_bReportValid == peppolReportData.m_bReportValid;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_eReportType).append((Object)this.m_aReportPeriod).append((Object)this.m_aReportCreationDT).append((Object)this.m_sReportXML).append(this.m_bReportValid).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ReportType", (Enum)this.m_eReportType).append("ReportPeriod", (Object)this.m_aReportPeriod).append("ReportCreationDT", (Object)this.m_aReportCreationDT).append("ReportXML", (Object)this.m_sReportXML).append("ReportValid", this.m_bReportValid).getToString();
    }
}

