/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reportingsupport.sql;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.db.api.config.IJdbcConfiguration;
import com.helger.db.jdbc.IHasDataSource;
import com.helger.db.jdbc.executor.DBExecutor;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PeppolReportDBExecutor
extends DBExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolReportDBExecutor.class);

    public PeppolReportDBExecutor(@Nonnull IHasDataSource iHasDataSource, @Nonnull IJdbcConfiguration iJdbcConfiguration) {
        super(iHasDataSource);
        ValueEnforcer.notNull((Object)iJdbcConfiguration, (String)"JDBCConfig");
        this.setDebugConnections(iJdbcConfiguration.isJdbcDebugConnections());
        this.setDebugTransactions(iJdbcConfiguration.isJdbcDebugTransactions());
        this.setDebugSQLStatements(iJdbcConfiguration.isJdbcDebugSQL());
        if (iJdbcConfiguration.isJdbcExecutionTimeWarningEnabled()) {
            long l = iJdbcConfiguration.getJdbcExecutionTimeWarningMilliseconds();
            if (l > 0L) {
                this.setExecutionDurationWarnMS(l);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignoring JDBC Execution Time Warning Milliseconds because it is invalid.");
            }
        } else {
            this.setExecutionDurationWarnMS(0L);
        }
    }
}

