/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.bdxr2;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.simple.doctype.SimpleDocumentTypeIdentifier;
import com.helger.peppolid.simple.process.SimpleProcessIdentifier;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.bdxr2.IBDXR2ServiceGroupProvider;
import com.helger.smpclient.bdxr2.IBDXR2ServiceMetadataProvider;
import com.helger.smpclient.bdxr2.marshal.BDXR2MarshallerServiceGroup;
import com.helger.smpclient.bdxr2.marshal.BDXR2MarshallerServiceMetadata;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.exception.SMPClientNotFoundException;
import com.helger.smpclient.exception.SMPClientParticipantNotFoundException;
import com.helger.smpclient.httpclient.AbstractGenericSMPClient;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerSigned;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerUnsigned;
import com.helger.smpclient.redirect.ISMPFollowRedirectCallback;
import com.helger.smpclient.url.ISMPURLProvider;
import com.helger.smpclient.url.SMPDNSResolutionException;
import com.helger.xsds.bdxr.smp2.ServiceGroupType;
import com.helger.xsds.bdxr.smp2.ServiceMetadataType;
import com.helger.xsds.bdxr.smp2.ac.CertificateType;
import com.helger.xsds.bdxr.smp2.ac.EndpointType;
import com.helger.xsds.bdxr.smp2.ac.ProcessMetadataType;
import com.helger.xsds.bdxr.smp2.ac.RedirectType;
import com.helger.xsds.bdxr.smp2.ac.ServiceReferenceType;
import com.helger.xsds.bdxr.smp2.bc.IDType;
import com.helger.xsds.ccts.cct.schemamodule.IdentifierType;
import com.helger.xsds.xmldsig.X509DataType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.JAXBElement;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDXR2ClientReadOnly
extends AbstractGenericSMPClient<BDXR2ClientReadOnly>
implements IBDXR2ServiceGroupProvider,
IBDXR2ServiceMetadataProvider {
    public static final String PATH_OASIS_BDXR_SMP_2 = "bdxr-smp-2/";
    public static final String URL_PART_SERVICES = "services";
    private static final Logger LOGGER = LoggerFactory.getLogger(BDXR2ClientReadOnly.class);

    public BDXR2ClientReadOnly(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws SMPDNSResolutionException {
        this(iSMPURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, iSMLInfo));
    }

    public BDXR2ClientReadOnly(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws SMPDNSResolutionException {
        this(iSMPURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, string));
    }

    public BDXR2ClientReadOnly(@Nonnull URI uRI) {
        super(uRI, false);
    }

    @Nonnull
    public ServiceGroupType getServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        String string = this.getSMPHostURI() + PATH_OASIS_BDXR_SMP_2 + iParticipantIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXR2Client getServiceGroup@" + string);
        }
        HttpGet httpGet = new HttpGet(string);
        BDXR2MarshallerServiceGroup bDXR2MarshallerServiceGroup = new BDXR2MarshallerServiceGroup();
        bDXR2MarshallerServiceGroup.setUseSchema(this.isXMLSchemaValidation());
        this.customizeMarshaller(bDXR2MarshallerServiceGroup);
        ServiceGroupType serviceGroupType = this.executeGenericRequest((HttpUriRequestBase)httpGet, new SMPHttpResponseHandlerUnsigned<ServiceGroupType>(bDXR2MarshallerServiceGroup));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received response: " + String.valueOf(serviceGroupType));
        }
        return serviceGroupType;
    }

    @Override
    @Nullable
    public ServiceGroupType getServiceGroupOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        try {
            return this.getServiceGroup(iParticipantIdentifier);
        }
        catch (SMPClientNotFoundException | SMPClientParticipantNotFoundException sMPClientException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found no ServiceGroup");
            }
            return null;
        }
    }

    @Nonnull
    public static ICommonsList<IDocumentTypeIdentifier> getAllDocumentTypes(@Nullable ServiceGroupType serviceGroupType, @Nonnull IIdentifierFactory iIdentifierFactory) {
        ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"IdentifierFactory");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (serviceGroupType != null) {
            for (ServiceReferenceType serviceReferenceType : serviceGroupType.getServiceReference()) {
                IDocumentTypeIdentifier iDocumentTypeIdentifier;
                IDType iDType = serviceReferenceType.getID();
                if (iDType == null || (iDocumentTypeIdentifier = iIdentifierFactory.createDocumentTypeIdentifier(iDType.getSchemeID(), iDType.getValue())) == null) continue;
                commonsArrayList.add((Object)iDocumentTypeIdentifier);
            }
        }
        return commonsArrayList;
    }

    @Nonnull
    public ServiceMetadataType getServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        return this.getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier, null);
    }

    @Nonnull
    public ServiceMetadataType getServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nullable ISMPFollowRedirectCallback iSMPFollowRedirectCallback) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        String string = this.getSMPHostURI() + PATH_OASIS_BDXR_SMP_2 + iParticipantIdentifier.getURIPercentEncoded() + "/services/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXR2Client getServiceRegistration@" + string);
        }
        boolean bl = this.isXMLSchemaValidation();
        boolean bl2 = this.isVerifySignature();
        boolean bl3 = this.isSecureValidation();
        KeyStore keyStore = this.getTrustStore();
        if (bl2 && keyStore == null) {
            LOGGER.error("BDXR2 SMP client Verify Signature is enabled, but no TrustStore is provided. This will not work.");
        }
        HttpGet httpGet = new HttpGet(string);
        BDXR2MarshallerServiceMetadata bDXR2MarshallerServiceMetadata2 = new BDXR2MarshallerServiceMetadata();
        bDXR2MarshallerServiceMetadata2.setUseSchema(bl);
        this.customizeMarshaller(bDXR2MarshallerServiceMetadata2);
        RedirectType redirectType = new SMPHttpResponseHandlerSigned(bDXR2MarshallerServiceMetadata2, keyStore);
        redirectType.setVerifySignature(bl2);
        redirectType.setSecureValidation(bl3);
        ServiceMetadataType serviceMetadataType = this.executeGenericRequest((HttpUriRequestBase)httpGet, redirectType);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received response: " + String.valueOf(serviceMetadataType));
        }
        if (!SimpleDocumentTypeIdentifier.wrap((IdentifierType)serviceMetadataType.getID()).hasSameContent(iDocumentTypeIdentifier)) {
            throw new SMPClientException("Requested document type '" + iDocumentTypeIdentifier.getURIEncoded() + "' and received '" + CIdentifier.getURIEncoded((IdentifierType)serviceMetadataType.getID()) + "' - mismatch. Ignoring request.");
        }
        for (BDXR2MarshallerServiceMetadata bDXR2MarshallerServiceMetadata2 : serviceMetadataType.getProcessMetadata()) {
            redirectType = bDXR2MarshallerServiceMetadata2.getRedirect();
            if (redirectType == null) continue;
            boolean bl4 = this.isFollowSMPRedirects();
            if (iSMPFollowRedirectCallback != null) {
                iSMPFollowRedirectCallback.onFollowSMPRedirect(bl4, redirectType.getPublisherURIValue());
            }
            if (bl4) {
                LOGGER.info("Following a redirect from '" + string + "' to '" + redirectType.getPublisherURIValue() + "'");
                HttpGet httpGet2 = new HttpGet(redirectType.getPublisherURIValue());
                BDXR2MarshallerServiceMetadata bDXR2MarshallerServiceMetadata3 = new BDXR2MarshallerServiceMetadata();
                bDXR2MarshallerServiceMetadata3.setUseSchema(bl);
                this.customizeMarshaller(bDXR2MarshallerServiceMetadata3);
                SMPHttpResponseHandlerSigned<ServiceMetadataType> sMPHttpResponseHandlerSigned = new SMPHttpResponseHandlerSigned<ServiceMetadataType>(bDXR2MarshallerServiceMetadata3, keyStore);
                sMPHttpResponseHandlerSigned.setVerifySignature(bl2);
                sMPHttpResponseHandlerSigned.setSecureValidation(bl3);
                serviceMetadataType = this.executeGenericRequest((HttpUriRequestBase)httpGet2, sMPHttpResponseHandlerSigned);
                boolean bl5 = false;
                if (serviceMetadataType.hasSignatureEntries()) {
                    block3: for (Object e : serviceMetadataType.getSignatureAtIndex(0).getKeyInfo().getContent()) {
                        Object object;
                        if (!(e instanceof JAXBElement) || !((object = ((JAXBElement)e).getValue()) instanceof X509DataType)) continue;
                        X509DataType x509DataType = (X509DataType)object;
                        for (Object e2 : x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName()) {
                            JAXBElement jAXBElement;
                            if (!(e2 instanceof JAXBElement) || !((jAXBElement = (JAXBElement)e2).getValue() instanceof X509Certificate)) continue;
                            X509Certificate x509Certificate = (X509Certificate)jAXBElement.getValue();
                            boolean bl6 = false;
                            CommonsArrayList commonsArrayList = new CommonsArrayList();
                            for (CertificateType certificateType : redirectType.getCertificate()) {
                                try {
                                    X509Certificate x509Certificate2 = CertificateHelper.convertByteArrayToCertficate((byte[])certificateType.getContentBinaryObjectValue());
                                    if (x509Certificate2 == null) continue;
                                    commonsArrayList.add((Object)x509Certificate2);
                                    if (!x509Certificate2.equals(x509Certificate)) continue;
                                    bl6 = true;
                                    break;
                                }
                                catch (CertificateException certificateException) {
                                    LOGGER.error("SMP Redirect contains an invalid certificate", (Throwable)certificateException);
                                }
                            }
                            if (!bl6) {
                                throw new SMPClientException("No certificate of the redirect matched the provided certificate. Retrieved certificate is '" + String.valueOf(x509Certificate) + "'. Allowed certificates according to the redirect are: " + String.valueOf(commonsArrayList));
                            }
                            bl5 = true;
                            break block3;
                        }
                    }
                }
                if (bl5) break;
                throw new SMPClientException("The X509 certificate did not contain a certificate subject.");
            }
            if (!LOGGER.isDebugEnabled()) break;
            LOGGER.debug("Following SMP redirects is disabled");
            break;
        }
        return serviceMetadataType;
    }

    @Override
    @Nullable
    public ServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nullable ISMPFollowRedirectCallback iSMPFollowRedirectCallback) throws SMPClientException {
        try {
            return this.getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier, iSMPFollowRedirectCallback);
        }
        catch (SMPClientNotFoundException | SMPClientParticipantNotFoundException sMPClientException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found no ServiceMetadata");
            }
            return null;
        }
    }

    @Nullable
    public static EndpointType getEndpoint(@Nonnull ServiceMetadataType serviceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull((Object)serviceMetadataType, (String)"SignedServiceMetadata");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        for (ProcessMetadataType processMetadataType : serviceMetadataType.getProcessMetadata()) {
            Object object2;
            boolean bl = false;
            for (Object object2 : processMetadataType.getProcess()) {
                if (!SimpleProcessIdentifier.wrap((IdentifierType)object2.getID()).hasSameContent(iProcessIdentifier)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (EndpointType endpointType : processMetadataType.getEndpoint()) {
                if (!iSMPTransportProfile.getID().equals(endpointType.getTransportProfileIDValue())) continue;
                commonsArrayList.add((Object)endpointType);
            }
            if (commonsArrayList.size() != 1) {
                LOGGER.warn("Found " + commonsArrayList.size() + " endpoints for process '" + iProcessIdentifier.getURIEncoded() + "' and transport profile '" + iSMPTransportProfile.getID() + "'" + (String)(commonsArrayList.isEmpty() ? "" : ": " + commonsArrayList.toString() + " - using the first one"));
            }
            object2 = (EndpointType)commonsArrayList.getFirstOrNull();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found matching endpoint: " + String.valueOf(object2));
            }
            return object2;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found no matching SMP endpoint");
        }
        return null;
    }

    @Nullable
    public static String getEndpointAddress(@Nullable EndpointType endpointType) {
        return endpointType == null ? null : endpointType.getAddressURIValue();
    }

    @Nullable
    public static byte[] getEndpointCertificateBytes(@Nullable EndpointType endpointType) {
        if (endpointType == null) {
            return null;
        }
        if (endpointType.getCertificateCount() == 0) {
            return null;
        }
        return endpointType.getCertificateAtIndex(0).getContentBinaryObjectValue();
    }

    @Nullable
    public static X509Certificate getEndpointCertificate(@Nullable EndpointType endpointType) throws CertificateException {
        byte[] byArray = BDXR2ClientReadOnly.getEndpointCertificateBytes(endpointType);
        return CertificateHelper.convertByteArrayToCertficateDirect((byte[])byArray);
    }

    @Nonnull
    public static ServiceGroupType getServiceGroupByDNS(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException, SMPDNSResolutionException {
        return new BDXR2ClientReadOnly(iSMPURLProvider, iParticipantIdentifier, iSMLInfo).getServiceGroup(iParticipantIdentifier);
    }

    @Nonnull
    public static ServiceMetadataType getServiceRegistrationByDNS(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException, SMPDNSResolutionException {
        return new BDXR2ClientReadOnly(iSMPURLProvider, iParticipantIdentifier, iSMLInfo).getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
    }
}

