/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.bdxr2;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.bdxr2.BDXR2ClientReadOnly;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.redirect.ISMPFollowRedirectCallback;
import com.helger.xsds.bdxr.smp2.ServiceMetadataType;
import com.helger.xsds.bdxr.smp2.ac.EndpointType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public interface IBDXR2ServiceMetadataProvider {
    @Nullable
    default public ServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        return this.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier, null);
    }

    @Nullable
    public ServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier var1, @Nonnull IDocumentTypeIdentifier var2, @Nullable ISMPFollowRedirectCallback var3) throws SMPClientException;

    @Nullable
    default public EndpointType getEndpoint(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        ServiceMetadataType serviceMetadataType = this.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
        return serviceMetadataType == null ? null : BDXR2ClientReadOnly.getEndpoint(serviceMetadataType, iProcessIdentifier, iSMPTransportProfile);
    }

    @Nullable
    default public String getEndpointAddress(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        EndpointType endpointType = this.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return BDXR2ClientReadOnly.getEndpointAddress(endpointType);
    }

    @Nullable
    default public byte[] getEndpointCertificateBytes(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException {
        EndpointType endpointType = this.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return BDXR2ClientReadOnly.getEndpointCertificateBytes(endpointType);
    }

    @Nullable
    default public X509Certificate getEndpointCertificate(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) throws SMPClientException, CertificateException {
        byte[] byArray = this.getEndpointCertificateBytes(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, iSMPTransportProfile);
        return CertificateHelper.convertByteArrayToCertficateDirect((byte[])byArray);
    }
}

