/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.config;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.exception.InitializationException;
import com.helger.base.string.StringHelper;
import com.helger.base.system.SystemProperties;
import com.helger.config.ConfigFactory;
import com.helger.config.fallback.ConfigWithFallback;
import com.helger.config.fallback.IConfigWithFallback;
import com.helger.config.source.MultiConfigurationValueProvider;
import com.helger.config.source.resource.properties.ConfigurationSourceProperties;
import com.helger.config.value.IConfigurationValueProvider;
import com.helger.httpclient.HttpClientSettings;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.IResourceBase;
import com.helger.io.resourceprovider.ReadableResourceProviderChain;
import com.helger.peppol.security.PeppolTrustStores;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class SMPClientConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPClientConfiguration.class);
    private static final IConfigWithFallback DEFAULT_CONFIG;
    private static final SimpleReadWriteLock RW_LOCK;
    @GuardedBy(value="RW_LOCK")
    private static IConfigWithFallback s_aConfig;

    @Nonnull
    public static MultiConfigurationValueProvider createSMPClientValueProvider() {
        MultiConfigurationValueProvider multiConfigurationValueProvider = ConfigFactory.createDefaultValueProvider();
        ReadableResourceProviderChain readableResourceProviderChain = ConfigFactory.createDefaultResourceProviderChain();
        int n = ConfigFactory.APPLICATION_PROPERTIES_PRIORITY;
        IReadableResource iReadableResource = readableResourceProviderChain.getReadableResourceIf("private-smp-client.properties", IResourceBase::exists);
        if (iReadableResource != null) {
            LOGGER.warn("The support for the properties file 'private-smp-client.properties' is deprecated. Place the properties in 'application.properties' instead.");
            multiConfigurationValueProvider.addConfigurationSource((IConfigurationValueProvider)new ConfigurationSourceProperties(iReadableResource, StandardCharsets.UTF_8), n - 1);
        }
        if ((iReadableResource = readableResourceProviderChain.getReadableResourceIf("smp-client.properties", IResourceBase::exists)) != null) {
            LOGGER.warn("The support for the properties file 'smp-client.properties' is deprecated. Place the properties in 'application.properties' instead.");
            multiConfigurationValueProvider.addConfigurationSource((IConfigurationValueProvider)new ConfigurationSourceProperties(iReadableResource, StandardCharsets.UTF_8), n - 2);
        }
        return multiConfigurationValueProvider;
    }

    private SMPClientConfiguration() {
    }

    @Nonnull
    public static IConfigWithFallback getConfig() {
        RW_LOCK.readLock().lock();
        try {
            IConfigWithFallback iConfigWithFallback = s_aConfig;
            return iConfigWithFallback;
        }
        finally {
            RW_LOCK.readLock().unlock();
        }
    }

    @Nonnull
    public static IConfigWithFallback setConfig(@Nonnull IConfigWithFallback iConfigWithFallback) {
        IConfigWithFallback iConfigWithFallback2;
        ValueEnforcer.notNull((Object)iConfigWithFallback, (String)"NewConfig");
        RW_LOCK.writeLock().lock();
        try {
            iConfigWithFallback2 = s_aConfig;
            s_aConfig = iConfigWithFallback;
        }
        finally {
            RW_LOCK.writeLock().unlock();
        }
        if (!EqualsHelper.identityEqual((Object)iConfigWithFallback2, (Object)iConfigWithFallback)) {
            LOGGER.info("The SMPClient configuration provider was changed to " + String.valueOf(iConfigWithFallback));
        }
        return iConfigWithFallback2;
    }

    @Nonnull
    public static EKeyStoreType getTrustStoreType() {
        String string = SMPClientConfiguration.getConfig().getAsStringOrFallback("smpclient.truststore.type", new String[]{"truststore.type"});
        return EKeyStoreType.getFromIDCaseInsensitiveOrDefault((String)string, (EKeyStoreType)PeppolTrustStores.Config2018.TRUSTSTORE_TYPE);
    }

    @Nonnull
    public static String getTrustStorePath() {
        return SMPClientConfiguration.getConfig().getAsStringOrFallback("smpclient.truststore.path", new String[]{"truststore.path", "truststore.location"});
    }

    @Nonnull
    public static char[] getTrustStorePasswordCharArray() {
        return SMPClientConfiguration.getConfig().getAsCharArrayOrFallback("smpclient.truststore.password", new String[]{"truststore.password"});
    }

    @Nullable
    public static KeyStore loadTrustStore() {
        try {
            return KeyStoreHelper.loadKeyStoreDirect((IKeyStoreType)SMPClientConfiguration.getTrustStoreType(), (String)SMPClientConfiguration.getTrustStorePath(), (char[])SMPClientConfiguration.getTrustStorePasswordCharArray());
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to load SMP client truststore: " + exception.getClass().getName() + " - " + exception.getMessage());
            return null;
        }
    }

    @Nullable
    public static HttpHost getHttpProxy() {
        String string = SMPClientConfiguration.getConfig().getAsStringOrFallback("http.proxy.host", new String[]{"http.proxyHost"});
        int n = SMPClientConfiguration.getConfig().getAsIntOrFallback("http.proxy.port", -1, 0, new String[]{"http.proxyPort"});
        if (string != null && n > 0) {
            return new HttpHost(string, n);
        }
        return null;
    }

    @Nullable
    public static UsernamePasswordCredentials getHttpProxyCredentials() {
        String string = SMPClientConfiguration.getConfig().getAsStringOrFallback("http.proxy.username", new String[]{"http.proxyUsername"});
        String string2 = SMPClientConfiguration.getConfig().getAsStringOrFallback("http.proxy.password", new String[]{"http.proxyPassword"});
        if (string != null && string2 != null) {
            return new UsernamePasswordCredentials(string, string2.toCharArray());
        }
        return null;
    }

    @Nullable
    public static String getNonProxyHosts() {
        return SMPClientConfiguration.getConfig().getAsStringOrFallback("http.proxy.nonProxyHosts", new String[]{"http.nonProxyHosts"});
    }

    public static boolean isUseDNSClientCache() {
        return SMPClientConfiguration.getConfig().getAsBoolean((Object)"http.useDNSClientCache", true);
    }

    @Nonnull
    public static Timeout getConnectTimeout() {
        long l = SMPClientConfiguration.getConfig().getAsLong((Object)"http.connect.timeout.ms", -1L);
        if (l >= 0L) {
            return Timeout.ofMilliseconds((long)l);
        }
        return HttpClientSettings.DEFAULT_CONNECT_TIMEOUT;
    }

    @Nonnull
    public static Timeout getResponseTimeout() {
        long l = SMPClientConfiguration.getConfig().getAsLongOrFallback("http.response.timeout.ms", -1L, -1L, new String[]{"http.request.timeout.ms"});
        if (l >= 0L) {
            return Timeout.ofMilliseconds((long)l);
        }
        return HttpClientSettings.DEFAULT_RESPONSE_TIMEOUT;
    }

    static {
        if (StringHelper.isNotEmpty((String)SystemProperties.getPropertyValueOrNull((String)"peppol.smp.client.properties.path"))) {
            throw new InitializationException("The system property 'peppol.smp.client.properties.path' is no longer supported. See https://github.com/phax/ph-commons#ph-config for alternatives. Consider using the system property 'config.file' instead.");
        }
        if (StringHelper.isNotEmpty((String)SystemProperties.getPropertyValueOrNull((String)"smp.client.properties.path"))) {
            throw new InitializationException("The system property 'smp.client.properties.path' is no longer supported. See https://github.com/phax/ph-commons#ph-config for alternatives. Consider using the system property 'config.file' instead.");
        }
        if (StringHelper.isNotEmpty((String)System.getenv().get("SMP_CLIENT_CONFIG"))) {
            throw new InitializationException("The environment variable 'SMP_CLIENT_CONFIG' is no longer supported. See https://github.com/phax/ph-commons#ph-config for alternatives. Consider using the environment variable 'CONFIG_FILE' instead.");
        }
        DEFAULT_CONFIG = new ConfigWithFallback((IConfigurationValueProvider)SMPClientConfiguration.createSMPClientValueProvider());
        RW_LOCK = new SimpleReadWriteLock();
        s_aConfig = DEFAULT_CONFIG;
    }
}

