/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.httpclient;

import com.helger.annotation.WillNotClose;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.ESuccess;
import com.helger.jaxb.GenericJAXBMarshaller;
import com.helger.smpclient.exception.SMPClientBadResponseException;
import com.helger.smpclient.httpclient.AbstractSMPResponseHandler;
import com.helger.smpclient.security.TrustStoreBasedX509KeySelector;
import com.helger.xml.serialize.read.DOMReader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.apache.hc.core5.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SMPHttpResponseHandlerSigned<T>
extends AbstractSMPResponseHandler<T> {
    public static final boolean DEFAULT_VERIFY_SIGNATURE = true;
    public static final boolean DEFAULT_SECURE_VALIDATION = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPHttpResponseHandlerSigned.class);
    private final GenericJAXBMarshaller<T> m_aMarshaller;
    private boolean m_bVerifySignature = true;
    private boolean m_bSecureValidation = true;
    private KeyStore m_aTrustStore;

    public SMPHttpResponseHandlerSigned(@Nonnull GenericJAXBMarshaller<T> genericJAXBMarshaller, @Nullable KeyStore keyStore) {
        this.m_aMarshaller = (GenericJAXBMarshaller)ValueEnforcer.notNull(genericJAXBMarshaller, (String)"Marshaller");
        this.m_aTrustStore = keyStore;
    }

    public final boolean isVerifySignature() {
        return this.m_bVerifySignature;
    }

    @Nonnull
    public final SMPHttpResponseHandlerSigned<T> setVerifySignature(boolean bl) {
        this.m_bVerifySignature = bl;
        return this;
    }

    public final boolean isSecureValidation() {
        return this.m_bSecureValidation;
    }

    @Nonnull
    public final SMPHttpResponseHandlerSigned<T> setSecureValidation(boolean bl) {
        this.m_bSecureValidation = bl;
        return this;
    }

    @Nullable
    public final KeyStore getTrustStore() {
        return this.m_aTrustStore;
    }

    @Nonnull
    public final SMPHttpResponseHandlerSigned<T> setTrustStore(@Nullable KeyStore keyStore) {
        this.m_aTrustStore = keyStore;
        return this;
    }

    @Nonnull
    public static ESuccess checkSignature(@Nonnull Document document, @Nonnull KeySelector keySelector, boolean bl) throws MarshalException, XMLSignatureException {
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new IllegalArgumentException("Element <Signature> not found in SMP XML response");
        }
        int n = nodeList.getLength();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found " + n + " <Signature> " + (n == 1 ? "element" : "elements") + " to verify, using " + (bl ? "secure" : "regular") + " validation");
        }
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        ESuccess eSuccess = ESuccess.SUCCESS;
        for (int i = 0; i < n; ++i) {
            DOMValidateContext dOMValidateContext = new DOMValidateContext(keySelector, nodeList.item(i));
            dOMValidateContext.setProperty("org.jcp.xml.dsig.secureValidation", bl);
            String string = i + 1 + "/" + n;
            XMLSignature xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext);
            boolean bl2 = xMLSignature.validate(dOMValidateContext);
            if (bl2) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Signature[" + string + "] validation was successful");
                continue;
            }
            eSuccess = ESuccess.FAILURE;
            LOGGER.warn("Signature[" + string + "] failed core validation");
            boolean bl3 = xMLSignature.getSignatureValue().validate(dOMValidateContext);
            if (bl3) {
                LOGGER.info("  Signature[" + string + "] SignatureValue validity status: valid");
            } else {
                LOGGER.warn("  Signature[" + string + "] SignatureValue validity status: NOT valid!");
            }
            List<Reference> list = xMLSignature.getSignedInfo().getReferences();
            int n2 = list.size();
            int n3 = 0;
            Iterator<Reference> iterator = list.iterator();
            while (iterator.hasNext()) {
                boolean bl4;
                String string2 = n3 + 1 + "/" + n2;
                Reference reference = iterator.next();
                if (reference.getTransforms().size() != 1) {
                    LOGGER.warn("  Signature[" + string + "] Reference[" + string2 + "] has an invalid number of Transforms. Expected 1 but having " + reference.getTransforms().size());
                }
                if (bl4 = reference.validate(dOMValidateContext)) {
                    LOGGER.info("  Signature[" + string + "] Reference[" + string2 + "] validity status: valid");
                } else {
                    LOGGER.warn("  Signature[" + string + "] Reference[" + string2 + "] validity status: NOT valid!");
                }
                ++n3;
            }
        }
        return eSuccess;
    }

    @Nonnull
    private static ESuccess _checkSignature(@Nonnull @WillNotClose InputStream inputStream, @Nonnull KeyStore keyStore, boolean bl) throws MarshalException, XMLSignatureException {
        Document document = DOMReader.readXMLDOM((InputStream)inputStream);
        if (document == null) {
            throw new IllegalArgumentException("The SMP response is not XML");
        }
        TrustStoreBasedX509KeySelector trustStoreBasedX509KeySelector = new TrustStoreBasedX509KeySelector(keyStore);
        return SMPHttpResponseHandlerSigned.checkSignature(document, trustStoreBasedX509KeySelector, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public T handleEntity(@Nonnull HttpEntity httpEntity) throws SMPClientBadResponseException, IOException {
        Object object;
        byte[] byArray;
        block16: {
            byArray = StreamHelper.getAllBytes((InputStream)httpEntity.getContent());
            if (ArrayHelper.isEmpty((byte[])byArray)) {
                throw new SMPClientBadResponseException("SMP server response content is empty/could not be read");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Signed SMP response has " + byArray.length + " bytes");
            }
            if (this.m_bVerifySignature) {
                if (this.m_aTrustStore == null) {
                    throw new SMPClientBadResponseException("No trust store was configured - cannot verify signatures");
                }
                try {
                    object = new NonBlockingByteArrayInputStream(byArray);
                    try {
                        if (SMPHttpResponseHandlerSigned._checkSignature((InputStream)object, this.m_aTrustStore, this.m_bSecureValidation).isFailure()) {
                            String string;
                            if (this.m_bSecureValidation) {
                                string = "secure";
                                throw new SMPClientBadResponseException("Signature returned from SMP server was not valid with " + string + " validation");
                            }
                            string = "regular";
                            throw new SMPClientBadResponseException("Signature returned from SMP server was not valid with " + string + " validation");
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Successfully verified signature of signed SMP response");
                        }
                        break block16;
                    }
                    finally {
                        ((InputStream)object).close();
                    }
                }
                catch (SMPClientBadResponseException sMPClientBadResponseException) {
                    throw sMPClientBadResponseException;
                }
                catch (Exception exception) {
                    throw new SMPClientBadResponseException("Error in validating signature returned from SMP server", exception);
                }
            }
            LOGGER.warn("SMP response signature verification is disabled. This should not happen in production systems!");
        }
        object = this.m_aMarshaller.read(byArray);
        if (object == null) {
            throw new SMPClientBadResponseException("Malformed XML document returned from SMP server");
        }
        if (!LOGGER.isDebugEnabled()) return (T)object;
        LOGGER.debug("Successfully parsed signed SMP HTTP response");
        return (T)object;
    }
}

