/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.json;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.codec.base64.Base64;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.trait.IAddableByTrait;
import com.helger.datetime.helper.PDTFactory;
import com.helger.datetime.rt.OffsetDate;
import com.helger.datetime.xml.XMLOffsetDate;
import com.helger.datetime.xml.XMLOffsetDateTime;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.json.JsonValue;
import com.helger.peppol.sml.ESMPAPIType;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.extension.SMPExtensionList;
import com.helger.smpclient.peppol.utils.SMPExtensionConverter;
import com.helger.smpclient.peppol.utils.W3CEndpointReferenceHelper;
import com.helger.xsds.bdxr.smp1.ProcessIdentifierType;
import com.helger.xsds.bdxr.smp1.RedirectType;
import com.helger.xsds.bdxr.smp1.ServiceInformationType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataType;
import com.helger.xsds.bdxr.smp2.ac.CertificateType;
import com.helger.xsds.bdxr.smp2.ac.ProcessMetadataType;
import com.helger.xsds.peppol.smp1.EndpointType;
import com.helger.xsds.peppol.smp1.ProcessType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;

@Immutable
public final class SMPJsonResponse {
    public static final String JSON_SMPTYPE = "smptype";
    public static final String JSON_PARTICIPANT_ID = "participantID";
    public static final String JSON_HREF = "href";
    public static final String JSON_DOCUMENT_TYPE_ID = "documentTypeID";
    public static final String JSON_ERROR = "error";
    public static final String JSON_URLS = "urls";
    public static final String JSON_CERTIFICATE_UID = "certificateUID";
    public static final String JSON_REDIRECT = "redirect";
    public static final String JSON_PROCESS_ID = "processID";
    public static final String JSON_TRANSPORT_PROFILE = "transportProfile";
    public static final String JSON_ENDPOINT_REFERENCE = "endpointReference";
    public static final String JSON_REQUIRE_BUSINESS_LEVEL_SIGNATURE = "requireBusinessLevelSignature";
    public static final String JSON_MINIMUM_AUTHENTICATION_LEVEL = "minimumAuthenticationLevel";
    public static final String JSON_SERVICE_ACTIVATION_DATE = "serviceActivationDate";
    public static final String JSON_SERVICE_EXPIRATION_DATE = "serviceExpirationDate";
    public static final String JSON_CERTIFICATE = "certificate";
    public static final String JSON_CERTIFICATE_DETAILS = "certificateDetails";
    public static final String JSON_SERVICE_DESCRIPTION = "serviceDescription";
    public static final String JSON_TECHNICAL_CONTACT_URL = "technicalContactUrl";
    public static final String JSON_TECHNICAL_INFORMATION_URL = "technicalInformationUrl";
    public static final String JSON_ENDPOINTS = "endpoints";
    public static final String JSON_PROCESSES = "processes";
    public static final String JSON_EXTENSION = "extension";
    public static final String JSON_SERVICEINFO = "serviceinfo";

    private SMPJsonResponse() {
    }

    @Nonnull
    public static IJsonObject convert(@Nonnull ESMPAPIType eSMPAPIType, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull Map<String, String> map, @Nonnull IIdentifierFactory iIdentifierFactory) {
        ValueEnforcer.notNull((Object)eSMPAPIType, (String)"SMPAPIType");
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notNull(map, (String)"SGHrefs");
        ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"IF");
        JsonObject jsonObject = new JsonObject();
        jsonObject.add((Object)JSON_SMPTYPE, (Object)eSMPAPIType.getID());
        jsonObject.add((Object)JSON_PARTICIPANT_ID, (Object)iParticipantIdentifier.getURIEncoded());
        String string = "/" + iParticipantIdentifier.getURIEncoded() + "/services/";
        JsonArray jsonArray = new JsonArray();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            IJsonObject iJsonObject = (IJsonObject)new JsonObject().add((Object)JSON_HREF, (Object)string3);
            int n = string2.toLowerCase(Locale.US).indexOf(string.toLowerCase(Locale.US));
            if (n >= 0) {
                String string4 = string2.substring(n + string.length());
                iJsonObject.add((Object)JSON_DOCUMENT_TYPE_ID, (Object)string4);
                IDocumentTypeIdentifier iDocumentTypeIdentifier = iIdentifierFactory.parseDocumentTypeIdentifier(string4);
                if (iDocumentTypeIdentifier == null) {
                    iJsonObject.add((Object)JSON_ERROR, (Object)"The document type ID could not be interpreted as a structured document type!");
                }
            } else {
                iJsonObject.add((Object)JSON_ERROR, (Object)("Contained href does not match the rules. Expected path part: '" + string + "'"));
            }
            jsonArray.add((IAddableByTrait)iJsonObject);
        }
        jsonObject.add((Object)JSON_URLS, (IAddableByTrait)jsonArray);
        return jsonObject;
    }

    @Nonnull
    public static IJsonObject getJsonPrincipal(@Nonnull X500Principal x500Principal) {
        ValueEnforcer.notNull((Object)x500Principal, (String)"Principal");
        JsonObject jsonObject = new JsonObject();
        jsonObject.add((Object)"name", (Object)x500Principal.getName());
        try {
            for (Rdn rdn : new LdapName(x500Principal.getName()).getRdns()) {
                jsonObject.add((Object)rdn.getType(), rdn.getValue());
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return jsonObject;
    }

    @Nullable
    public static String getLD(@Nullable OffsetDate offsetDate) {
        return offsetDate == null ? null : DateTimeFormatter.ISO_LOCAL_DATE.format((TemporalAccessor)offsetDate);
    }

    @Nullable
    public static String getLD(@Nullable XMLOffsetDate xMLOffsetDate) {
        return xMLOffsetDate == null ? null : DateTimeFormatter.ISO_LOCAL_DATE.format((TemporalAccessor)xMLOffsetDate);
    }

    @Nullable
    public static String getLDT(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(offsetDateTime);
    }

    @Nullable
    public static String getLDT(@Nullable XMLOffsetDateTime xMLOffsetDateTime) {
        return xMLOffsetDateTime == null ? null : DateTimeFormatter.ISO_LOCAL_DATE_TIME.format((TemporalAccessor)xMLOffsetDateTime);
    }

    public static void convertCertificate(@Nonnull IJsonObject iJsonObject, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iJsonObject, (String)"Target");
        ValueEnforcer.notNull((Object)string, (String)"Cert");
        iJsonObject.add((Object)JSON_CERTIFICATE, (Object)string);
        X509Certificate x509Certificate = CertificateHelper.convertStringToCertficateOrNull((String)string);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add((Object)"parsable", x509Certificate != null);
        if (x509Certificate != null) {
            jsonObject.add((Object)"subject", (IAddableByTrait)SMPJsonResponse.getJsonPrincipal(x509Certificate.getSubjectX500Principal()));
            jsonObject.add((Object)"issuer", (IAddableByTrait)SMPJsonResponse.getJsonPrincipal(x509Certificate.getIssuerX500Principal()));
            jsonObject.add((Object)"serial10", (Object)x509Certificate.getSerialNumber());
            jsonObject.add((Object)"serial16", (Object)x509Certificate.getSerialNumber().toString(16));
            jsonObject.addIfNotNull((Object)"notBefore", (Object)SMPJsonResponse.getLDT(PDTFactory.createOffsetDateTime((Date)x509Certificate.getNotBefore())));
            jsonObject.addIfNotNull((Object)"notAfter", (Object)SMPJsonResponse.getLDT(PDTFactory.createOffsetDateTime((Date)x509Certificate.getNotAfter())));
            jsonObject.add((Object)"validByDate", CertificateHelper.isCertificateValidPerNow((X509Certificate)x509Certificate));
            jsonObject.add((Object)"sigAlgName", (Object)x509Certificate.getSigAlgName());
        }
        iJsonObject.add((Object)JSON_CERTIFICATE_DETAILS, (IAddableByTrait)jsonObject);
    }

    @Nonnull
    public static IJsonObject convertEndpoint(@Nonnull EndpointType endpointType) {
        String string = endpointType.getEndpointReference() == null ? null : W3CEndpointReferenceHelper.getAddress(endpointType.getEndpointReference());
        IJsonObject iJsonObject = (IJsonObject)((IJsonObject)((IJsonObject)((IJsonObject)new JsonObject().add((Object)JSON_TRANSPORT_PROFILE, (Object)endpointType.getTransportProfile())).add((Object)JSON_ENDPOINT_REFERENCE, (Object)string)).add((Object)JSON_REQUIRE_BUSINESS_LEVEL_SIGNATURE, endpointType.isRequireBusinessLevelSignature())).add((Object)JSON_MINIMUM_AUTHENTICATION_LEVEL, (Object)endpointType.getMinimumAuthenticationLevel());
        iJsonObject.addIfNotNull((Object)JSON_SERVICE_ACTIVATION_DATE, (Object)SMPJsonResponse.getLDT(endpointType.getServiceActivationDate()));
        iJsonObject.addIfNotNull((Object)JSON_SERVICE_EXPIRATION_DATE, (Object)SMPJsonResponse.getLDT(endpointType.getServiceExpirationDate()));
        SMPJsonResponse.convertCertificate(iJsonObject, endpointType.getCertificate());
        ((IJsonObject)((IJsonObject)((IJsonObject)iJsonObject.add((Object)JSON_SERVICE_DESCRIPTION, (Object)endpointType.getServiceDescription())).add((Object)JSON_TECHNICAL_CONTACT_URL, (Object)endpointType.getTechnicalContactUrl())).add((Object)JSON_TECHNICAL_INFORMATION_URL, (Object)endpointType.getTechnicalInformationUrl())).add((Object)JSON_EXTENSION, (Object)SMPExtensionConverter.convertToString(endpointType.getExtension()));
        return iJsonObject;
    }

    @Nonnull
    public static IJsonObject convert(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull com.helger.xsds.peppol.smp1.ServiceMetadataType serviceMetadataType) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocTypeID");
        ValueEnforcer.notNull((Object)serviceMetadataType, (String)"SM");
        JsonObject jsonObject = new JsonObject();
        jsonObject.add((Object)JSON_SMPTYPE, (Object)ESMPAPIType.PEPPOL.getID());
        jsonObject.add((Object)JSON_PARTICIPANT_ID, (Object)iParticipantIdentifier.getURIEncoded());
        jsonObject.add((Object)JSON_DOCUMENT_TYPE_ID, (Object)iDocumentTypeIdentifier.getURIEncoded());
        com.helger.xsds.peppol.smp1.RedirectType redirectType = serviceMetadataType.getRedirect();
        if (redirectType != null) {
            IJsonObject iJsonObject = (IJsonObject)((IJsonObject)((IJsonObject)new JsonObject().add((Object)JSON_HREF, (Object)redirectType.getHref())).add((Object)JSON_CERTIFICATE_UID, (Object)redirectType.getCertificateUID())).add((Object)JSON_EXTENSION, (Object)SMPExtensionConverter.convertToString(redirectType.getExtension()));
            jsonObject.add((Object)JSON_REDIRECT, (IAddableByTrait)iJsonObject);
        } else {
            com.helger.xsds.peppol.smp1.ServiceInformationType serviceInformationType = serviceMetadataType.getServiceInformation();
            JsonObject jsonObject2 = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            if (serviceInformationType.getProcessList() != null) {
                for (ProcessType processType : serviceInformationType.getProcessList().getProcess()) {
                    if (processType.getProcessIdentifier() == null) continue;
                    IJsonObject iJsonObject = (IJsonObject)new JsonObject().add((Object)JSON_PROCESS_ID, (Object)CIdentifier.getURIEncoded((com.helger.xsds.peppol.id1.ProcessIdentifierType)processType.getProcessIdentifier()));
                    JsonArray jsonArray2 = new JsonArray();
                    if (processType.getServiceEndpointList() != null) {
                        for (EndpointType endpointType : processType.getServiceEndpointList().getEndpoint()) {
                            jsonArray2.add((IAddableByTrait)SMPJsonResponse.convertEndpoint(endpointType));
                        }
                    }
                    ((IJsonObject)iJsonObject.add((Object)JSON_ENDPOINTS, (IAddableByTrait)jsonArray2)).add((Object)JSON_EXTENSION, (Object)SMPExtensionConverter.convertToString(processType.getExtension()));
                    jsonArray.add((IAddableByTrait)iJsonObject);
                }
            }
            ((IJsonObject)jsonObject2.add((Object)JSON_PROCESSES, (IAddableByTrait)jsonArray)).add((Object)JSON_EXTENSION, (Object)SMPExtensionConverter.convertToString(serviceInformationType.getExtension()));
            jsonObject.add((Object)JSON_SERVICEINFO, (IAddableByTrait)jsonObject2);
        }
        return jsonObject;
    }

    @Nonnull
    public static IJsonObject convertEndpoint(@Nonnull com.helger.xsds.bdxr.smp1.EndpointType endpointType) {
        IJsonObject iJsonObject = (IJsonObject)((IJsonObject)((IJsonObject)((IJsonObject)new JsonObject().add((Object)JSON_TRANSPORT_PROFILE, (Object)endpointType.getTransportProfile())).add((Object)JSON_ENDPOINT_REFERENCE, (Object)endpointType.getEndpointURI())).add((Object)JSON_REQUIRE_BUSINESS_LEVEL_SIGNATURE, (Object)endpointType.isRequireBusinessLevelSignature())).add((Object)JSON_MINIMUM_AUTHENTICATION_LEVEL, (Object)endpointType.getMinimumAuthenticationLevel());
        iJsonObject.addIfNotNull((Object)JSON_SERVICE_ACTIVATION_DATE, (Object)SMPJsonResponse.getLDT(endpointType.getServiceActivationDate()));
        iJsonObject.addIfNotNull((Object)JSON_SERVICE_EXPIRATION_DATE, (Object)SMPJsonResponse.getLDT(endpointType.getServiceExpirationDate()));
        SMPJsonResponse.convertCertificate(iJsonObject, Base64.encodeBytes((byte[])endpointType.getCertificate()));
        ((IJsonObject)((IJsonObject)iJsonObject.add((Object)JSON_SERVICE_DESCRIPTION, (Object)endpointType.getServiceDescription())).add((Object)JSON_TECHNICAL_CONTACT_URL, (Object)endpointType.getTechnicalContactUrl())).add((Object)JSON_TECHNICAL_INFORMATION_URL, (Object)endpointType.getTechnicalInformationUrl());
        SMPExtensionList sMPExtensionList = SMPExtensionList.ofBDXR1(endpointType.getExtension());
        if (sMPExtensionList != null) {
            iJsonObject.addIfNotNull((Object)JSON_EXTENSION, (Object)sMPExtensionList.getExtensionsAsJsonString());
        }
        return iJsonObject;
    }

    @Nonnull
    public static IJsonObject convert(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull ServiceMetadataType serviceMetadataType) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocTypeID");
        ValueEnforcer.notNull((Object)serviceMetadataType, (String)"SM");
        JsonObject jsonObject = new JsonObject();
        jsonObject.add((Object)JSON_SMPTYPE, (Object)ESMPAPIType.OASIS_BDXR_V1.getID());
        jsonObject.add((Object)JSON_PARTICIPANT_ID, (Object)iParticipantIdentifier.getURIEncoded());
        jsonObject.add((Object)JSON_DOCUMENT_TYPE_ID, (Object)iDocumentTypeIdentifier.getURIEncoded());
        RedirectType redirectType = serviceMetadataType.getRedirect();
        if (redirectType != null) {
            IJsonObject iJsonObject = (IJsonObject)((IJsonObject)new JsonObject().add((Object)JSON_HREF, (Object)redirectType.getHref())).add((Object)JSON_CERTIFICATE_UID, (Object)redirectType.getCertificateUID());
            SMPExtensionList sMPExtensionList = SMPExtensionList.ofBDXR1(redirectType.getExtension());
            if (sMPExtensionList != null) {
                iJsonObject.addIfNotNull((Object)JSON_EXTENSION, (Object)sMPExtensionList.getExtensionsAsJsonString());
            }
            jsonObject.add((Object)JSON_REDIRECT, (IAddableByTrait)iJsonObject);
        } else {
            ServiceInformationType serviceInformationType = serviceMetadataType.getServiceInformation();
            JsonObject jsonObject2 = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            if (serviceInformationType.getProcessList() != null) {
                for (com.helger.xsds.bdxr.smp1.ProcessType processType : serviceInformationType.getProcessList().getProcess()) {
                    if (processType.getProcessIdentifier() == null) continue;
                    IJsonObject iJsonObject = (IJsonObject)new JsonObject().add((Object)JSON_PROCESS_ID, (Object)CIdentifier.getURIEncoded((ProcessIdentifierType)processType.getProcessIdentifier()));
                    JsonArray jsonArray2 = new JsonArray();
                    if (processType.getServiceEndpointList() != null) {
                        for (com.helger.xsds.bdxr.smp1.EndpointType endpointType : processType.getServiceEndpointList().getEndpoint()) {
                            jsonArray2.add((IAddableByTrait)SMPJsonResponse.convertEndpoint(endpointType));
                        }
                    }
                    iJsonObject.add((Object)JSON_ENDPOINTS, (IAddableByTrait)jsonArray2);
                    SMPExtensionList sMPExtensionList = SMPExtensionList.ofBDXR1(processType.getExtension());
                    if (sMPExtensionList != null) {
                        iJsonObject.addIfNotNull((Object)JSON_EXTENSION, (Object)sMPExtensionList.getExtensionsAsJsonString());
                    }
                    jsonArray.add((IAddableByTrait)iJsonObject);
                }
            }
            jsonObject2.add((Object)JSON_PROCESSES, (IAddableByTrait)jsonArray);
            SMPExtensionList sMPExtensionList = SMPExtensionList.ofBDXR1(serviceInformationType.getExtension());
            if (sMPExtensionList != null) {
                jsonObject2.addIfNotNull((Object)JSON_EXTENSION, (Object)sMPExtensionList.getExtensionsAsJsonString());
            }
            jsonObject.add((Object)JSON_SERVICEINFO, (IAddableByTrait)jsonObject2);
        }
        return jsonObject;
    }

    @Nonnull
    public static IJsonObject convertEndpoint(@Nonnull com.helger.xsds.bdxr.smp2.ac.EndpointType endpointType) {
        JsonObject jsonObject = new JsonObject();
        ((IJsonObject)((IJsonObject)((IJsonObject)((IJsonObject)((IJsonObject)jsonObject.addIfNotNull((Object)JSON_TRANSPORT_PROFILE, (Object)endpointType.getTransportProfileIDValue())).addIfNotNull((Object)JSON_SERVICE_DESCRIPTION, (Object)endpointType.getDescription())).addIfNotNull((Object)JSON_TECHNICAL_CONTACT_URL, (Object)endpointType.getContactValue())).addIfNotNull((Object)JSON_ENDPOINT_REFERENCE, (Object)endpointType.getAddressURIValue())).addIfNotNull((Object)JSON_SERVICE_ACTIVATION_DATE, (Object)SMPJsonResponse.getLD(endpointType.getActivationDateValue()))).addIfNotNull((Object)JSON_SERVICE_EXPIRATION_DATE, (Object)SMPJsonResponse.getLD(endpointType.getExpirationDateValue()));
        JsonArray jsonArray = new JsonArray();
        for (CertificateType certificateType : endpointType.getCertificate()) {
            JsonObject jsonObject2 = new JsonObject();
            SMPJsonResponse.convertCertificate((IJsonObject)jsonObject2, Base64.encodeBytes((byte[])certificateType.getContentBinaryObjectValue()));
            jsonArray.add((IAddableByTrait)jsonObject2);
        }
        jsonObject.add((Object)"certificates", (IAddableByTrait)jsonArray);
        SMPExtensionList sMPExtensionList = SMPExtensionList.ofBDXR2(endpointType.getSMPExtensions());
        if (sMPExtensionList != null) {
            jsonObject.addIfNotNull((Object)JSON_EXTENSION, (Object)sMPExtensionList.getExtensionsAsJsonString());
        }
        return jsonObject;
    }

    @Nonnull
    public static IJsonObject convert(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull com.helger.xsds.bdxr.smp2.ServiceMetadataType serviceMetadataType) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocTypeID");
        ValueEnforcer.notNull((Object)serviceMetadataType, (String)"SM");
        JsonObject jsonObject = new JsonObject();
        jsonObject.add((Object)JSON_SMPTYPE, (Object)ESMPAPIType.OASIS_BDXR_V2.getID());
        jsonObject.add((Object)JSON_PARTICIPANT_ID, (Object)iParticipantIdentifier.getURIEncoded());
        jsonObject.add((Object)JSON_DOCUMENT_TYPE_ID, (Object)iDocumentTypeIdentifier.getURIEncoded());
        for (ProcessMetadataType processMetadataType : serviceMetadataType.getProcessMetadata()) {
            JsonArray jsonArray;
            Object object;
            Object object22;
            JsonObject jsonObject2 = new JsonObject();
            SMPExtensionList sMPExtensionList = SMPExtensionList.ofBDXR2(processMetadataType.getSMPExtensions());
            if (sMPExtensionList != null) {
                jsonObject2.addIfNotNull((Object)JSON_EXTENSION, (Object)sMPExtensionList.getExtensionsAsJsonString());
            }
            sMPExtensionList = new JsonArray();
            for (Object object22 : processMetadataType.getProcess()) {
                SMPExtensionList sMPExtensionList2;
                object = (IJsonObject)new JsonObject().add((Object)"id", (Object)CIdentifier.getURIEncodedBDXR2((String)object22.getID().getSchemeID(), (String)object22.getID().getValue()));
                if (object22.hasRoleIDEntries()) {
                    object.add((Object)"roleids", (IAddableByTrait)((IJson)new JsonArray().addAllMapped((Iterable)object22.getRoleID(), roleIDType -> JsonValue.create((Object)CIdentifier.getURIEncodedBDXR2((String)roleIDType.getSchemeID(), (String)roleIDType.getValue())))));
                }
                if ((sMPExtensionList2 = SMPExtensionList.ofBDXR2(object22.getSMPExtensions())) != null) {
                    object.addIfNotNull((Object)JSON_EXTENSION, (Object)sMPExtensionList2.getExtensionsAsJsonString());
                }
                sMPExtensionList.add((IAddableByTrait)object);
            }
            jsonObject2.add((Object)JSON_PROCESSES, (IAddableByTrait)sMPExtensionList);
            sMPExtensionList = processMetadataType.getRedirect();
            if (sMPExtensionList != null) {
                jsonArray = (IJsonObject)new JsonObject().add((Object)JSON_HREF, (Object)sMPExtensionList.getPublisherURIValue());
                object22 = new JsonArray();
                for (SMPExtensionList sMPExtensionList2 : sMPExtensionList.getCertificate()) {
                    JsonObject jsonObject3 = new JsonObject();
                    SMPJsonResponse.convertCertificate((IJsonObject)jsonObject3, Base64.encodeBytes((byte[])sMPExtensionList2.getContentBinaryObjectValue()));
                    object22.add((IAddableByTrait)jsonObject3);
                }
                jsonArray.add((Object)"certificates", (IAddableByTrait)object22);
                object = SMPExtensionList.ofBDXR2(sMPExtensionList.getSMPExtensions());
                if (object != null) {
                    jsonArray.addIfNotNull((Object)JSON_EXTENSION, (Object)((SMPExtensionList)object).getExtensionsAsJsonString());
                }
                jsonObject2.add((Object)JSON_REDIRECT, (IAddableByTrait)jsonArray);
                continue;
            }
            jsonArray = new JsonArray();
            object22 = processMetadataType.getEndpoint().iterator();
            while (object22.hasNext()) {
                object = (com.helger.xsds.bdxr.smp2.ac.EndpointType)object22.next();
                jsonArray.add((IAddableByTrait)SMPJsonResponse.convertEndpoint((com.helger.xsds.bdxr.smp2.ac.EndpointType)object));
            }
            jsonObject2.add((Object)JSON_ENDPOINTS, (IAddableByTrait)jsonArray);
        }
        SMPExtensionList sMPExtensionList = SMPExtensionList.ofBDXR2(serviceMetadataType.getSMPExtensions());
        if (sMPExtensionList != null) {
            jsonObject.addIfNotNull((Object)JSON_EXTENSION, (Object)sMPExtensionList.getExtensionsAsJsonString());
        }
        return jsonObject;
    }
}

