/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.peppol;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.http.basicauth.BasicAuthClientCredentials;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.simple.doctype.SimpleDocumentTypeIdentifier;
import com.helger.peppolid.simple.participant.SimpleParticipantIdentifier;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerWriteOperations;
import com.helger.smpclient.peppol.SMPClientReadOnly;
import com.helger.smpclient.peppol.marshal.SMPMarshallerServiceGroupType;
import com.helger.smpclient.peppol.marshal.SMPMarshallerServiceMetadataType;
import com.helger.smpclient.url.ISMPURLProvider;
import com.helger.smpclient.url.SMPDNSResolutionException;
import com.helger.xsds.peppol.id1.DocumentIdentifierType;
import com.helger.xsds.peppol.id1.ParticipantIdentifierType;
import com.helger.xsds.peppol.smp1.RedirectType;
import com.helger.xsds.peppol.smp1.ServiceGroupType;
import com.helger.xsds.peppol.smp1.ServiceInformationType;
import com.helger.xsds.peppol.smp1.ServiceMetadataReferenceCollectionType;
import com.helger.xsds.peppol.smp1.ServiceMetadataType;
import jakarta.annotation.Nonnull;
import java.net.URI;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPClient
extends SMPClientReadOnly {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPClient.class);

    public SMPClient(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws SMPDNSResolutionException {
        super(iSMPURLProvider, iParticipantIdentifier, iSMLInfo);
    }

    public SMPClient(@Nonnull ISMPURLProvider iSMPURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws SMPDNSResolutionException {
        super(iSMPURLProvider, iParticipantIdentifier, string);
    }

    public SMPClient(@Nonnull URI uRI) {
        super(uRI);
    }

    public void saveServiceGroup(@Nonnull ServiceGroupType serviceGroupType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)serviceGroupType, (String)"ServiceGroup");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        String string = new SMPMarshallerServiceGroupType().setUseSchema(this.isXMLSchemaValidation()).getAsString((Object)serviceGroupType);
        if (string == null) {
            throw new IllegalArgumentException("Failed to serialize ServiceGroup: " + String.valueOf(serviceGroupType));
        }
        String string2 = this.getSMPHostURI() + CIdentifier.getURIPercentEncoded((ParticipantIdentifierType)serviceGroupType.getParticipantIdentifier());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient saveServiceGroup@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", (Object)basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity((HttpEntity)new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest((HttpUriRequestBase)httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    @Nonnull
    public ServiceGroupType saveServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        ServiceGroupType serviceGroupType = new ServiceGroupType();
        serviceGroupType.setParticipantIdentifier((ParticipantIdentifierType)new SimpleParticipantIdentifier(iParticipantIdentifier));
        serviceGroupType.setServiceMetadataReferenceCollection(new ServiceMetadataReferenceCollectionType());
        this.saveServiceGroup(serviceGroupType, basicAuthClientCredentials);
        return serviceGroupType;
    }

    public void deleteServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient deleteServiceGroup@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", (Object)basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest((HttpUriRequestBase)httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }

    private void _saveServiceInformation(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull ServiceMetadataType serviceMetadataType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        String string = new SMPMarshallerServiceMetadataType().setUseSchema(this.isXMLSchemaValidation()).getAsString((Object)serviceMetadataType);
        if (string == null) {
            throw new IllegalArgumentException("Failed to serialize ServiceMetadata: " + String.valueOf(serviceMetadataType));
        }
        String string2 = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/services/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient saveServiceRegistration@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", (Object)basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity((HttpEntity)new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest((HttpUriRequestBase)httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    public void saveServiceInformation(@Nonnull ServiceInformationType serviceInformationType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)serviceInformationType, (String)"ServiceMetadata.ServiceInformation");
        ValueEnforcer.notNull((Object)serviceInformationType.getParticipantIdentifier(), (String)"ServiceMetadata.ServiceInformation.ParticipantIdentifier");
        ValueEnforcer.notNull((Object)serviceInformationType.getDocumentIdentifier(), (String)"ServiceMetadata.ServiceInformation.DocumentIdentifier");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setServiceInformation(serviceInformationType);
        this._saveServiceInformation((IParticipantIdentifier)SimpleParticipantIdentifier.wrap((ParticipantIdentifierType)serviceInformationType.getParticipantIdentifier()), (IDocumentTypeIdentifier)SimpleDocumentTypeIdentifier.wrap((DocumentIdentifierType)serviceInformationType.getDocumentIdentifier()), serviceMetadataType, basicAuthClientCredentials);
    }

    public void saveServiceRedirect(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull RedirectType redirectType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)redirectType, (String)"Redirect");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setRedirect(redirectType);
        this._saveServiceInformation(iParticipantIdentifier, iDocumentTypeIdentifier, serviceMetadataType, basicAuthClientCredentials);
    }

    public void deleteServiceRegistration(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ServiceGroupID");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)basicAuthClientCredentials, (String)"Credentials");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/services/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient deleteServiceRegistration@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", (Object)basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest((HttpUriRequestBase)httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }
}

