/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.url;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.codec.impl.Base32Codec;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.dns.naptr.NaptrLookup;
import com.helger.dns.naptr.NaptrResolver;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import com.helger.security.messagedigest.MessageDigestValue;
import com.helger.smpclient.url.SMPDNSResolutionException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.TextParseException;

@ThreadSafe
public abstract class AbstractBDXLURLProvider {
    public static final boolean DEFAULT_USE_DNS_CACHE = false;
    public static final boolean DEFAULT_NAPTR_DEBUG = false;
    public static final Charset URL_CHARSET = StandardCharsets.UTF_8;
    public static final Locale URL_LOCALE = Locale.US;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBDXLURLProvider.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bLowercaseValueBeforeHashing = true;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bAddIdentifierSchemeToZone = true;
    @GuardedBy(value="m_aRWLock")
    private String m_sNAPTRServiceName = "not-set";
    @GuardedBy(value="m_aRWLock")
    private boolean m_bUseDNSCache = false;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, String> m_aDNSCache = new CommonsHashMap();
    private final ICommonsList<InetAddress> m_aCustomDNSServers = new CommonsArrayList();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bUseNaptrDebug = false;

    public AbstractBDXLURLProvider() {
    }

    protected AbstractBDXLURLProvider(@Nonnull AbstractBDXLURLProvider abstractBDXLURLProvider) {
        this.m_bLowercaseValueBeforeHashing = abstractBDXLURLProvider.m_bLowercaseValueBeforeHashing;
        this.m_bAddIdentifierSchemeToZone = abstractBDXLURLProvider.m_bAddIdentifierSchemeToZone;
        this.m_sNAPTRServiceName = abstractBDXLURLProvider.m_sNAPTRServiceName;
        this.m_bUseDNSCache = abstractBDXLURLProvider.m_bUseDNSCache;
        this.m_aDNSCache.putAll(abstractBDXLURLProvider.m_aDNSCache);
        this.m_aCustomDNSServers.addAll(abstractBDXLURLProvider.m_aCustomDNSServers);
        this.m_bUseNaptrDebug = abstractBDXLURLProvider.m_bUseNaptrDebug;
    }

    public final boolean isLowercaseValueBeforeHashing() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bLowercaseValueBeforeHashing);
    }

    public final void setLowercaseValueBeforeHashing(boolean bl) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_bLowercaseValueBeforeHashing = bl;
        });
    }

    public final boolean isAddIdentifierSchemeToZone() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bAddIdentifierSchemeToZone);
    }

    public final void setAddIdentifierSchemeToZone(boolean bl) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_bAddIdentifierSchemeToZone = bl;
        });
    }

    @Nonnull
    @Nonempty
    public final String getNAPTRServiceName() {
        return (String)this.m_aRWLock.readLockedGet(() -> this.m_sNAPTRServiceName);
    }

    public final void setNAPTRServiceName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"NAPTRServiceName");
        this.m_aRWLock.writeLocked(() -> {
            this.m_sNAPTRServiceName = string;
        });
    }

    public final boolean isUseDNSCache() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bUseDNSCache);
    }

    public final void setUseDNSCache(boolean bl) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_bUseDNSCache = bl;
        });
    }

    public final void clearDNSCache() {
        this.m_aRWLock.writeLocked(() -> this.m_aDNSCache.clear());
    }

    @Nullable
    public final String getDNSCacheEntry(@Nullable String string) {
        return StringHelper.isNotEmpty((String)string) ? (String)this.m_aRWLock.readLockedGet(() -> (String)this.m_aDNSCache.get((Object)string)) : null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsMap<String, String> getAllDNSCacheEntries() {
        return (ICommonsMap)this.m_aRWLock.readLockedGet(() -> this.m_aDNSCache.getClone());
    }

    public final void addDNSCacheEntries(@Nullable Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            this.m_aRWLock.writeLocked(() -> this.m_aDNSCache.putAll(map));
        }
    }

    public final void addDNSCacheEntry(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        this.m_aRWLock.writeLocked(() -> this.m_aDNSCache.put((Object)string, (Object)string2));
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<InetAddress> customDNSServers() {
        return this.m_aCustomDNSServers;
    }

    public final boolean isUseNaptrDebug() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bUseNaptrDebug);
    }

    public final void setUseNaptrDebug(boolean bl) {
        this.m_aRWLock.writeLocked(() -> {
            this.m_bUseNaptrDebug = bl;
        });
    }

    @Nonnull
    public static String getHashValueStringRepresentation(@Nonnull String string) {
        byte[] byArray = MessageDigestValue.create((byte[])string.getBytes(URL_CHARSET), (EMessageDigestAlgorithm)EMessageDigestAlgorithm.SHA_256).bytes();
        return new Base32Codec().setAddPaddding(false).getEncodedAsString(byArray, StandardCharsets.ISO_8859_1).toLowerCase(Locale.US);
    }

    @Nonnull
    protected static String internalGetDNSName(@Nonnull IParticipantIdentifier iParticipantIdentifier, boolean bl, boolean bl2, @Nullable String string) {
        String string2;
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        if (StringHelper.isNotEmpty((String)string)) {
            ValueEnforcer.isTrue((boolean)StringHelper.endsWith((CharSequence)string, (char)'.'), () -> "if an SML zone name is specified, it must end with a dot (.). Value is: " + string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = string2 = bl2 ? iParticipantIdentifier.getValue() : iParticipantIdentifier.getURIEncoded();
        if (bl) {
            string2 = string2.toLowerCase(URL_LOCALE);
        }
        stringBuilder.append(AbstractBDXLURLProvider.getHashValueStringRepresentation(string2)).append('.');
        if (iParticipantIdentifier.hasScheme() && bl2) {
            string2 = iParticipantIdentifier.getScheme();
            if (bl) {
                string2 = string2.toLowerCase(URL_LOCALE);
            }
            stringBuilder.append(string2).append('.');
        }
        if (StringHelper.isNotEmpty((String)string)) {
            stringBuilder.append(string);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    @Nonnull
    public String getDNSNameOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string) throws SMPDNSResolutionException {
        return AbstractBDXLURLProvider.internalGetDNSName(iParticipantIdentifier, this.isLowercaseValueBeforeHashing(), this.isAddIdentifierSchemeToZone(), string);
    }

    @Nonnull
    public URI getSMPURIOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string) throws SMPDNSResolutionException {
        String string2;
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantIdentifier");
        if (StringHelper.isNotEmpty((String)string) && !StringHelper.endsWith((CharSequence)string, (char)'.')) {
            throw new SMPDNSResolutionException("if an SML zone name is specified, it must end with a dot (.). Value is: " + string);
        }
        String string3 = this.getDNSNameOfParticipant(iParticipantIdentifier, string);
        boolean bl = this.isUseDNSCache();
        String string4 = string2 = bl ? this.getDNSCacheEntry(string3) : null;
        if (string2 == null) {
            String string5 = this.getNAPTRServiceName();
            try {
                string2 = NaptrResolver.builder().domainName(string3).naptrRecords(NaptrLookup.builder().domainName(string3).customDNSServers(this.customDNSServers()).maxRetries(1).debugMode(this.m_bUseNaptrDebug)).serviceName(string5).build().resolveUNAPTR();
            }
            catch (TextParseException textParseException) {
                throw new SMPDNSResolutionException("Failed to parse '" + string3 + "'", textParseException);
            }
            if (string2 == null) {
                throw new SMPDNSResolutionException("Failed to resolve '" + string3 + "' and service '" + string5 + "' to a DNS U-NAPTR");
            }
            LOGGER.info("Resolved domain name '" + string3 + "' and service '" + string5 + "' to URL '" + string2 + "'");
            if (bl) {
                this.addDNSCacheEntry(string3, string2);
            }
        }
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SMPDNSResolutionException("Error building SMP URI from string '" + string2 + "'", uRISyntaxException);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("LowercaseValueBeforeHashing", this.m_bLowercaseValueBeforeHashing).append("AddIdentifierSchemeToZone", this.m_bAddIdentifierSchemeToZone).append("NAPTRServiceName", (Object)this.m_sNAPTRServiceName).append("UseDNSCache", this.m_bUseDNSCache).append("DNSCache", this.m_aDNSCache).append("CustomDNSServers", this.m_aCustomDNSServers).append("UseNaptrDebug", this.m_bUseNaptrDebug).getToString();
    }
}

