/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.url;

import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.smpclient.url.IPeppolURLProvider;
import com.helger.smpclient.url.PeppolNaptrURLProvider;
import com.helger.smpclient.url.PeppolURLProvider;
import com.helger.smpclient.url.SMPDNSResolutionException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;

public class PeppolConfigurableURLProvider
implements IPeppolURLProvider {
    public static final IPeppolURLProvider INSTANCE = new PeppolConfigurableURLProvider();
    public static final boolean DEFAULT_USE_NATPR = true;
    public static final AtomicBoolean USE_NATPR = new AtomicBoolean(true);

    @Nonnull
    private static IPeppolURLProvider _getRealProvider() {
        return USE_NATPR.get() ? PeppolNaptrURLProvider.INSTANCE : PeppolURLProvider.INSTANCE;
    }

    @Override
    @Nonnull
    public String getDNSNameOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string) throws SMPDNSResolutionException {
        return PeppolConfigurableURLProvider._getRealProvider().getDNSNameOfParticipant(iParticipantIdentifier, string);
    }

    @Override
    @Nonnull
    public String getDNSNameOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws SMPDNSResolutionException {
        return PeppolConfigurableURLProvider._getRealProvider().getDNSNameOfParticipant(iParticipantIdentifier, iSMLInfo);
    }

    @Override
    @Nonnull
    public URI getSMPURIOfParticipant(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nullable String string) throws SMPDNSResolutionException {
        return PeppolConfigurableURLProvider._getRealProvider().getSMPURIOfParticipant(iParticipantIdentifier, string);
    }
}

